/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class NetworkAndAddressRange {
    protected final String name;
    protected final String ipV4Range;
    protected final Optional<String> gateway;

    @ConstructorProperties(value={"name", "ipV4Range", "gateway"})
    public NetworkAndAddressRange(String name, String ipV4Range, @Nullable String gateway) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.ipV4Range = (String)Preconditions.checkNotNull((Object)ipV4Range, (Object)"ipV4Range");
        this.gateway = Optional.fromNullable((Object)gateway);
    }

    public String getName() {
        return this.name;
    }

    public String getIpV4Range() {
        return this.ipV4Range;
    }

    @Nullable
    public Optional<String> getGateway() {
        return this.gateway;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkAndAddressRange that = (NetworkAndAddressRange)NetworkAndAddressRange.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("ipV4Range", (Object)this.ipV4Range).add("gateway", this.gateway.orNull());
    }

    public String toString() {
        return this.string().toString();
    }
}

