/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.net.domain.IpProtocol;

@Beta
public final class Firewall
extends Resource {
    private final URI network;
    private final Set<String> sourceRanges;
    private final Set<String> sourceTags;
    private final Set<String> targetTags;
    private final Set<Rule> allowed;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "network", "sourceRanges", "sourceTags", "targetTags", "allowed"})
    protected Firewall(String id, Date creationTimestamp, URI selfLink, String name, String description, URI network, Set<String> sourceRanges, Set<String> sourceTags, Set<String> targetTags, Set<Rule> allowed) {
        super(Resource.Kind.FIREWALL, id, creationTimestamp, selfLink, name, description);
        this.network = (URI)Preconditions.checkNotNull((Object)network, (String)"network of %s", (Object[])new Object[]{name});
        this.sourceRanges = sourceRanges == null ? ImmutableSet.of() : sourceRanges;
        this.sourceTags = sourceTags == null ? ImmutableSet.of() : sourceTags;
        this.targetTags = targetTags == null ? ImmutableSet.of() : targetTags;
        this.allowed = allowed == null ? ImmutableSet.of() : allowed;
    }

    public URI getNetwork() {
        return this.network;
    }

    public Set<String> getSourceRanges() {
        return this.sourceRanges;
    }

    public Set<String> getSourceTags() {
        return this.sourceTags;
    }

    public Set<String> getTargetTags() {
        return this.targetTags;
    }

    public Set<Rule> getAllowed() {
        return this.allowed;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("network", (Object)this.network).add("sourceRanges", this.sourceRanges).add("sourceTags", this.sourceTags).add("targetTags", this.targetTags).add("allowed", this.allowed);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromFirewall(this);
    }

    public static final class Rule {
        private final IpProtocol ipProtocol;
        private final RangeSet<Integer> ports;

        public static Rule permitTcpRule(Integer start, Integer end) {
            return Rule.builder().IpProtocol(IpProtocol.TCP).addPortRange(start, end).build();
        }

        public static Rule permitTcpRule(Integer port) {
            return Rule.builder().IpProtocol(IpProtocol.TCP).addPort(port).build();
        }

        public static Rule permitUdpRule(Integer start, Integer end) {
            return Rule.builder().IpProtocol(IpProtocol.UDP).addPortRange(start, end).build();
        }

        public static Rule permitUdpRule(Integer port) {
            return Rule.builder().IpProtocol(IpProtocol.UDP).addPort(port).build();
        }

        @ConstructorProperties(value={"IpProtocol", "ports"})
        private Rule(IpProtocol IpProtocol2, RangeSet<Integer> ports) {
            this.ipProtocol = (IpProtocol)Preconditions.checkNotNull((Object)IpProtocol2);
            this.ports = ports == null ? TreeRangeSet.create() : ports;
        }

        public IpProtocol getIpProtocol() {
            return this.ipProtocol;
        }

        public RangeSet<Integer> getPorts() {
            return this.ports;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ipProtocol, this.ports});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Rule that = (Rule)Rule.class.cast(obj);
            return Objects.equal((Object)this.ipProtocol, (Object)that.ipProtocol) && Objects.equal(this.ports, that.ports);
        }

        public Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("IpProtocol", (Object)this.ipProtocol).add("ports", this.ports);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Rule.builder().fromFirewallRule(this);
        }

        public static final class Builder {
            private IpProtocol ipProtocol;
            private RangeSet<Integer> ports = TreeRangeSet.create();

            public Builder IpProtocol(IpProtocol IpProtocol2) {
                this.ipProtocol = IpProtocol2;
                return this;
            }

            public Builder addPort(Integer port) {
                this.ports.add(Range.singleton((Comparable)((Comparable)Preconditions.checkNotNull((Object)port, (Object)"port"))));
                return this;
            }

            public Builder addPortRange(Integer start, Integer end) {
                Preconditions.checkState(((Integer)Preconditions.checkNotNull((Object)start, (Object)"start") < (Integer)Preconditions.checkNotNull((Object)end, (Object)"end") ? 1 : 0) != 0, (Object)"start of range must be lower than end of range");
                this.ports.add(Range.closed((Comparable)start, (Comparable)end));
                return this;
            }

            public Builder ports(RangeSet<Integer> ports) {
                this.ports = TreeRangeSet.create();
                this.ports.addAll(ports);
                return this;
            }

            public Rule build() {
                return new Rule(this.ipProtocol, this.ports);
            }

            public Builder fromFirewallRule(Rule firewallRule) {
                return new Builder().IpProtocol(firewallRule.getIpProtocol()).ports(firewallRule.getPorts());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private URI network;
        private ImmutableSet.Builder<String> sourceRanges = ImmutableSet.builder();
        private ImmutableSet.Builder<String> sourceTags = ImmutableSet.builder();
        private ImmutableSet.Builder<String> targetTags = ImmutableSet.builder();
        private ImmutableSet.Builder<Rule> allowed = ImmutableSet.builder();

        public Builder network(URI network) {
            this.network = network;
            return this;
        }

        public Builder addSourceRange(String sourceRange) {
            this.sourceRanges.add(Preconditions.checkNotNull((Object)sourceRange));
            return this;
        }

        public Builder sourceRanges(Set<String> sourceRanges) {
            this.sourceRanges.addAll((Iterable)Preconditions.checkNotNull(sourceRanges));
            return this;
        }

        public Builder addSourceTag(String sourceTag) {
            this.sourceTags.add(Preconditions.checkNotNull((Object)sourceTag));
            return this;
        }

        public Builder sourceTags(Set<String> sourceTags) {
            this.sourceTags.addAll((Iterable)Preconditions.checkNotNull(sourceTags));
            return this;
        }

        public Builder addTargetTag(String targetTag) {
            this.targetTags.add(Preconditions.checkNotNull((Object)targetTag));
            return this;
        }

        public Builder targetTags(Set<String> targetTags) {
            this.targetTags.addAll((Iterable)Preconditions.checkNotNull(targetTags));
            return this;
        }

        public Builder addAllowed(Rule firewallRule) {
            this.allowed.add(Preconditions.checkNotNull((Object)firewallRule));
            return this;
        }

        public Builder allowed(Set<Rule> firewallRules) {
            this.allowed = ImmutableSet.builder();
            this.allowed.addAll(firewallRules);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Firewall build() {
            return new Firewall(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.network, (Set<String>)this.sourceRanges.build(), (Set<String>)this.sourceTags.build(), (Set<String>)this.targetTags.build(), (Set<Rule>)this.allowed.build());
        }

        public Builder fromFirewall(Firewall in) {
            return ((Builder)super.fromResource(in)).network(in.getNetwork()).sourceRanges(in.getSourceRanges()).sourceTags(in.getSourceTags()).targetTags(in.getTargetTags()).allowed(in.getAllowed());
        }
    }
}

