/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Map;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.MachineTypeInZone;
import org.jclouds.googlecomputeengine.domain.SlashEncodedIds;

public class MachineTypeInZoneToHardware
implements Function<MachineTypeInZone, Hardware> {
    private final Supplier<Map<URI, ? extends Location>> locations;

    @Inject
    public MachineTypeInZoneToHardware(@Memoized Supplier<Map<URI, ? extends Location>> locations) {
        this.locations = locations;
    }

    public Hardware apply(final MachineTypeInZone input) {
        Iterable zonesForMachineType = Iterables.filter(((Map)this.locations.get()).values(), (Predicate)new Predicate<Location>(){

            public boolean apply(Location l) {
                return l.getId().equals(input.getMachineType().getZone());
            }
        });
        Location location = (Location)Preconditions.checkNotNull((Object)Iterables.getOnlyElement((Iterable)zonesForMachineType), (String)"location for %s", (Object[])new Object[]{input.getMachineType().getZone()});
        return new HardwareBuilder().id(SlashEncodedIds.fromTwoIds(input.getMachineType().getZone(), input.getMachineType().getName()).slashEncode()).location(location).name(input.getMachineType().getName()).hypervisor("kvm").processor(new Processor((double)input.getMachineType().getGuestCpus(), 1.0)).providerId(input.getMachineType().getId()).ram(input.getMachineType().getMemoryMb()).uri(input.getMachineType().getSelfLink()).volumes(this.collectVolumes(input.getMachineType())).supportsImage(Predicates.alwaysTrue()).build();
    }

    private Iterable<Volume> collectVolumes(MachineType input) {
        ImmutableSet.Builder volumes = ImmutableSet.builder();
        for (MachineType.ScratchDisk disk : input.getScratchDisks()) {
            volumes.add((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(new Integer(disk.getDiskGb()).floatValue())).bootDevice(true).durable(false).build());
        }
        return volumes.build();
    }
}

