/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.javax.annotation.Nullable;

public class HardwareImpl
extends ComputeMetadataImpl
implements Hardware {
    private final List<Processor> processors;
    private final int ram;
    private final List<Volume> volumes;
    private final Predicate<Image> supportsImage;
    private final String hypervisor;

    public HardwareImpl(String providerId, String name, String id, @Nullable Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, Iterable<? extends Processor> processors, int ram, Iterable<? extends Volume> volumes, Predicate<Image> supportsImage, @Nullable String hypervisor) {
        super(ComputeType.HARDWARE, providerId, name, id, location, uri, userMetadata, tags);
        this.processors = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(processors, (Object)"processors")));
        this.ram = ram;
        this.volumes = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(volumes, (Object)"volumes")));
        this.supportsImage = supportsImage;
        this.hypervisor = hypervisor;
    }

    @Override
    public List<? extends Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public int getRam() {
        return this.ram;
    }

    @Override
    public List<? extends Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    @Override
    public int compareTo(ResourceMetadata<ComputeType> that) {
        if (that instanceof Hardware) {
            Hardware thatHardware = (Hardware)Hardware.class.cast(that);
            return ComparisonChain.start().compare(ComputeServiceUtils.getCores(this), ComputeServiceUtils.getCores(thatHardware)).compare(this.getRam(), thatHardware.getRam()).compare(ComputeServiceUtils.getSpace(this), ComputeServiceUtils.getSpace(thatHardware)).result();
        }
        return super.compareTo(that);
    }

    @Override
    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper helper = this.computeToStringPrefix();
        helper.add("processors", this.processors).add("ram", this.ram);
        if (this.volumes.size() > 0) {
            helper.add("volumes", this.volumes);
        }
        helper.add("hypervisor", (Object)this.hypervisor);
        helper.add("supportsImage", this.supportsImage);
        return this.addComputeToStringSuffix(helper);
    }

    @Override
    public Predicate<Image> supportsImage() {
        return this.supportsImage;
    }
}

