/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.Objects;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RevisionsKey
implements CacheValue,
Comparable<RevisionsKey> {
    private static final Logger log = LoggerFactory.getLogger(RevisionsKey.class);
    private final RevisionVector r1;
    private final RevisionVector r2;

    public RevisionsKey(RevisionVector r1, RevisionVector r2) {
        this.r1 = Objects.requireNonNull(r1);
        this.r2 = Objects.requireNonNull(r2);
    }

    public RevisionVector getRev1() {
        return this.r1;
    }

    public RevisionVector getRev2() {
        return this.r2;
    }

    public int getMemory() {
        long size = 32L + (long)this.r1.getMemory() + (long)this.r2.getMemory();
        if (size > Integer.MAX_VALUE) {
            log.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RevisionsKey)) {
            return false;
        }
        RevisionsKey other = (RevisionsKey)obj;
        return this.r1.equals(other.r1) && this.r2.equals(other.r2);
    }

    public int hashCode() {
        return this.r1.hashCode() ^ this.r2.hashCode();
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return String.valueOf(this.r1) + "/" + String.valueOf(this.r2);
    }

    @Override
    public int compareTo(@NotNull RevisionsKey k) {
        int c = this.r1.compareTo(k.r1);
        if (c != 0) {
            return c;
        }
        return this.r2.compareTo(k.r2);
    }

    public static RevisionsKey fromString(String s) {
        int idx = s.indexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(s);
        }
        return new RevisionsKey(RevisionVector.fromString(s.substring(0, idx)), RevisionVector.fromString(s.substring(idx + 1)));
    }
}

