/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.util.Precision;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.jetbrains.annotations.NotNull;

public final class MongoThrottlerFactory {
    private MongoThrottlerFactory() {
    }

    public static Throttler exponentialThrottler(int threshold, AtomicReference<Double> oplogWindow, long throttlingTime) {
        Objects.requireNonNull(oplogWindow);
        return new ExponentialThrottler(threshold, oplogWindow, throttlingTime);
    }

    public static Throttler extFactorThrottler(AtomicReference<Integer> factor, long time) {
        Objects.requireNonNull(factor);
        return new ExtFactorThrottler(factor, time);
    }

    public static Throttler noThrottler() {
        return Throttler.NO_THROTTLING;
    }

    private static class ExtFactorThrottler
    implements Throttler {
        @NotNull
        private final AtomicReference<Integer> factor;
        private final long time;

        public ExtFactorThrottler(@NotNull AtomicReference<Integer> factor, long time) {
            this.factor = factor;
            this.time = time;
        }

        @Override
        public long throttlingTime() {
            if (this.factor.get() <= 0) {
                return 0L;
            }
            return this.time * (long)this.factor.get().intValue();
        }
    }

    private static class ExponentialThrottler
    implements Throttler {
        private final int threshold;
        @NotNull
        private final AtomicReference<Double> oplogWindow;
        private final long throttlingTime;

        public ExponentialThrottler(int threshold, @NotNull AtomicReference<Double> oplogWindow, long throttlingTime) {
            this.threshold = threshold;
            this.oplogWindow = oplogWindow;
            this.throttlingTime = throttlingTime;
        }

        @Override
        public long throttlingTime() {
            double threshold = this.threshold;
            double oplogWindow = this.oplogWindow.get();
            long throttleTime = this.throttlingTime;
            throttleTime = Precision.compareTo((double)oplogWindow, (double)(threshold / 8.0), (double)0.001) <= 0 ? (throttleTime *= 8L) : (Precision.compareTo((double)oplogWindow, (double)(threshold / 4.0), (double)0.001) <= 0 ? (throttleTime *= 4L) : (Precision.compareTo((double)oplogWindow, (double)(threshold / 2.0), (double)0.001) <= 0 ? (throttleTime *= 2L) : (Precision.compareTo((double)oplogWindow, (double)threshold, (double)0.001) <= 0 ? this.throttlingTime : 0L)));
            return throttleTime;
        }
    }
}

