/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStoreThrottlingFactorUpdater
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStoreThrottlingFactorUpdater.class);
    private static final String SETTINGS = "settings";
    private static final String ENABLE = "enable";
    private static final String FACTOR = "factor";
    private static final String TS_TIME = "ts";
    public static final String SIZE = "size";
    private final ScheduledExecutorService throttlingFactorExecutor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicReference<Integer> factorRef;
    private final MongoDatabase localDb;
    private final int period;

    public MongoDocumentStoreThrottlingFactorUpdater(@NotNull MongoDatabase localDb, @NotNull AtomicReference<Integer> factor, int period) {
        this.factorRef = factor;
        this.localDb = localDb;
        this.period = period;
    }

    public void scheduleFactorUpdates() {
        this.throttlingFactorExecutor.scheduleAtFixedRate(() -> this.factorRef.set(this.updateFactor()), 10L, this.period, TimeUnit.SECONDS);
    }

    public int updateFactor() {
        Document document = this.localDb.runCommand((Bson)new Document("throttling", (Object)SETTINGS));
        if (!(document.containsKey((Object)ENABLE) && document.containsKey((Object)FACTOR) && document.containsKey((Object)TS_TIME))) {
            LOG.warn("Could not get values for settings.{} collection. Document returned: {}. Setting throttling factor to 0", (Object)"throttling", (Object)document);
            return 0;
        }
        if (!document.getBoolean((Object)ENABLE).booleanValue()) {
            LOG.debug("Throttling has been disabled. Setting throttling factor to 0.");
            return 0;
        }
        long ts = document.getLong((Object)TS_TIME);
        long now = System.currentTimeMillis();
        if (now - ts > 3600000L) {
            LOG.warn("Throttling timestamp is older than 1 hour. Setting throttling factor to 0");
            return 0;
        }
        int factor = document.getInteger((Object)FACTOR, 0);
        if (factor <= 0) {
            LOG.warn("Throttling factor is less than or equal to 0. Setting throttling factor to 0");
            return 0;
        }
        return factor;
    }

    @Override
    public void close() throws IOException {
        new ExecutorCloser((ExecutorService)this.throttlingFactorExecutor).close();
    }
}

