/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.internal.function.Suppliers;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoClock;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDBConnection;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.jetbrains.annotations.NotNull;

public abstract class MongoDocumentNodeStoreBuilderBase<T extends MongoDocumentNodeStoreBuilderBase<T>>
extends DocumentNodeStoreBuilder<T> {
    private final MongoClock mongoClock = new MongoClock();
    @Deprecated
    private boolean socketKeepAlive = true;
    private MongoStatus mongoStatus;
    private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);
    private boolean clientSessionDisabled = false;
    private Integer leaseSocketTimeout;
    private String uri;
    private String name;
    private String collectionCompressionType;
    private MongoClient mongoClient;
    private Integer maxPoolSize;
    private Integer minPoolSize;
    private Integer maxConnecting;
    private Integer maxIdleTimeMillis;
    private Integer maxLifeTimeMillis;
    private Integer connectTimeoutMillis;
    private Integer heartbeatFrequencyMillis;
    private Integer serverSelectionTimeoutMillis;
    private Integer waitQueueTimeoutMillis;
    private Integer readTimeoutMillis;
    private Integer minHeartbeatFrequencyMillis;

    public T setMongoDB(@NotNull String uri, @NotNull String name, int blobCacheSizeMB) {
        this.uri = uri;
        this.name = name;
        this.setMongoDB(this.createMongoDBClient(false), blobCacheSizeMB);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName, int blobCacheSizeMB) {
        return this.setMongoDB(new MongoDBConnection(client, client.getDatabase(dbName), new MongoStatus(client, dbName), this.mongoClock), blobCacheSizeMB);
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName) {
        return this.setMongoDB(client, dbName, 16);
    }

    @Deprecated
    public T setSocketKeepAlive(boolean enable) {
        this.socketKeepAlive = enable;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    @Deprecated
    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public T setClientSessionDisabled(boolean b) {
        this.clientSessionDisabled = b;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    boolean isClientSessionDisabled() {
        return this.clientSessionDisabled;
    }

    public T setLeaseSocketTimeout(int timeoutMillis) {
        this.leaseSocketTimeout = timeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMaxConnecting(int maxConnecting) {
        this.maxConnecting = maxConnecting;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMaxIdleTimeMillis(int maxIdleTimeMillis) {
        this.maxIdleTimeMillis = maxIdleTimeMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMaxLifeTimeMillis(int maxLifeTimeMillis) {
        this.maxLifeTimeMillis = maxLifeTimeMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoHeartbeatFrequencyMillis(int heartbeatFrequencyMillis) {
        this.heartbeatFrequencyMillis = heartbeatFrequencyMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoServerSelectionTimeoutMillis(int serverSelectionTimeoutMillis) {
        this.serverSelectionTimeoutMillis = serverSelectionTimeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoWaitQueueTimeoutMillis(int waitQueueTimeoutMillis) {
        this.waitQueueTimeoutMillis = waitQueueTimeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoMinHeartbeatFrequencyMillis(int minHeartbeatFrequencyMillis) {
        this.minHeartbeatFrequencyMillis = minHeartbeatFrequencyMillis;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    int getLeaseSocketTimeout() {
        return this.leaseSocketTimeout != null ? this.leaseSocketTimeout : 0;
    }

    boolean hasLeaseSocketTimeout() {
        return this.leaseSocketTimeout != null;
    }

    MongoClientSettings buildMongoClientSettings(boolean isLease) {
        MongoClientSettings.Builder options = MongoConnection.getDefaultBuilder();
        options.applyConnectionString(new ConnectionString(this.uri));
        int socketTimeout = isLease ? (this.leaseSocketTimeout != null ? this.leaseSocketTimeout : 30000) : (this.readTimeoutMillis != null && this.readTimeoutMillis > 0 ? this.readTimeoutMillis : 0);
        options.applyToConnectionPoolSettings(poolBuilder -> {
            if (this.maxPoolSize != null) {
                poolBuilder.maxSize(this.maxPoolSize.intValue());
            }
            if (this.minPoolSize != null) {
                poolBuilder.minSize(this.minPoolSize.intValue());
            }
            if (this.maxConnecting != null) {
                poolBuilder.maxConnecting(this.maxConnecting.intValue());
            }
            if (this.maxIdleTimeMillis != null) {
                poolBuilder.maxConnectionIdleTime((long)this.maxIdleTimeMillis.intValue(), TimeUnit.MILLISECONDS);
            }
            if (this.maxLifeTimeMillis != null) {
                poolBuilder.maxConnectionLifeTime((long)this.maxLifeTimeMillis.intValue(), TimeUnit.MILLISECONDS);
            }
            if (this.waitQueueTimeoutMillis != null) {
                poolBuilder.maxWaitTime((long)this.waitQueueTimeoutMillis.intValue(), TimeUnit.MILLISECONDS);
            }
        });
        options.applyToSocketSettings(socketBuilder -> {
            if (socketTimeout > 0) {
                socketBuilder.readTimeout((long)socketTimeout, TimeUnit.MILLISECONDS);
            }
            if (this.connectTimeoutMillis != null) {
                socketBuilder.connectTimeout((long)this.connectTimeoutMillis.intValue(), TimeUnit.MILLISECONDS);
            }
        });
        options.applyToServerSettings(serverBuilder -> {
            if (this.heartbeatFrequencyMillis != null && this.heartbeatFrequencyMillis > 0) {
                serverBuilder.heartbeatFrequency((long)this.heartbeatFrequencyMillis.intValue(), TimeUnit.MILLISECONDS);
            }
            if (this.minHeartbeatFrequencyMillis != null && this.minHeartbeatFrequencyMillis > 0) {
                serverBuilder.minHeartbeatFrequency((long)this.minHeartbeatFrequencyMillis.intValue(), TimeUnit.MILLISECONDS);
            }
        });
        options.applyToClusterSettings(clusterBuilder -> {
            if (this.serverSelectionTimeoutMillis != null) {
                clusterBuilder.serverSelectionTimeout((long)this.serverSelectionTimeoutMillis.intValue(), TimeUnit.MILLISECONDS);
            }
        });
        return options.build();
    }

    public T setMaxReplicationLag(long duration, TimeUnit unit) {
        this.maxReplicationLagMillis = unit.toMillis(duration);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setCollectionCompressionType(String compressionType) {
        this.collectionCompressionType = compressionType;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoVersionGCSupport((MongoDocumentStore)store, this.isFullGCAuditLoggingEnabled());
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return () -> new MongoBlobReferenceIterator(ns, (MongoDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }

    @Override
    public MissingLastRevSeeker createMissingLastRevSeeker() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoMissingLastRevSeeker((MongoDocumentStore)store, this.getClock());
        }
        return super.createMissingLastRevSeeker();
    }

    public String getCollectionCompressionType() {
        return this.collectionCompressionType;
    }

    MongoStatus getMongoStatus() {
        return this.mongoStatus;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    long getMaxReplicationLagMillis() {
        return this.maxReplicationLagMillis;
    }

    MongoClock getMongoClock() {
        return this.mongoClock;
    }

    MongoDBConnection createMongoDBClient(boolean isLease) {
        if (this.uri == null || this.name == null) {
            throw new IllegalStateException("Cannot create MongoDB client without 'uri' or 'name'");
        }
        MongoClientSettings settings = this.buildMongoClientSettings(isLease);
        return MongoDBConnection.newMongoDBConnection(this.uri, this.name, this.mongoClock, settings);
    }

    private T setMongoDB(@NotNull MongoDBConnection mongoDBConnection, int blobCacheSizeMB) {
        mongoDBConnection.checkReadWriteConcern();
        this.mongoClient = mongoDBConnection.getClient();
        this.mongoStatus = mongoDBConnection.getStatus();
        this.documentStoreSupplier = Suppliers.memoize(() -> new MongoDocumentStore(mongoDBConnection.getClient(), mongoDBConnection.getDatabase(), this));
        if (this.blobStoreSupplier == null) {
            this.blobStoreSupplier = Suppliers.memoize(() -> new MongoBlobStore(mongoDBConnection.getDatabase(), (long)(blobCacheSizeMB * 1024) * 1024L, this));
        }
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }
}

