/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.plugins.document.Configuration;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

final class DocumentNodeStoreServiceConfiguration {
    private static final String DEFAULT_FWK_PREFIX = "oak.documentstore.";
    private static final String FWK_PROP_URI = "oak.mongo.uri";
    private static final String FWK_PROP_DB = "oak.mongo.db";
    private static final String FWK_PROP_SO_KEEP_ALIVE = "oak.mongo.socketKeepAlive";
    private static final String FWK_PROP_MONGO_LEASE_SO_TIMEOUT = "oak.mongo.leaseSocketTimeout";
    private static final String FWK_PROP_MONGO_MAX_POOL_SIZE = "oak.mongo.maxPoolSize";
    private static final String FWK_PROP_MONGO_MIN_POOL_SIZE = "oak.mongo.minPoolSize";
    private static final String FWK_PROP_MONGO_MAX_CONNECTING = "oak.mongo.maxConnecting";
    private static final String FWK_PROP_MONGO_MAX_IDLE_TIME_MILLIS = "oak.mongo.maxIdleTimeMillis";
    private static final String FWK_PROP_MONGO_MAX_LIFE_TIME_MILLIS = "oak.mongo.maxLifeTimeMillis";
    private static final String FWK_PROP_MONGO_CONNECT_TIMEOUT_MILLIS = "oak.mongo.connectTimeoutMillis";
    private static final String FWK_PROP_MONGO_HEARTBEAT_FREQUENCY_MILLIS = "oak.mongo.heartbeatFrequencyMillis";
    private static final String FWK_PROP_MONGO_SERVER_SELECTION_TIMEOUT_MILLIS = "oak.mongo.serverSelectionTimeoutMillis";
    private static final String FWK_PROP_MONGO_WAIT_QUEUE_TIMEOUT_MILLIS = "oak.mongo.waitQueueTimeoutMillis";
    private static final String FWK_PROP_MONGO_READ_TIMEOUT_MILLIS = "oak.mongo.readTimeoutMillis";
    private static final String FWK_PROP_MONGO_MIN_HEARTBEAT_FREQUENCY_MILLIS = "oak.mongo.minHeartbeatFrequencyMillis";
    private static final String FWK_PROP_UPDATE_LIMIT = "update.limit";
    private static final String PROP_DB = "db";
    private static final String PROP_URI = "mongouri";
    private static final String PROP_HOME = "repository.home";
    static final String PROP_SO_KEEP_ALIVE = "socketKeepAlive";
    static final String PROP_LEASE_SO_TIMEOUT = "leaseSocketTimeout";
    static final String PROP_UPDATE_LIMIT = "updateLimit";
    static final String PROP_MONGO_MAX_POOL_SIZE = "mongoMaxPoolSize";
    static final String PROP_MONGO_MIN_POOL_SIZE = "mongoMinPoolSize";
    static final String PROP_MONGO_MAX_CONNECTING = "mongoMaxConnecting";
    static final String PROP_MONGO_MAX_IDLE_TIME_MILLIS = "mongoMaxIdleTimeMillis";
    static final String PROP_MONGO_MAX_LIFE_TIME_MILLIS = "mongoMaxLifeTimeMillis";
    static final String PROP_MONGO_CONNECT_TIMEOUT_MILLIS = "mongoConnectTimeoutMillis";
    static final String PROP_MONGO_HEARTBEAT_FREQUENCY_MILLIS = "mongoHeartbeatFrequencyMillis";
    static final String PROP_MONGO_SERVER_SELECTION_TIMEOUT_MILLIS = "mongoServerSelectionTimeoutMillis";
    static final String PROP_MONGO_WAIT_QUEUE_TIMEOUT_MILLIS = "mongoWaitQueueTimeoutMillis";
    static final String PROP_MONGO_READ_TIMEOUT_MILLIS = "mongoReadTimeoutMillis";
    static final String PROP_MONGO_MIN_HEARTBEAT_FREQUENCY_MILLIS = "mongoMinHeartbeatFrequencyMillis";
    private static final Map<String, String> FWK_PROP_MAPPING = Map.ofEntries(Map.entry("db", "oak.mongo.db"), Map.entry("mongouri", "oak.mongo.uri"), Map.entry("repository.home", "repository.home"), Map.entry("socketKeepAlive", "oak.mongo.socketKeepAlive"), Map.entry("leaseSocketTimeout", "oak.mongo.leaseSocketTimeout"), Map.entry("updateLimit", "update.limit"), Map.entry("mongoMaxPoolSize", "oak.mongo.maxPoolSize"), Map.entry("mongoMinPoolSize", "oak.mongo.minPoolSize"), Map.entry("mongoMaxConnecting", "oak.mongo.maxConnecting"), Map.entry("mongoMaxIdleTimeMillis", "oak.mongo.maxIdleTimeMillis"), Map.entry("mongoMaxLifeTimeMillis", "oak.mongo.maxLifeTimeMillis"), Map.entry("mongoConnectTimeoutMillis", "oak.mongo.connectTimeoutMillis"), Map.entry("mongoHeartbeatFrequencyMillis", "oak.mongo.heartbeatFrequencyMillis"), Map.entry("mongoServerSelectionTimeoutMillis", "oak.mongo.serverSelectionTimeoutMillis"), Map.entry("mongoWaitQueueTimeoutMillis", "oak.mongo.waitQueueTimeoutMillis"), Map.entry("mongoReadTimeoutMillis", "oak.mongo.readTimeoutMillis"), Map.entry("mongoMinHeartbeatFrequencyMillis", "oak.mongo.minHeartbeatFrequencyMillis"));

    private DocumentNodeStoreServiceConfiguration() {
    }

    static Configuration create(ComponentContext context, ConfigurationAdmin configurationAdmin, Configuration preset, Configuration configuration) throws IOException {
        return (Configuration)Proxy.newProxyInstance(DocumentNodeStoreServiceConfiguration.class.getClassLoader(), new Class[]{Configuration.class}, (InvocationHandler)new ConfigurationHandler(context, configurationAdmin, preset, configuration));
    }

    private static String frameworkPropertyNameFor(String propertyName) {
        Object fwkPropName = FWK_PROP_MAPPING.get(propertyName);
        if (fwkPropName == null) {
            fwkPropName = DEFAULT_FWK_PREFIX + propertyName;
        }
        return fwkPropName;
    }

    private static final class ConfigurationHandler
    implements InvocationHandler {
        private final ComponentContext context;
        private final Configuration preset;
        private final Configuration configuration;
        private final Set<String> configurationKeys;

        ConfigurationHandler(ComponentContext context, ConfigurationAdmin configurationAdmin, Configuration preset, Configuration configuration) throws IOException {
            this.context = Objects.requireNonNull(context);
            this.preset = Objects.requireNonNull(preset);
            this.configuration = Objects.requireNonNull(configuration);
            this.configurationKeys = ConfigurationHandler.getConfigurationKeys(Objects.requireNonNull(configurationAdmin));
        }

        private static Set<String> getConfigurationKeys(ConfigurationAdmin configurationAdmin) throws IOException {
            HashSet<String> keys = new HashSet<String>();
            org.osgi.service.cm.Configuration c = configurationAdmin.getConfiguration("org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService");
            for (Object k : Collections.list(c.getProperties().keys())) {
                keys.add(k.toString());
            }
            return keys;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName().replaceAll("_", ".");
            Configuration c = this.configurationKeys.contains(name) ? this.configuration : this.preset;
            Object value = method.invoke((Object)c, new Object[0]);
            String frameworkProp = OsgiUtil.lookup((BundleContext)this.context.getBundleContext(), (String)DocumentNodeStoreServiceConfiguration.frameworkPropertyNameFor(name));
            if (frameworkProp != null) {
                value = this.tryCoerce(frameworkProp, method.getReturnType(), value);
            }
            return value;
        }

        private Object tryCoerce(String value, Class<?> type, Object defaultValue) {
            Object obj;
            if (type == Boolean.class || type == Boolean.TYPE) {
                obj = Boolean.parseBoolean(value);
            } else if (type == Integer.class || type == Integer.TYPE) {
                try {
                    obj = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    obj = defaultValue;
                }
            } else if (type == Long.class || type == Long.TYPE) {
                try {
                    obj = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    obj = defaultValue;
                }
            } else {
                obj = type == String.class ? value : (type == String[].class ? String.valueOf(value).split("::") : defaultValue);
            }
            return obj;
        }
    }
}

