/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.oak.plugins.document.CommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

final class CachingCommitValueResolver
implements CommitValueResolver {
    private static final List<String> COMMIT_ROOT_OR_REVISIONS = List.of("_commitRoot", "_revisions");
    private final Cache<Revision, String> commitValueCache;
    private final int cacheSize;
    private final Supplier<RevisionVector> sweepRevisions;

    CachingCommitValueResolver(int cacheSize, Supplier<RevisionVector> sweepRevisions) {
        this.commitValueCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
        this.cacheSize = cacheSize;
        this.sweepRevisions = sweepRevisions;
    }

    CommitValueResolver withEmptyCommitValueCache(boolean enable, final Clock clock, final long maxAgeMillis) {
        if (enable) {
            return new CommitValueResolver(){
                private final Cache<Revision, String> emptyCommitValueCache;
                {
                    this.emptyCommitValueCache = CacheBuilder.newBuilder().maximumSize((long)CachingCommitValueResolver.this.cacheSize).build();
                }

                @Override
                public String resolve(@NotNull Revision changeRevision, @NotNull NodeDocument doc) {
                    String value = (String)CachingCommitValueResolver.this.commitValueCache.getIfPresent((Object)changeRevision);
                    if (value != null) {
                        return value;
                    }
                    if (this.emptyCommitValueCache.getIfPresent((Object)changeRevision) != null) {
                        return null;
                    }
                    value = CachingCommitValueResolver.this.resolve(changeRevision, doc);
                    if (value == null && this.isOld(changeRevision, clock, maxAgeMillis)) {
                        this.emptyCommitValueCache.put((Object)changeRevision, (Object)"");
                    }
                    return value;
                }

                private boolean isOld(Revision r, Clock c, long maxAgeMillis2) {
                    return r.getTimestamp() + maxAgeMillis2 < c.getTime();
                }
            };
        }
        return this;
    }

    @Override
    public String resolve(@NotNull Revision changeRevision, @NotNull NodeDocument doc) {
        String value = (String)this.commitValueCache.getIfPresent((Object)changeRevision);
        if (value != null) {
            return value;
        }
        if ((doc = this.resolveDocument(doc, changeRevision)) == null) {
            return null;
        }
        if (this.sweepRevisions.get().isRevisionNewer(changeRevision)) {
            value = doc.resolveCommitValue(changeRevision);
        } else {
            NodeDocument.SplitDocType sdt = doc.getSplitDocType();
            if (sdt == NodeDocument.SplitDocType.NONE) {
                value = doc.getLocalBranchCommits().contains(changeRevision) ? doc.resolveCommitValue(changeRevision) : "c";
            } else if (sdt == NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
                value = "c";
            } else {
                value = doc.resolveCommitValue(changeRevision);
                if (value == null) {
                    value = "c";
                }
            }
        }
        if (Utils.isCommitted(value)) {
            try {
                this.commitValueCache.put((Object)changeRevision, (Object)value);
            }
            catch (RuntimeException re) {
                LoggerFactory.getLogger(this.getClass()).warn("resolve: RuntimeException with " + String.valueOf(changeRevision) + " - " + value, (Throwable)re);
            }
        }
        return value;
    }

    @Nullable
    private NodeDocument resolveDocument(@NotNull NodeDocument doc, @NotNull Revision changeRevision) {
        if (doc.getLocalCommitRoot().containsKey(changeRevision) || doc.getLocalRevisions().containsKey(changeRevision)) {
            return doc;
        }
        NodeDocument d = null;
        for (String p : COMMIT_ROOT_OR_REVISIONS) {
            Iterator<NodeDocument> iterator = doc.getPreviousDocs(p, changeRevision).iterator();
            if (iterator.hasNext()) {
                NodeDocument prev;
                d = prev = iterator.next();
            }
            if (d == null) continue;
            break;
        }
        return d;
    }
}

