/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDocumentNodeBuilder
extends MemoryNodeBuilder {
    public AbstractDocumentNodeBuilder(@NotNull NodeState base) {
        super(base);
    }

    protected AbstractDocumentNodeBuilder(MemoryNodeBuilder parent, String name) {
        super(parent, name);
    }

    @NotNull
    public NodeBuilder setChildNode(@NotNull String name, @NotNull NodeState state) {
        NodeBuilder builder = super.setChildNode(name, EmptyNodeState.EMPTY_NODE);
        for (PropertyState property : state.getProperties()) {
            builder.setProperty(property);
        }
        for (ChildNodeEntry child : state.getChildNodeEntries()) {
            builder.setChildNode(child.getName(), child.getNodeState());
        }
        return builder;
    }

    protected abstract DocumentNodeBuilder createChildBuilder(String var1);

    @NotNull
    public DocumentNodeBuilder getChildNode(@NotNull String name) {
        AbstractNodeState.checkValidName((String)name);
        return this.createChildBuilder(name);
    }
}

