/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncHandlerMapping;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncHandlerMappingTracker
extends ServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(SyncHandlerMappingTracker.class);
    private final Map<ServiceReference, Mapping> referenceMap = new HashMap<ServiceReference, Mapping>();

    SyncHandlerMappingTracker(@NotNull BundleContext context) {
        super(context, SyncHandlerMapping.class.getName(), null);
    }

    public Object addingService(ServiceReference reference) {
        this.addMapping(reference);
        return super.addingService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.addMapping(reference);
        super.modifiedService(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.referenceMap.remove(reference);
        super.removedService(reference, service);
    }

    private void addMapping(ServiceReference reference) {
        String idpName = PropertiesUtil.toString((Object)reference.getProperty("idp.name"), null);
        String syncHandlerName = PropertiesUtil.toString((Object)reference.getProperty("sync.handlerName"), null);
        if (idpName != null && syncHandlerName != null) {
            this.referenceMap.put(reference, new Mapping(syncHandlerName, idpName));
        } else {
            log.warn("Ignoring SyncHandlerMapping with incomplete mapping of IDP '{}' and SyncHandler '{}'", (Object)idpName, (Object)syncHandlerName);
        }
    }

    Iterable<String> getIdpNames(@NotNull String syncHandlerName) {
        return IterableUtils.filter((Iterable)IterableUtils.transform(this.referenceMap.values(), mapping -> {
            if (syncHandlerName.equals(mapping.syncHandlerName)) {
                return mapping.idpName;
            }
            return null;
        }), x -> x != null);
    }

    private static final class Mapping {
        private final String syncHandlerName;
        private final String idpName;

        private Mapping(@NotNull String syncHandlerName, @NotNull String idpName) {
            this.syncHandlerName = syncHandlerName;
            this.idpName = idpName;
        }
    }
}

