/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipAware;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncHandlerMappingTracker;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncConfigTracker
extends ServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(SyncConfigTracker.class);
    private final SyncHandlerMappingTracker mappingTracker;

    SyncConfigTracker(@NotNull BundleContext context, @NotNull SyncHandlerMappingTracker mappingTracker) {
        super(context, OsgiUtil.getFilter(SyncHandler.class, Collections.singletonMap("user.dynamicMembership", Boolean.TRUE.toString())), null);
        this.mappingTracker = mappingTracker;
    }

    boolean isEnabled() {
        return this.getReferences().length > 0;
    }

    boolean hasDynamicGroupsEnabled() {
        if (!this.isEnabled()) {
            return false;
        }
        for (ServiceReference ref : this.getReferences()) {
            if (!PropertiesUtil.toBoolean((Object)ref.getProperty("group.dynamicGroups"), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<String> getIdpNamesWithDynamicGroups() {
        if (!this.isEnabled()) {
            return Collections.emptySet();
        }
        ServiceReference[] serviceReferences = this.getServiceReferences();
        HashSet<String> idpNames = new HashSet<String>(serviceReferences.length);
        for (ServiceReference ref : serviceReferences) {
            if (!PropertiesUtil.toBoolean((Object)ref.getProperty("group.dynamicGroups"), (boolean)false)) continue;
            String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
            for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
                idpNames.add(idpName);
            }
        }
        return idpNames;
    }

    @NotNull
    Map<String, String[]> getAutoMembership() {
        HashMap<String, String[]> autoMembership = new HashMap<String, String[]>();
        for (ServiceReference ref : this.getReferences()) {
            String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
            Object[] userAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("user.autoMembership"), (String[])new String[0]);
            Object[] groupAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("group.autoMembership"), (String[])new String[0]);
            this.populateMap(syncHandlerName, (String[])ArrayUtils.addAll((Object[])userAuthMembership, (Object[])groupAuthMembership), autoMembership);
        }
        return autoMembership;
    }

    @NotNull
    Map<String, String[]> getGroupAutoMembership() {
        HashMap<String, String[]> autoMembership = new HashMap<String, String[]>();
        for (ServiceReference ref : this.getReferences()) {
            String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
            String[] groupAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("group.autoMembership"), (String[])new String[0]);
            this.populateMap(syncHandlerName, groupAuthMembership, autoMembership);
        }
        return autoMembership;
    }

    private void populateMap(@NotNull String syncHandlerName, @NotNull String[] autoMembershipParam, @NotNull Map<String, String[]> autoMembership) {
        for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
            Object[] previous = autoMembership.put(idpName, autoMembershipParam);
            if (previous == null) continue;
            String msg = Arrays.equals(previous, autoMembershipParam) ? "Duplicate" : "Colliding";
            String prev = Arrays.toString(previous);
            String mbrs = Arrays.toString(autoMembershipParam);
            log.debug("{} group auto-membership configuration for IDP '{}'; replacing previous values {} by {} defined by SyncHandler '{}'", new Object[]{msg, idpName, prev, mbrs, syncHandlerName});
        }
    }

    @NotNull
    Map<String, AutoMembershipConfig> getAutoMembershipConfig() {
        HashMap<String, AutoMembershipConfig> amMap = new HashMap<String, AutoMembershipConfig>();
        for (ServiceReference ref : this.getReferences()) {
            String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
            Object shService = this.getService(ref);
            if (!(shService instanceof AutoMembershipAware)) continue;
            AutoMembershipConfig config = ((AutoMembershipAware)shService).getAutoMembershipConfig();
            for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
                AutoMembershipConfig previous = amMap.put(idpName, config);
                if (previous == null) continue;
                String msg = previous.equals(config) ? "Duplicate" : "Colliding";
                log.debug("{} auto-membership configuration for IDP '{}'; replacing previous values {} by {} defined by SyncHandler '{}'", new Object[]{msg, idpName, previous, config, syncHandlerName});
            }
        }
        return amMap;
    }

    @NotNull
    private ServiceReference[] getReferences() {
        ServiceReference[] refs = this.getServiceReferences();
        return refs == null ? new ServiceReference[]{} : refs;
    }
}

