/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ProtectionConfig;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

class ProtectionConfigTracker
extends ServiceTracker
implements ProtectionConfig {
    public ProtectionConfigTracker(@NotNull BundleContext context) {
        super(context, ProtectionConfig.class.getName(), null);
    }

    @Override
    public boolean isProtectedProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        for (ProtectionConfig pe : this.getProtectionConfigs()) {
            if (!pe.isProtectedProperty(parent, property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProtectedTree(@NotNull Tree tree) {
        for (ProtectionConfig pe : this.getProtectionConfigs()) {
            if (!pe.isProtectedTree(tree)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Iterable<ProtectionConfig> getProtectionConfigs() {
        Object[] services = this.getServices();
        if (services == null) {
            return Collections.singletonList(ProtectionConfig.DEFAULT);
        }
        return Arrays.stream(services).map(ProtectionConfig.class::cast).collect(Collectors.toList());
    }
}

