/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.SubtreeValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ProtectionConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.IdentityProtectionType;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalUserValidatorProvider
extends ValidatorProvider
implements ExternalIdentityConstants {
    private static final Logger log = LoggerFactory.getLogger(ExternalUserValidatorProvider.class);
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private final String authorizableRootPath;
    private final Context aggregatedCtx;
    private final IdentityProtectionType protectionType;
    private final ProtectionConfig protectionConfig;
    private Root rootBefore;
    private Root rootAfter;

    ExternalUserValidatorProvider(@NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider, @NotNull SecurityProvider securityProvider, @NotNull IdentityProtectionType protectionType, @NotNull ProtectionConfig protectionConfig) {
        Validate.checkArgument((protectionType != IdentityProtectionType.NONE ? 1 : 0) != 0);
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
        this.protectionType = protectionType;
        this.protectionConfig = protectionConfig;
        this.authorizableRootPath = UserUtil.getAuthorizableRootPath((ConfigurationParameters)securityProvider.getParameters("org.apache.jackrabbit.oak.user"), (AuthorizableType)AuthorizableType.AUTHORIZABLE);
        this.aggregatedCtx = new AggregatedContext(securityProvider);
    }

    @NotNull
    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        this.rootBefore = this.rootProvider.createReadOnlyRoot(before);
        this.rootAfter = this.rootProvider.createReadOnlyRoot(after);
        return new SubtreeValidator((Validator)new ExternalUserValidator(), (String[])IterableUtils.toArray((Iterable)PathUtils.elements((String)this.authorizableRootPath), String.class));
    }

    private static final class AggregatedContext
    extends Context.Default {
        List<Context> ctxs;

        private AggregatedContext(@NotNull SecurityProvider securityProvider) {
            ArrayList<Context> builder = new ArrayList<Context>();
            for (SecurityConfiguration sc : securityProvider.getConfigurations()) {
                if ("org.apache.jackrabbit.oak.user".equals(sc.getName())) continue;
                builder.add(sc.getContext());
            }
            this.ctxs = Collections.unmodifiableList(builder);
        }

        public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
            return this.ctxs.stream().anyMatch(context -> context.definesProperty(parent, property));
        }

        public boolean definesTree(@NotNull Tree tree) {
            return this.ctxs.stream().anyMatch(context -> context.definesTree(tree));
        }
    }

    private class ExternalUserValidator
    extends DefaultValidator {
        private Tree parentBefore;
        private Tree parentAfter;
        boolean isExternalIdentity = false;

        private ExternalUserValidator() {
        }

        private ExternalUserValidator(@NotNull ExternalUserValidator parentValidator, @NotNull Tree parentBefore, Tree parentAfter) {
            this.parentBefore = parentBefore;
            this.parentAfter = parentAfter;
            this.setExternalIdentity(parentValidator, parentBefore);
        }

        private ExternalUserValidator(@NotNull ExternalUserValidator parentValidator, Tree parent, boolean isBefore) {
            if (isBefore) {
                this.parentBefore = parent;
                this.setExternalIdentity(parentValidator, this.parentBefore);
            } else {
                this.parentAfter = parent;
                this.setExternalIdentity(parentValidator, this.parentAfter);
            }
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            Tree afterTree = this.getParentAfter();
            if (this.definedSecurityContext(afterTree, after)) {
                return;
            }
            if (this.isModifyingExternalIdentity(this.isExternalIdentity, afterTree, after)) {
                String msg = String.format("Attempt to add property '%s' to protected external identity node '%s'", after.getName(), afterTree.getPath());
                this.handleViolation(msg);
            }
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            Tree beforeTree = this.getParentBefore();
            if (this.definedSecurityContext(beforeTree, before)) {
                return;
            }
            if (this.isModifyingExternalIdentity(this.isExternalIdentity, beforeTree, before)) {
                String msg = String.format("Attempt to modify property '%s' at protected external identity node '%s'", before.getName(), beforeTree.getPath());
                this.handleViolation(msg);
            }
        }

        public void propertyDeleted(PropertyState before) throws CommitFailedException {
            Tree beforeTree = this.getParentBefore();
            if (this.definedSecurityContext(beforeTree, before)) {
                return;
            }
            if (this.isModifyingExternalIdentity(this.isExternalIdentity, beforeTree, before)) {
                String msg = String.format("Attempt to delete property '%s' from protected external identity node '%s'", before.getName(), beforeTree.getPath());
                this.handleViolation(msg);
            }
        }

        @Nullable
        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            Tree afterParent = this.getParentAfter();
            Tree afterTree = ExternalUserValidatorProvider.this.treeProvider.createReadOnlyTree(afterParent, name, after);
            if (this.definedSecurityContext(afterTree, null)) {
                return null;
            }
            if (this.isExternalIdentity(afterTree)) {
                String msg = String.format("Attempt to add protected external identity '%s'", afterTree.getPath());
                this.handleViolation(msg);
                return null;
            }
            if (this.isModifyingExternalIdentity(this.isExternalIdentity, afterTree, null)) {
                String msg = String.format("Attempt to add node '%s' to protected external identity node '%s'", name, afterParent.getPath());
                this.handleViolation(msg);
                return null;
            }
            if (UserUtil.isType((Tree)afterTree, (AuthorizableType)AuthorizableType.AUTHORIZABLE)) {
                return null;
            }
            return new ExternalUserValidator(this, afterTree, false);
        }

        @Nullable
        public Validator childNodeChanged(String name, NodeState before, NodeState after) {
            Tree beforeTree = ExternalUserValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentBefore(), name, before);
            Tree afterTree = ExternalUserValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentAfter(), name, after);
            if (this.definedSecurityContext(beforeTree, null)) {
                return null;
            }
            return new ExternalUserValidator(this, beforeTree, afterTree);
        }

        @Nullable
        public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            Tree beforeTree = ExternalUserValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentBefore(), name, before);
            if (this.definedSecurityContext(beforeTree, null)) {
                return null;
            }
            if (this.isExternalIdentity(beforeTree)) {
                String msg = String.format("Attempt to remove protected external identity '%s'", beforeTree.getPath());
                this.handleViolation(msg);
                return null;
            }
            if (this.isModifyingExternalIdentity(this.isExternalIdentity, beforeTree, null)) {
                String msg = String.format("Attempt to remove node '%s' from protected external identity", beforeTree.getPath());
                this.handleViolation(msg);
                return null;
            }
            return new ExternalUserValidator(this, beforeTree, true);
        }

        private void setExternalIdentity(@NotNull ExternalUserValidator parentValidator, @NotNull Tree parent) {
            this.isExternalIdentity = parentValidator.isExternalIdentity ? true : this.isExternalIdentity(parent);
        }

        private boolean isExternalIdentity(@NotNull Tree tree) {
            return UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.AUTHORIZABLE) && tree.hasProperty("rep:externalId");
        }

        @NotNull
        private Tree getParentBefore() {
            if (this.parentBefore == null) {
                this.parentBefore = ExternalUserValidatorProvider.this.rootBefore.getTree(ExternalUserValidatorProvider.this.authorizableRootPath);
            }
            return this.parentBefore;
        }

        @NotNull
        private Tree getParentAfter() {
            if (this.parentAfter == null) {
                this.parentAfter = ExternalUserValidatorProvider.this.rootAfter.getTree(ExternalUserValidatorProvider.this.authorizableRootPath);
            }
            return this.parentAfter;
        }

        private boolean isModifyingExternalIdentity(boolean insideAuthorizable, @NotNull Tree tree, @Nullable PropertyState propertyState) {
            return insideAuthorizable && this.isProtected(tree, propertyState);
        }

        private boolean isProtected(@NotNull Tree tree, @Nullable PropertyState propertyState) {
            if (propertyState == null) {
                return ExternalUserValidatorProvider.this.protectionConfig.isProtectedTree(tree);
            }
            if ("jcr:mixinTypes".equals(propertyState.getName())) {
                return false;
            }
            return ExternalUserValidatorProvider.this.protectionConfig.isProtectedProperty(tree, propertyState);
        }

        private boolean definedSecurityContext(@NotNull Tree tree, @Nullable PropertyState propertyState) {
            if (propertyState != null) {
                return ExternalUserValidatorProvider.this.aggregatedCtx.definesProperty(tree, propertyState);
            }
            return ExternalUserValidatorProvider.this.aggregatedCtx.definesTree(tree);
        }

        private void handleViolation(@NotNull String msg) throws CommitFailedException {
            if (ExternalUserValidatorProvider.this.protectionType != IdentityProtectionType.WARN) {
                throw new CommitFailedException("Constraint", 76, msg);
            }
            log.warn(msg);
        }
    }
}

