/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

class ExternalIdentityRepositoryInitializer
implements RepositoryInitializer {
    private final boolean enforceUniqueIds;

    ExternalIdentityRepositoryInitializer(boolean enforceUniqueIds) {
        this.enforceUniqueIds = enforceUniqueIds;
    }

    public void initialize(@NotNull NodeBuilder builder) {
        NodeBuilder definition;
        NodeBuilder index = IndexUtils.getOrCreateOakIndex((NodeBuilder)builder);
        if (this.enforceUniqueIds && !index.hasChildNode("externalId")) {
            definition = IndexUtils.createIndexDefinition((NodeBuilder)index, (String)"externalId", (boolean)true, (boolean)true, List.of("rep:externalId"), null);
            definition.setProperty("info", (Object)"Oak index assuring uniqueness of rep:externalId properties.");
        }
        if (!index.hasChildNode("externalPrincipalNames")) {
            definition = IndexUtils.createIndexDefinition((NodeBuilder)index, (String)"externalPrincipalNames", (boolean)true, (boolean)false, List.of("rep:externalPrincipalNames"), null);
            definition.setProperty("info", (Object)"Oak index used by the principal management provided by the external authentication module.");
        }
    }
}

