/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeAware;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicGroupUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamicGroupUtil.class);
    private static final Set<String> MEMBER_NODE_NAMES = Set.of("rep:members", "rep:membersList");
    private static final Set<String> MEMBERS_TYPES = Set.of("rep:MemberReferences", "rep:MemberReferencesList", "rep:Members");

    private DynamicGroupUtil() {
    }

    static boolean isGroup(@NotNull Tree tree) {
        return UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.GROUP);
    }

    static boolean isMemberProperty(@NotNull PropertyState propertyState) {
        return "rep:members".equals(propertyState.getName());
    }

    @Nullable
    static String findGroupIdInHierarchy(@NotNull Tree tree) {
        Tree t = tree;
        while (!t.isRoot()) {
            String id = UserUtil.getAuthorizableId((Tree)t);
            if (id != null) {
                return id;
            }
            t = t.getParent();
        }
        return null;
    }

    @NotNull
    static Tree getTree(@NotNull Authorizable authorizable, @NotNull Root root) throws RepositoryException {
        return authorizable instanceof TreeAware ? ((TreeAware)authorizable).getTree() : root.getTree(authorizable.getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasStoredMemberInfo(@NotNull Group group, @NotNull Root root) {
        try {
            Tree tree = DynamicGroupUtil.getTree((Authorizable)group, root);
            if (tree.hasProperty("rep:members")) return true;
            if (!MEMBER_NODE_NAMES.stream().anyMatch(arg_0 -> ((Tree)tree).hasChild(arg_0))) return false;
            return true;
        }
        catch (RepositoryException e) {
            log.error("Cannot test for stored members information, failed to obtain tree from group.", (Throwable)e);
            return false;
        }
    }

    static boolean isMembersType(@NotNull Tree tree) {
        String primaryType = TreeUtil.getPrimaryTypeName((Tree)tree);
        return primaryType != null && MEMBERS_TYPES.contains(primaryType);
    }

    @Nullable
    static String getIdpName(@NotNull Tree userTree) {
        PropertyState ps = userTree.getProperty("rep:externalId");
        if (ps != null) {
            return ExternalIdentityRef.fromString((String)ps.getValue(Type.STRING)).getProviderName();
        }
        return null;
    }

    @Nullable
    static String getIdpName(@NotNull ResultRow row) {
        return DynamicGroupUtil.getIdpName(row.getTree(null));
    }

    @Nullable
    static String getIdpName(@NotNull Authorizable authorizable) throws RepositoryException {
        ExternalIdentityRef ref = DefaultSyncContext.getIdentityRef(authorizable);
        return ref == null ? null : ref.getProviderName();
    }

    static boolean isSameIDP(@NotNull Authorizable group, @NotNull Authorizable member) throws RepositoryException {
        String groupIdpName = DynamicGroupUtil.getIdpName(group);
        if (groupIdpName == null) {
            log.warn("Referenced dynamic group '{}' not associated with an external IDP.", (Object)group.getID());
            return false;
        }
        String idpName = DynamicGroupUtil.getIdpName(member);
        if (groupIdpName.equals(idpName)) {
            return true;
        }
        log.warn("IDP mismatch between dynamic group '{}' and member '{}'.", (Object)groupIdpName, (Object)idpName);
        return false;
    }

    static Set<Principal> getInheritedPrincipals(@NotNull Principal dynamicGroupPrincipal, @NotNull UserManager userManager) {
        try {
            Iterator inherited;
            Authorizable gr = userManager.getAuthorizable(dynamicGroupPrincipal);
            if (gr != null && gr.isGroup() && (inherited = gr.memberOf()).hasNext()) {
                Spliterator spliterator = Spliterators.spliteratorUnknownSize(inherited, 0);
                return StreamSupport.stream(spliterator, false).map(group -> {
                    try {
                        return group.getPrincipal();
                    }
                    catch (RepositoryException repositoryException) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to retrieve inherited group principals", (Throwable)e);
        }
        return Collections.emptySet();
    }
}

