/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.AutoMembershipPrincipals;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.DynamicGroupUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.InheritedMembershipIterator;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncConfigTracker;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AutoMembershipProvider
implements DynamicMembershipProvider {
    private static final String BINDING_AUTHORIZABLE_IDS = "authorizableIds";
    private final Root root;
    private final UserManager userManager;
    private final NamePathMapper namePathMapper;
    private final AutoMembershipPrincipals autoMembershipPrincipals;
    private final AutoMembershipPrincipals groupAutoMembershipPrincipals;

    AutoMembershipProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper, @NotNull Map<String, String[]> autoMembershipMapping, @Nullable Map<String, String[]> groupAutoMembershipMapping, @NotNull Map<String, AutoMembershipConfig> autoMembershipConfigMap) {
        this.root = root;
        this.userManager = userManager;
        this.namePathMapper = namePathMapper;
        this.autoMembershipPrincipals = new AutoMembershipPrincipals(userManager, autoMembershipMapping, autoMembershipConfigMap);
        this.groupAutoMembershipPrincipals = groupAutoMembershipMapping == null ? null : new AutoMembershipPrincipals(userManager, groupAutoMembershipMapping, autoMembershipConfigMap);
    }

    AutoMembershipProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper, @NotNull SyncConfigTracker scTracker) {
        this(root, userManager, namePathMapper, scTracker.getAutoMembership(), scTracker.hasDynamicGroupsEnabled() ? scTracker.getGroupAutoMembership() : null, scTracker.getAutoMembershipConfig());
    }

    public boolean coversAllMembers(@NotNull Group group) {
        return false;
    }

    @NotNull
    public Iterator<Authorizable> getMembers(@NotNull Group group, boolean includeInherited) throws RepositoryException {
        ArrayList<Iterator<Authorizable>> results = new ArrayList<Iterator<Authorizable>>();
        this.searchGlobalMembers(group, results);
        results.add(this.autoMembershipPrincipals.getMembersFromAutoMembershipConfig(group));
        return IteratorUtils.chainedIterator(results.iterator());
    }

    public boolean isMember(@NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        String idpName = DynamicGroupUtil.getIdpName(authorizable);
        if (idpName == null) {
            return false;
        }
        if (authorizable.isGroup()) {
            if (this.groupAutoMembershipPrincipals == null) {
                return false;
            }
            if (group.getID().equals(authorizable.getID())) {
                return false;
            }
            return AutoMembershipProvider.isMember(this.groupAutoMembershipPrincipals, idpName, group, authorizable, includeInherited);
        }
        return AutoMembershipProvider.isMember(this.autoMembershipPrincipals, idpName, group, authorizable, includeInherited);
    }

    private static boolean isMember(@NotNull AutoMembershipPrincipals amPrincipals, @NotNull String idpName, @NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (includeInherited) {
            return amPrincipals.isInheritedMember(idpName, group, authorizable);
        }
        return amPrincipals.isMember(idpName, group.getID(), authorizable);
    }

    @NotNull
    public Iterator<Group> getMembership(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        String idpName = DynamicGroupUtil.getIdpName(authorizable);
        if (idpName == null) {
            return RangeIteratorAdapter.EMPTY;
        }
        Map<Object, Object> m = authorizable.isGroup() ? (this.groupAutoMembershipPrincipals == null ? Collections.emptyMap() : this.groupAutoMembershipPrincipals.getAutoMembership(idpName, authorizable, false)) : this.autoMembershipPrincipals.getAutoMembership(idpName, authorizable, false);
        return AutoMembershipProvider.getGroupIterator(m.values(), includeInherited);
    }

    @NotNull
    private static Iterator<Group> getGroupIterator(@NotNull Collection<Group> groups, boolean includeInherited) {
        if (groups.isEmpty()) {
            return RangeIteratorAdapter.EMPTY;
        }
        RangeIteratorAdapter groupIt = new RangeIteratorAdapter(groups);
        if (!includeInherited) {
            return groupIt;
        }
        return new InheritedMembershipIterator((Iterator<Group>)groupIt);
    }

    private void searchGlobalMembers(@NotNull Group group, @NotNull List<Iterator<Authorizable>> results) throws RepositoryException {
        Principal p = AutoMembershipProvider.getPrincipalOrNull(group);
        if (p == null) {
            return;
        }
        Set<String> idpNames = this.autoMembershipPrincipals.getConfiguredIdpNames(p);
        Set<Object> groupIdpNames = Collections.emptySet();
        if (this.groupAutoMembershipPrincipals != null) {
            groupIdpNames = this.groupAutoMembershipPrincipals.getConfiguredIdpNames(p);
            idpNames.addAll(groupIdpNames);
        }
        if (idpNames.isEmpty()) {
            return;
        }
        String nodeType = groupIdpNames.isEmpty() ? "rep:User" : "rep:Authorizable";
        for (String idpName : idpNames) {
            Map<String, ? extends PropertyValue> bindings = AutoMembershipProvider.buildBinding(idpName);
            String statement = "SELECT 'rep:authorizableId' FROM [" + nodeType + "] WHERE PROPERTY([rep:externalId], 'String') LIKE $authorizableIds /* oak-internal */";
            try {
                Result qResult = this.root.getQueryEngine().executeQuery(statement, "JCR-SQL2", bindings, this.namePathMapper.getSessionLocalMappings());
                Iterator it = StreamSupport.stream(qResult.getRows().spliterator(), false).map(resultRow -> {
                    try {
                        return this.userManager.getAuthorizableByPath(this.namePathMapper.getJcrPath(resultRow.getPath()));
                    }
                    catch (RepositoryException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).iterator();
                results.add(it);
            }
            catch (ParseException e) {
                throw new RepositoryException("Failed to retrieve members of auto-membership group " + String.valueOf(group));
            }
        }
    }

    @Nullable
    private static Principal getPrincipalOrNull(@NotNull Group group) {
        try {
            return group.getPrincipal();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @NotNull
    private static Map<String, ? extends PropertyValue> buildBinding(@NotNull String idpName) {
        String val = "%;" + idpName.replace("%", "\\%").replace("_", "\\_");
        return Collections.singletonMap(BINDING_AUTHORIZABLE_IDS, PropertyValues.newString((String)val));
    }
}

