/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Dictionary;
import java.util.Map;
import java.util.Optional;
import javax.management.MalformedObjectNameException;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.commons.jmx.JmxUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncHandlerMapping;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SyncMBeanImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SynchronizationMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={LoginModuleFactory.class, SyncHandlerMapping.class}, property={"jaas.ranking:Integer=150", "jaas.controlFlag:String=SUFFICIENT", "sync.handlerName:String=default"})
@Designate(ocd=Configuration.class, factory=true)
public class ExternalLoginModuleFactory
implements LoginModuleFactory,
SyncHandlerMapping {
    private static final Logger log = LoggerFactory.getLogger(ExternalLoginModuleFactory.class);
    private volatile SecurityProvider securityProvider;
    private volatile ContentRepository contentRepository;
    private final SyncManager syncManager;
    private final ExternalIdentityProviderManager idpManager;
    private final ConfigurationParameters osgiConfig;
    private final BundleContext bundleContext;
    private volatile Registration mbeanRegistration;

    @Activate
    public ExternalLoginModuleFactory(@Reference(name="syncManager") SyncManager syncManager, @Reference(name="idpManager") ExternalIdentityProviderManager idpManager, ComponentContext context) {
        this.syncManager = syncManager;
        this.idpManager = idpManager;
        this.osgiConfig = Optional.ofNullable(context).map(ctx -> ConfigurationParameters.of((Dictionary)ctx.getProperties())).orElse(ConfigurationParameters.EMPTY);
        this.bundleContext = Optional.ofNullable(context).map(ComponentContext::getBundleContext).orElse(null);
        this.mayRegisterSyncMBean();
    }

    @Deactivate
    private void deactivate() {
        this.unregisterSyncMBean();
    }

    @Reference(name="contentRepository", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void bindContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.mayRegisterSyncMBean();
    }

    public void unbindContentRepository(ContentRepository contentRepository) {
        this.contentRepository = null;
        this.unregisterSyncMBean();
    }

    @Reference(name="securityProvider", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void bindSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
        this.mayRegisterSyncMBean();
    }

    public void unbindSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = null;
        this.unregisterSyncMBean();
    }

    private void mayRegisterSyncMBean() {
        log.debug("Trying to register SynchronizationMBean");
        if (this.mbeanRegistration != null) {
            log.debug("SynchronizationMBean already registered");
            return;
        }
        if (this.bundleContext == null) {
            log.debug("Cannot register SynchronizationMBean; not yet activated.");
            return;
        }
        if (this.contentRepository == null || this.securityProvider == null) {
            log.debug("Cannot register SynchronizationMBean; waiting for references to ContentRepository|SecurityProvider.");
            return;
        }
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.bundleContext);
        try {
            log.debug("Registering SynchronizationMBean");
            String idpName = (String)this.osgiConfig.getConfigValue("idp.name", (Object)"");
            String sncName = (String)this.osgiConfig.getConfigValue("sync.handlerName", (Object)"");
            SyncMBeanImpl bean = new SyncMBeanImpl(this.contentRepository, this.securityProvider, this.syncManager, sncName, this.idpManager, idpName);
            Map<String, String> properties = Map.of("handler", sncName, "idp", idpName);
            this.mbeanRegistration = whiteboard.register(SynchronizationMBean.class, (Object)bean, JmxUtil.createObjectNameMap((String)"UserManagement", (String)"External Identity Synchronization Management", properties));
            log.debug("Registration of SynchronizationMBean completed");
        }
        catch (MalformedObjectNameException e) {
            log.error("Unable to register SynchronizationMBean", (Throwable)e);
        }
    }

    private void unregisterSyncMBean() {
        if (this.mbeanRegistration != null) {
            log.debug("Unregistering SynchronizationMBean");
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
            log.debug("Unregister SynchronizationMBean: completed");
        } else {
            log.debug("Unable to unregister SynchronizationMBean; missing registration.");
        }
    }

    public LoginModule createLoginModule() {
        ExternalLoginModule lm = new ExternalLoginModule(this.osgiConfig);
        lm.setIdpManager(this.idpManager);
        lm.setSyncManager(this.syncManager);
        return lm;
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalLoginModuleFactory", name="Apache Jackrabbit Oak External Login Module")
    static @interface Configuration {
        @AttributeDefinition(name="JAAS Ranking", description="Specifying the ranking (i.e. sort order) of this login module entry. The entries are sorted in a descending order (i.e. higher value ranked configurations come first).")
        public int jaas_ranking() default 150;

        @AttributeDefinition(name="JAAS Control Flag", description="Property specifying whether or not a LoginModule is REQUIRED, REQUISITE, SUFFICIENT or OPTIONAL. Refer to the JAAS configuration documentation for more details around the meaning of these flags.")
        public String jaas_controlFlag() default "SUFFICIENT";

        @AttributeDefinition(name="JAAS Realm", description="The realm name (or application name) against which the LoginModule  is be registered. If no realm name is provided then LoginModule is registered with a default realm as configured in the Felix JAAS configuration.")
        public String jaas_realmName();

        @AttributeDefinition(name="Identity Provider Name", description="Name of the identity provider (for example: 'ldap').")
        public String idp_name();

        @AttributeDefinition(name="Sync Handler Name", description="Name of the sync handler.")
        public String sync_handlerName() default "default";
    }
}

