/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.parquet.Log;
import org.apache.parquet.hadoop.codec.CompressionCodecNotSupportedException;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;

public abstract class CodecConfig {
    private static final Log LOG = Log.getLog(CodecConfig.class);

    public abstract boolean isHadoopCompressionSet();

    public abstract Class getHadoopOutputCompressorClass(Class var1);

    public abstract Configuration getConfiguration();

    public static CodecConfig from(JobConf jobConf) {
        return new MapredCodecConfig(jobConf);
    }

    public static CodecConfig from(TaskAttemptContext context) {
        return new MapreduceCodecConfig(context);
    }

    public static boolean isParquetCompressionSet(Configuration conf) {
        return conf.get("parquet.compression") != null;
    }

    public static CompressionCodecName getParquetCompressionCodec(Configuration configuration) {
        return CompressionCodecName.fromConf(configuration.get("parquet.compression", CompressionCodecName.UNCOMPRESSED.name()));
    }

    public CompressionCodecName getCodec() {
        CompressionCodecName codec;
        Configuration configuration = this.getConfiguration();
        if (CodecConfig.isParquetCompressionSet(configuration)) {
            codec = CodecConfig.getParquetCompressionCodec(configuration);
        } else if (this.isHadoopCompressionSet()) {
            codec = this.getHadoopCompressionCodec();
        } else {
            if (Log.INFO) {
                LOG.info("Compression set to false");
            }
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        if (Log.INFO) {
            LOG.info("Compression: " + codec.name());
        }
        return codec;
    }

    private CompressionCodecName getHadoopCompressionCodec() {
        CompressionCodecName codec;
        try {
            Class codecClass = this.getHadoopOutputCompressorClass(CompressionCodecName.UNCOMPRESSED.getHadoopCompressionCodecClass());
            if (Log.INFO) {
                LOG.info("Compression set through hadoop codec: " + codecClass.getName());
            }
            codec = CompressionCodecName.fromCompressionCodec(codecClass);
        }
        catch (CompressionCodecNotSupportedException e) {
            if (Log.WARN) {
                LOG.warn("codec defined in hadoop config is not supported by parquet [" + e.getCodecClass().getName() + "] and will use UNCOMPRESSED", e);
            }
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        catch (IllegalArgumentException e) {
            if (Log.WARN) {
                LOG.warn("codec class not found: " + e.getMessage(), e);
            }
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        return codec;
    }

    private static class MapredCodecConfig
    extends CodecConfig {
        private final JobConf conf;

        public MapredCodecConfig(JobConf conf) {
            this.conf = conf;
        }

        @Override
        public boolean isHadoopCompressionSet() {
            return org.apache.hadoop.mapred.FileOutputFormat.getCompressOutput((JobConf)this.conf);
        }

        @Override
        public Class getHadoopOutputCompressorClass(Class defaultCodec) {
            return org.apache.hadoop.mapred.FileOutputFormat.getOutputCompressorClass((JobConf)this.conf, (Class)defaultCodec);
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }
    }

    private static class MapreduceCodecConfig
    extends CodecConfig {
        private final TaskAttemptContext context;

        public MapreduceCodecConfig(TaskAttemptContext context) {
            this.context = context;
        }

        @Override
        public boolean isHadoopCompressionSet() {
            return FileOutputFormat.getCompressOutput((JobContext)this.context);
        }

        @Override
        public Class getHadoopOutputCompressorClass(Class defaultCodec) {
            return FileOutputFormat.getOutputCompressorClass((JobContext)this.context, (Class)defaultCodec);
        }

        @Override
        public Configuration getConfiguration() {
            return ContextUtil.getConfiguration((JobContext)this.context);
        }
    }
}

