/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.DirectDecompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.ZeroCopyShims;

public class HadoopShimsCurrent
implements HadoopShims {
    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        switch (codec) {
            case ZLIB: {
                return new DirectDecompressWrapper((DirectDecompressor)new ZlibDecompressor.ZlibDirectDecompressor());
            }
            case ZLIB_NOHEADER: {
                return new DirectDecompressWrapper((DirectDecompressor)new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.NO_HEADER, 0));
            }
            case SNAPPY: {
                return new DirectDecompressWrapper((DirectDecompressor)new SnappyDecompressor.SnappyDirectDecompressor());
            }
        }
        return null;
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return ZeroCopyShims.getZeroCopyReader(in, pool);
    }

    @Override
    public HadoopShims.TextReaderShim getTextReaderShim(InputStream in) throws IOException {
        return new FastTextReaderShim(in);
    }

    private static final class FastTextReaderShim
    implements HadoopShims.TextReaderShim {
        private final DataInputStream din;

        public FastTextReaderShim(InputStream in) {
            this.din = new DataInputStream(in);
        }

        @Override
        public void read(Text txt, int len) throws IOException {
            txt.readWithKnownLength((DataInput)this.din, len);
        }
    }

    private static class DirectDecompressWrapper
    implements HadoopShims.DirectDecompressor {
        private final DirectDecompressor root;

        DirectDecompressWrapper(DirectDecompressor root) {
            this.root = root;
        }

        @Override
        public void decompress(ByteBuffer input, ByteBuffer output) throws IOException {
            this.root.decompress(input, output);
        }
    }
}

