/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.TezDummyStoreOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.TezBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertJoinMapJoin
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConvertJoinMapJoin.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procCtx;
        JoinOperator joinOp = (JoinOperator)nd;
        long maxSize = context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        TezBucketJoinProcCtx tezBucketJoinProcCtx = new TezBucketJoinProcCtx(context.conf);
        if (!context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN)) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx);
            if (retval == null) {
                return retval;
            }
            this.fallbackToReduceSideJoin(joinOp, context);
            return null;
        }
        int numBuckets = -1;
        numBuckets = context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) ? ConvertJoinMapJoin.estimateNumBuckets(joinOp, true) : 1;
        LOG.info("Estimated number of buckets " + numBuckets);
        int mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, numBuckets, false, maxSize, true);
        if (mapJoinConversionPos < 0) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx);
            if (retval == null) {
                return retval;
            }
            this.fallbackToReduceSideJoin(joinOp, context);
            return null;
        }
        if (numBuckets > 1 && context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx)) {
            return null;
        }
        LOG.info("Convert to non-bucketed map join");
        if (numBuckets != 1) {
            mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, 1, false, maxSize, true);
        }
        if (mapJoinConversionPos < 0) {
            this.fallbackToReduceSideJoin(joinOp, context);
            return null;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, mapJoinConversionPos, true);
        mapJoinOp.setOpTraits(new OpTraits(null, -1, null, joinOp.getOpTraits().getNumReduceSinks()));
        mapJoinOp.setStatistics(joinOp.getStatistics());
        for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
            this.setAllChildrenTraits(childOp, mapJoinOp.getOpTraits());
        }
        return null;
    }

    private Object checkAndConvertSMBJoin(OptimizeTezProcContext context, JoinOperator joinOp, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN) || !HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_REDUCE) && joinOp.getOpTraits().getNumReduceSinks() >= 2) {
            this.fallbackToReduceSideJoin(joinOp, context);
            return null;
        }
        Class bigTableMatcherClass = null;
        try {
            String selector = HiveConf.getVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR);
            bigTableMatcherClass = JavaUtils.loadClass(selector);
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e.getMessage());
        }
        BigTableSelectorForAutoSMJ bigTableMatcher = (BigTableSelectorForAutoSMJ)ReflectionUtils.newInstance((Class)bigTableMatcherClass, null);
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        JoinCondDesc[] joinCondns = joinDesc.getConds();
        Set<Integer> joinCandidates = MapJoinProcessor.getBigTableCandidates(joinCondns);
        if (joinCandidates.isEmpty()) {
            return false;
        }
        int mapJoinConversionPos = bigTableMatcher.getBigTablePosition(context.parseContext, joinOp, joinCandidates);
        if (mapJoinConversionPos < 0) {
            this.fallbackToReduceSideJoin(joinOp, context);
            return null;
        }
        if (this.checkConvertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx)) {
            this.convertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx.getNumBuckets(), true);
        } else {
            this.fallbackToReduceSideJoin(joinOp, context);
        }
        return null;
    }

    private void convertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int mapJoinConversionPos, int numBuckets, boolean adjustParentsChildren) throws SemanticException {
        int pos;
        MapJoinDesc mapJoinDesc = null;
        if (adjustParentsChildren) {
            mapJoinDesc = MapJoinProcessor.getMapJoinDesc(context.conf, joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), mapJoinConversionPos, true);
        } else {
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            mapJoinDesc = new MapJoinDesc(MapJoinProcessor.getKeys(((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), joinOp).getSecond(), null, joinDesc.getExprs(), null, null, joinDesc.getOutputColumnNames(), mapJoinConversionPos, joinDesc.getConds(), joinDesc.getFilters(), joinDesc.getNoOuterJoin(), null);
            mapJoinDesc.setNullSafes(joinDesc.getNullSafes());
            mapJoinDesc.setFilterMap(joinDesc.getFilterMap());
            mapJoinDesc.setResidualFilterExprs(joinDesc.getResidualFilterExprs());
            mapJoinDesc.resetOrder();
        }
        CommonMergeJoinOperator mergeJoinOp = (CommonMergeJoinOperator)OperatorFactory.get(joinOp.getCompilationOpContext(), new CommonMergeJoinDesc(numBuckets, mapJoinConversionPos, mapJoinDesc), joinOp.getSchema());
        int numReduceSinks = joinOp.getOpTraits().getNumReduceSinks();
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), numBuckets, joinOp.getOpTraits().getSortCols(), numReduceSinks);
        mergeJoinOp.setOpTraits(opTraits);
        mergeJoinOp.setStatistics(joinOp.getStatistics());
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            pos = parentOp.getChildOperators().indexOf(joinOp);
            parentOp.getChildOperators().remove(pos);
            parentOp.getChildOperators().add(pos, mergeJoinOp);
        }
        for (Operator<OperatorDesc> childOp : joinOp.getChildOperators()) {
            pos = childOp.getParentOperators().indexOf(joinOp);
            childOp.getParentOperators().remove(pos);
            childOp.getParentOperators().add(pos, mergeJoinOp);
        }
        List<Operator<OperatorDesc>> childOperators = mergeJoinOp.getChildOperators();
        List<Operator<OperatorDesc>> parentOperators = mergeJoinOp.getParentOperators();
        childOperators.clear();
        parentOperators.clear();
        childOperators.addAll(joinOp.getChildOperators());
        parentOperators.addAll(joinOp.getParentOperators());
        ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(false);
        if (adjustParentsChildren) {
            ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(true);
            ArrayList<Operator<OperatorDesc>> newParentOpList = new ArrayList<Operator<OperatorDesc>>();
            for (Operator<OperatorDesc> parentOp : mergeJoinOp.getParentOperators()) {
                for (Operator<OperatorDesc> grandParentOp : parentOp.getParentOperators()) {
                    grandParentOp.getChildOperators().remove(parentOp);
                    grandParentOp.getChildOperators().add(mergeJoinOp);
                    newParentOpList.add(grandParentOp);
                }
            }
            mergeJoinOp.getParentOperators().clear();
            mergeJoinOp.getParentOperators().addAll(newParentOpList);
            ArrayList<Operator<OperatorDesc>> parentOps = new ArrayList<Operator<OperatorDesc>>(mergeJoinOp.getParentOperators());
            for (Operator operator : parentOps) {
                int parentIndex = mergeJoinOp.getParentOperators().indexOf(operator);
                if (parentIndex == mapJoinConversionPos) continue;
                TezDummyStoreOperator dummyStoreOp = new TezDummyStoreOperator(mergeJoinOp.getCompilationOpContext());
                dummyStoreOp.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.setChildOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.getChildOperators().add(mergeJoinOp);
                int index = operator.getChildOperators().indexOf(mergeJoinOp);
                operator.getChildOperators().remove(index);
                operator.getChildOperators().add(index, dummyStoreOp);
                dummyStoreOp.getParentOperators().add(operator);
                mergeJoinOp.getParentOperators().remove(parentIndex);
                mergeJoinOp.getParentOperators().add(parentIndex, dummyStoreOp);
            }
        }
        mergeJoinOp.cloneOriginalParentsList(mergeJoinOp.getParentOperators());
    }

    private void setAllChildrenTraits(Operator<? extends OperatorDesc> currentOp, OpTraits opTraits) {
        if (currentOp instanceof ReduceSinkOperator) {
            return;
        }
        currentOp.setOpTraits(new OpTraits(opTraits.getBucketColNames(), opTraits.getNumBuckets(), opTraits.getSortCols(), opTraits.getNumReduceSinks()));
        for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
            if (childOp instanceof ReduceSinkOperator || childOp instanceof GroupByOperator) break;
            this.setAllChildrenTraits(childOp, opTraits);
        }
    }

    private boolean convertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!this.checkConvertJoinBucketMapJoin(joinOp, context, bigTablePosition, tezBucketJoinProcCtx)) {
            LOG.info("Check conversion to bucket map join failed.");
            return false;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePosition, true);
        if (mapJoinOp == null) {
            LOG.debug("Conversion to bucket map join failed.");
            return false;
        }
        MapJoinDesc joinDesc = (MapJoinDesc)mapJoinOp.getConf();
        joinDesc.setBucketMapJoin(true);
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), tezBucketJoinProcCtx.getNumBuckets(), null, joinOp.getOpTraits().getNumReduceSinks());
        mapJoinOp.setOpTraits(opTraits);
        mapJoinOp.setStatistics(joinOp.getStatistics());
        this.setNumberOfBucketsOnChildren(mapJoinOp);
        HashMap<String, Integer> bigTableBucketNumMapping = new HashMap<String, Integer>();
        bigTableBucketNumMapping.put(joinDesc.getBigTableAlias(), tezBucketJoinProcCtx.getNumBuckets());
        joinDesc.setBigTableBucketNumMapping(bigTableBucketNumMapping);
        return true;
    }

    private boolean checkConvertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        ReduceSinkOperator bigTableRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        int numBuckets = bigTableRS.getParentOperators().get(0).getOpTraits().getNumBuckets();
        int size = -1;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            Set<ReduceSinkOperator> set = OperatorUtils.findOperatorsUpstream(parentOp.getParentOperators(), ReduceSinkOperator.class);
            if (size < 0) {
                size = set.size();
                continue;
            }
            if (size > 0 && set.size() > 0 || size == 0 && set.size() == 0) continue;
            return false;
        }
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof ReduceSinkOperator)) {
                LOG.info("Found correlation optimizer operators. Cannot convert to SMB at this time.");
                return false;
            }
            ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
            if (!this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getSortCols(), rsOp.getOpTraits().getSortCols(), rsOp.getColumnExprMap(), tezBucketJoinProcCtx, false)) {
                LOG.info("We cannot convert to SMB because the sort column names do not match.");
                return false;
            }
            if (this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getBucketColNames(), rsOp.getOpTraits().getBucketColNames(), rsOp.getColumnExprMap(), tezBucketJoinProcCtx, true)) continue;
            LOG.info("We cannot convert to SMB because bucket column names do not match.");
            return false;
        }
        if (numBuckets < 0) {
            numBuckets = ((ReduceSinkDesc)bigTableRS.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        LOG.info("We can convert the join to an SMB join.");
        return true;
    }

    private void setNumberOfBucketsOnChildren(Operator<? extends OperatorDesc> currentOp) {
        int numBuckets = currentOp.getOpTraits().getNumBuckets();
        for (Operator<OperatorDesc> op : currentOp.getChildOperators()) {
            if (op instanceof ReduceSinkOperator || op instanceof GroupByOperator) continue;
            op.getOpTraits().setNumBuckets(numBuckets);
            this.setNumberOfBucketsOnChildren(op);
        }
    }

    private boolean checkConvertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!(joinOp.getParentOperators().get(0) instanceof ReduceSinkOperator)) {
            LOG.info("Operator is " + joinOp.getParentOperators().get(0).getName() + ". Cannot convert to bucket map join");
            return false;
        }
        ReduceSinkOperator rs = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        List<List<String>> parentColNames = rs.getOpTraits().getBucketColNames();
        Operator<OperatorDesc> parentOfParent = rs.getParentOperators().get(0);
        List<List<String>> grandParentColNames = parentOfParent.getOpTraits().getBucketColNames();
        int numBuckets = parentOfParent.getOpTraits().getNumBuckets();
        if (!this.checkColEquality(grandParentColNames, parentColNames, rs.getColumnExprMap(), tezBucketJoinProcCtx, true)) {
            LOG.info("No info available to check for bucket map join. Cannot convert");
            return false;
        }
        if (numBuckets < 0) {
            numBuckets = ((ReduceSinkDesc)rs.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        return true;
    }

    private boolean checkColEquality(List<List<String>> grandParentColNames, List<List<String>> parentColNames, Map<String, ExprNodeDesc> colExprMap, TezBucketJoinProcCtx tezBucketJoinProcCtx, boolean strict) {
        if (grandParentColNames == null || parentColNames == null) {
            return false;
        }
        if (parentColNames != null && !parentColNames.isEmpty()) {
            block0: for (List<String> listBucketCols : grandParentColNames) {
                if (listBucketCols.isEmpty()) continue;
                int colCount = 0;
                for (String colName : parentColNames.get(0)) {
                    if (listBucketCols.size() <= colCount) {
                        return false;
                    }
                    ExprNodeDesc exprNodeDesc = colExprMap.get(colName);
                    if (exprNodeDesc instanceof ExprNodeColumnDesc) {
                        if (!((ExprNodeColumnDesc)exprNodeDesc).getColumn().equals(listBucketCols.get(colCount))) continue block0;
                        ++colCount;
                    }
                    if (colCount != parentColNames.get(0).size()) continue;
                    if (strict) {
                        return colCount == listBucketCols.size();
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int getMapJoinConversionPos(JoinOperator joinOp, OptimizeTezProcContext context, int buckets, boolean skipJoinTypeChecks, long maxSize, boolean checkHashTableEntries) throws SemanticException {
        if (!skipJoinTypeChecks && ((JoinDesc)joinOp.getConf()).getConds().length > 1) {
            boolean hasOuter = false;
            block4: for (JoinCondDesc joinCondDesc : ((JoinDesc)joinOp.getConf()).getConds()) {
                switch (joinCondDesc.getType()) {
                    case 0: 
                    case 4: 
                    case 5: {
                        hasOuter = false;
                        continue block4;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        hasOuter = true;
                        continue block4;
                    }
                    default: {
                        throw new SemanticException("Unknown join type " + joinCondDesc.getType());
                    }
                }
            }
            if (hasOuter) {
                return -1;
            }
        }
        Set<Integer> bigTableCandidateSet = MapJoinProcessor.getBigTableCandidates(((JoinDesc)joinOp.getConf()).getConds());
        int bigTablePosition = -1;
        long bigInputCumulativeCardinality = -1L;
        Statistics bigInputStat = null;
        boolean foundInputNotFittingInMemory = false;
        long totalSize = 0L;
        for (int pos = 0; pos < joinOp.getParentOperators().size(); ++pos) {
            boolean selectedBigTable;
            long currentInputCumulativeCardinality;
            Operator<OperatorDesc> parentOp = joinOp.getParentOperators().get(pos);
            Statistics currInputStat = parentOp.getStatistics();
            if (currInputStat == null) {
                LOG.warn("Couldn't get statistics from: " + parentOp);
                return -1;
            }
            long inputSize = currInputStat.getDataSize();
            boolean currentInputNotFittingInMemory = false;
            if (bigInputStat == null || bigInputStat != null && inputSize > bigInputStat.getDataSize()) {
                if (foundInputNotFittingInMemory) {
                    return -1;
                }
                if (inputSize / (long)buckets > maxSize) {
                    if (!bigTableCandidateSet.contains(pos)) {
                        return -1;
                    }
                    currentInputNotFittingInMemory = true;
                    foundInputNotFittingInMemory = true;
                }
            }
            if (foundInputNotFittingInMemory) {
                currentInputCumulativeCardinality = -1L;
            } else {
                Long cardinality = ConvertJoinMapJoin.computeCumulativeCardinality(parentOp);
                if (cardinality == null) {
                    return -1;
                }
                currentInputCumulativeCardinality = cardinality;
            }
            boolean bl = selectedBigTable = bigTableCandidateSet.contains(pos) && (bigInputStat == null || currentInputNotFittingInMemory || !foundInputNotFittingInMemory && (currentInputCumulativeCardinality > bigInputCumulativeCardinality || currentInputCumulativeCardinality == bigInputCumulativeCardinality && inputSize > bigInputStat.getDataSize()));
            if (bigInputStat != null && selectedBigTable) {
                totalSize += bigInputStat.getDataSize();
                if (checkHashTableEntries && !this.checkNumberOfEntriesForHashTable(joinOp, bigTablePosition, context)) {
                    return -1;
                }
            } else if (!selectedBigTable) {
                totalSize += inputSize;
                if (checkHashTableEntries && !this.checkNumberOfEntriesForHashTable(joinOp, pos, context)) {
                    return -1;
                }
            }
            if (totalSize / (long)buckets > maxSize) {
                return -1;
            }
            if (!selectedBigTable) continue;
            bigTablePosition = pos;
            bigInputCumulativeCardinality = currentInputCumulativeCardinality;
            bigInputStat = currInputStat;
        }
        return bigTablePosition;
    }

    private static Long computeCumulativeCardinality(Operator<? extends OperatorDesc> op) {
        Statistics currInputStat;
        long cumulativeCardinality = 0L;
        if (op instanceof CommonJoinOperator) {
            for (Operator<OperatorDesc> inputOp : op.getParentOperators()) {
                Long inputCardinality = ConvertJoinMapJoin.computeCumulativeCardinality(inputOp);
                if (inputCardinality == null) {
                    return null;
                }
                if (inputCardinality <= cumulativeCardinality) continue;
                cumulativeCardinality = inputCardinality;
            }
        } else {
            for (Operator<OperatorDesc> inputOp : op.getParentOperators()) {
                Long inputCardinality = ConvertJoinMapJoin.computeCumulativeCardinality(inputOp);
                if (inputCardinality == null) {
                    return null;
                }
                cumulativeCardinality += inputCardinality.longValue();
            }
        }
        if ((currInputStat = op.getStatistics()) == null) {
            LOG.warn("Couldn't get statistics from: " + op);
            return null;
        }
        return cumulativeCardinality += currInputStat.getNumRows();
    }

    public MapJoinOperator convertJoinMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, boolean removeReduceSink) throws SemanticException {
        Operator<OperatorDesc> parentBigTableOp;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof MuxOperator)) continue;
            return null;
        }
        MapJoinOperator mapJoinOp = MapJoinProcessor.convertJoinOpMapJoinOp(context.conf, joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), bigTablePosition, true, removeReduceSink);
        ((MapJoinDesc)mapJoinOp.getConf()).setHybridHashJoin(HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVEUSEHYBRIDGRACEHASHJOIN));
        List<ExprNodeDesc> joinExprs = ((MapJoinDesc)mapJoinOp.getConf()).getKeys().values().iterator().next();
        if (joinExprs.size() == 0) {
            ((MapJoinDesc)mapJoinOp.getConf()).setHybridHashJoin(false);
        }
        if ((parentBigTableOp = mapJoinOp.getParentOperators().get(bigTablePosition)) instanceof ReduceSinkOperator) {
            Operator<OperatorDesc> parentSelectOpOfBigTableOp = parentBigTableOp.getParentOperators().get(0);
            if (removeReduceSink) {
                for (Operator<OperatorDesc> p : parentBigTableOp.getParentOperators()) {
                    HashSet<Operator<OperatorDesc>> dynamicPartitionOperators = new HashSet<Operator<OperatorDesc>>();
                    HashMap<Operator<OperatorDesc>, AppMasterEventOperator> opEventPairs = new HashMap<Operator<OperatorDesc>, AppMasterEventOperator>();
                    for (Operator<OperatorDesc> c : p.getChildOperators()) {
                        AppMasterEventOperator event = this.findDynamicPartitionBroadcast(c);
                        if (event == null) continue;
                        dynamicPartitionOperators.add(c);
                        opEventPairs.put(c, event);
                    }
                    for (Operator<OperatorDesc> c : dynamicPartitionOperators) {
                        if (!context.pruningOpsRemovedByPriorOpt.isEmpty() && context.pruningOpsRemovedByPriorOpt.contains(opEventPairs.get(c))) continue;
                        p.removeChild(c);
                        LOG.info("Disabling dynamic pruning for: " + ((DynamicPruningEventDesc)((AppMasterEventOperator)opEventPairs.get(c)).getConf()).getTableScan().getName() + ". Need to be removed together with reduce sink");
                    }
                    for (Operator<OperatorDesc> op : dynamicPartitionOperators) {
                        context.pruningOpsRemovedByPriorOpt.add((AppMasterEventOperator)opEventPairs.get(op));
                    }
                }
                mapJoinOp.getParentOperators().remove(bigTablePosition);
                if (!mapJoinOp.getParentOperators().contains(parentBigTableOp.getParentOperators().get(0))) {
                    mapJoinOp.getParentOperators().add(bigTablePosition, parentBigTableOp.getParentOperators().get(0));
                }
                parentBigTableOp.getParentOperators().get(0).removeChild(parentBigTableOp);
            }
            for (Operator<OperatorDesc> op : mapJoinOp.getParentOperators()) {
                if (!op.getChildOperators().contains(mapJoinOp)) {
                    op.getChildOperators().add(mapJoinOp);
                }
                op.getChildOperators().remove(joinOp);
            }
            if (context.parseContext.getRsOpToTsOpMap().size() > 0 && removeReduceSink) {
                this.removeCycleCreatingSemiJoinOps(mapJoinOp, parentSelectOpOfBigTableOp, context.parseContext);
            }
        }
        return mapJoinOp;
    }

    private void removeCycleCreatingSemiJoinOps(MapJoinOperator mapjoinOp, Operator<?> parentSelectOpOfBigTable, ParseContext parseContext) throws SemanticException {
        HashMap<ReduceSinkOperator, TableScanOperator> semiJoinMap = new HashMap<ReduceSinkOperator, TableScanOperator>();
        for (Operator<OperatorDesc> op : parentSelectOpOfBigTable.getChildOperators()) {
            if (!(op instanceof SelectOperator)) continue;
            while (op.getChildOperators().size() > 0) {
                op = op.getChildOperators().get(0);
            }
            if (!(op instanceof ReduceSinkOperator)) continue;
            ReduceSinkOperator rs = (ReduceSinkOperator)op;
            TableScanOperator ts = parseContext.getRsOpToTsOpMap().get(rs);
            if (ts == null) continue;
            block2: for (Operator<OperatorDesc> parent : mapjoinOp.getParentOperators()) {
                if (!(parent instanceof ReduceSinkOperator)) continue;
                Set<TableScanOperator> tsOps = OperatorUtils.findOperatorsUpstream(parent, TableScanOperator.class);
                for (TableScanOperator parentTS : tsOps) {
                    if (ts != parentTS) continue;
                    semiJoinMap.put(rs, ts);
                    continue block2;
                }
            }
        }
        if (semiJoinMap.size() > 0) {
            for (ReduceSinkOperator rs : semiJoinMap.keySet()) {
                GenTezUtils.removeBranch(rs);
                GenTezUtils.removeSemiJoinOperator(parseContext, rs, (TableScanOperator)semiJoinMap.get(rs));
            }
        }
    }

    private AppMasterEventOperator findDynamicPartitionBroadcast(Operator<?> parent) {
        block0: for (Operator<OperatorDesc> op : parent.getChildOperators()) {
            while (op != null) {
                if (op instanceof AppMasterEventOperator && op.getConf() instanceof DynamicPruningEventDesc) {
                    return (AppMasterEventOperator)op;
                }
                if (op instanceof ReduceSinkOperator || op instanceof FileSinkOperator || op.getChildOperators().size() != 1) continue block0;
                op = op.getChildOperators().get(0);
            }
        }
        return null;
    }

    private static int estimateNumBuckets(JoinOperator joinOp, boolean useOpTraits) {
        int numBuckets = -1;
        int estimatedBuckets = -1;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (parentOp.getOpTraits().getNumBuckets() > 0) {
                int n = numBuckets = numBuckets < parentOp.getOpTraits().getNumBuckets() ? parentOp.getOpTraits().getNumBuckets() : numBuckets;
            }
            if (!(parentOp instanceof ReduceSinkOperator)) continue;
            ReduceSinkOperator rs = (ReduceSinkOperator)parentOp;
            estimatedBuckets = estimatedBuckets < ((ReduceSinkDesc)rs.getConf()).getNumReducers() ? ((ReduceSinkDesc)rs.getConf()).getNumReducers() : estimatedBuckets;
        }
        if (!useOpTraits) {
            numBuckets = -1;
        }
        if (numBuckets <= 0 && (numBuckets = estimatedBuckets) <= 0) {
            numBuckets = 1;
        }
        return numBuckets;
    }

    private boolean convertJoinDynamicPartitionedHashJoin(JoinOperator joinOp, OptimizeTezProcContext context) throws SemanticException {
        int numReducers = ConvertJoinMapJoin.estimateNumBuckets(joinOp, false);
        LOG.info("Try dynamic partitioned hash join with estimated " + numReducers + " reducers");
        int bigTablePos = this.getMapJoinConversionPos(joinOp, context, numReducers, false, context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD), false);
        if (bigTablePos >= 0) {
            ReduceSinkOperator bigTableParentRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePos);
            numReducers = ((ReduceSinkDesc)bigTableParentRS.getConf()).getNumReducers();
            LOG.debug("Real big table reducers = " + numReducers);
            MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePos, false);
            if (mapJoinOp != null) {
                LOG.info("Selected dynamic partitioned hash join");
                ((MapJoinDesc)mapJoinOp.getConf()).setDynamicPartitionHashJoin(true);
                OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), numReducers, null, joinOp.getOpTraits().getNumReduceSinks());
                mapJoinOp.setOpTraits(opTraits);
                mapJoinOp.setStatistics(joinOp.getStatistics());
                for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
                    this.setAllChildrenTraits(childOp, mapJoinOp.getOpTraits());
                }
                return true;
            }
        }
        return false;
    }

    private void fallbackToReduceSideJoin(JoinOperator joinOp, OptimizeTezProcContext context) throws SemanticException {
        if (context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && context.conf.getBoolVar(HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN) && this.convertJoinDynamicPartitionedHashJoin(joinOp, context)) {
            return;
        }
        int pos = this.getMapJoinConversionPos(joinOp, context, ConvertJoinMapJoin.estimateNumBuckets(joinOp, false), true, Long.MAX_VALUE, false);
        if (pos < 0) {
            LOG.info("Could not get a valid join position. Defaulting to position 0");
            pos = 0;
        }
        LOG.info("Fallback to common merge join operator");
        this.convertJoinSMBJoin(joinOp, context, pos, 0, false);
    }

    private boolean checkNumberOfEntriesForHashTable(JoinOperator joinOp, int position, OptimizeTezProcContext context) {
        long max = HiveConf.getLongVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVECONVERTJOINMAXENTRIESHASHTABLE);
        if (max < 1L) {
            return true;
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)joinOp.getParentOperators().get(position);
        List<String> keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
        Statistics inputStats = rsOp.getStatistics();
        ArrayList<ColStatistics> columnStats = new ArrayList<ColStatistics>();
        for (String key : keys) {
            ColStatistics cs = inputStats.getColumnStatisticsFromColName(key);
            if (cs == null) {
                LOG.debug("Couldn't get statistics for: {}", (Object)key);
                return true;
            }
            columnStats.add(cs);
        }
        long numRows = inputStats.getNumRows();
        long estimation = ConvertJoinMapJoin.estimateNDV(numRows, columnStats);
        LOG.debug("Estimated NDV for input {}: {}; Max NDV for MapJoin conversion: {}", new Object[]{position, estimation, max});
        if (estimation > max) {
            LOG.debug("Number of different entries for HashTable is greater than the max; we do not converting to MapJoin");
            return false;
        }
        return true;
    }

    private static long estimateNDV(long numRows, List<ColStatistics> columnStats) {
        if (columnStats.size() == 1) {
            return columnStats.get(0).getCountDistint();
        }
        long n = 1L;
        for (ColStatistics cs : columnStats) {
            long ndv = cs.getCountDistint();
            if (ndv <= 1L) continue;
            n = StatsUtils.safeMult(n, ndv);
        }
        double nn = n;
        double a = (nn - 1.0) / nn;
        if (a == 1.0) {
            return numRows;
        }
        double v = nn * (1.0 - Math.pow(a, numRows));
        return Math.min(Math.round(v), numRows);
    }
}

