/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcNewSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcProto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcNewInputFormat
extends InputFormat<NullWritable, OrcStruct> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcNewInputFormat.class);

    public org.apache.hadoop.mapreduce.RecordReader<NullWritable, OrcStruct> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        Configuration conf = ShimLoader.getHadoopShims().getConfiguration((JobContext)context);
        return new OrcRecordReader(OrcFile.createReader(path, OrcFile.readerOptions(conf)), ShimLoader.getHadoopShims().getConfiguration((JobContext)context), fileSplit.getStart(), fileSplit.getLength());
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSplits started");
        }
        Configuration conf = ShimLoader.getHadoopShims().getConfiguration(jobContext);
        List<OrcSplit> splits = OrcInputFormat.generateSplitsInfo(conf, this.createContext(conf, -1));
        ArrayList<InputSplit> result = new ArrayList<InputSplit>(splits.size());
        for (OrcSplit split : splits) {
            result.add((InputSplit)new OrcNewSplit(split));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSplits finished");
        }
        return result;
    }

    private OrcInputFormat.Context createContext(Configuration conf, int numSplits) throws IOException {
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_ENABLED)) {
            conf = new HiveConf(conf, OrcInputFormat.class);
        }
        return new OrcInputFormat.Context(conf, numSplits, null);
    }

    private static class OrcRecordReader
    extends org.apache.hadoop.mapreduce.RecordReader<NullWritable, OrcStruct> {
        private final RecordReader reader;
        private final int numColumns;
        OrcStruct value;
        private float progress = 0.0f;

        OrcRecordReader(Reader file, Configuration conf, long offset, long length) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.value = new OrcStruct(this.numColumns);
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, offset, length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public OrcStruct getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.progress;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.reader.hasNext()) {
                this.reader.next(this.value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }
    }
}

