/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.ReplCopyWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplCopyTask
extends Task<ReplCopyWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ReplCopyTask.class);

    @Override
    protected int execute(DriverContext driverContext) {
        LOG.debug("ReplCopyTask.execute()");
        FileSystem dstFs = null;
        Path toPath = null;
        try {
            Path fromPath = ((ReplCopyWork)this.work).getFromPath();
            toPath = ((ReplCopyWork)this.work).getToPath();
            this.console.printInfo("Copying data from " + fromPath.toString(), " to " + toPath.toString());
            ReplCopyWork rwork = (ReplCopyWork)this.work;
            FileSystem srcFs = fromPath.getFileSystem((Configuration)this.conf);
            dstFs = toPath.getFileSystem((Configuration)this.conf);
            List<Object> srcFiles = new ArrayList<FileStatus>();
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(srcFs, fromPath);
            LOG.debug("ReplCopyTasks srcs=" + (srcs == null ? "null" : Integer.valueOf(srcs.length)));
            if (!rwork.getReadListFromInput()) {
                if (srcs == null || srcs.length == 0) {
                    if (((ReplCopyWork)this.work).isErrorOnSrcEmpty()) {
                        this.console.printError("No files matching path: " + fromPath.toString());
                        return 3;
                    }
                    return 0;
                }
            } else {
                LOG.debug("ReplCopyTask making sense of _files");
                srcFiles = this.filesInFileListing(srcFs, fromPath);
                LOG.debug("ReplCopyTask _files contains:" + (srcFiles == null ? "null" : Integer.valueOf(srcFiles.size())));
                if (srcFiles == null) {
                    if (((ReplCopyWork)this.work).isErrorOnSrcEmpty()) {
                        this.console.printError("No _files entry found on source: " + fromPath.toString());
                        return 5;
                    }
                    return 0;
                }
            }
            srcFiles.addAll(Arrays.asList(srcs));
            LOG.debug("ReplCopyTask numFiles:" + (srcFiles == null ? "null" : Integer.valueOf(srcFiles.size())));
            boolean inheritPerms = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
            if (!FileUtils.mkdir(dstFs, toPath, inheritPerms, this.conf)) {
                this.console.printError("Cannot make target directory: " + toPath.toString());
                return 2;
            }
            BufferedWriter listBW = null;
            if (rwork.getListFilesOnOutputBehaviour()) {
                Path listPath = new Path(toPath, "_files");
                LOG.debug("ReplCopyTask : generating _files at :" + listPath.toUri().toString());
                if (dstFs.exists(listPath)) {
                    this.console.printError("Cannot make target _files file:" + listPath.toString());
                    return 4;
                }
                listBW = new BufferedWriter(new OutputStreamWriter((OutputStream)dstFs.create(listPath)));
            }
            for (FileStatus fileStatus : srcFiles) {
                this.console.printInfo("Copying file: " + fileStatus.getPath().toString());
                LOG.debug("Copying file: " + fileStatus.getPath().toString());
                FileSystem actualSrcFs = null;
                actualSrcFs = rwork.getReadListFromInput() ? fileStatus.getPath().getFileSystem((Configuration)this.conf) : srcFs;
                if (!rwork.getListFilesOnOutputBehaviour(fileStatus)) {
                    LOG.debug("ReplCopyTask :cp:" + fileStatus.getPath() + "=>" + toPath);
                    if (FileUtils.copy(actualSrcFs, fileStatus.getPath(), dstFs, toPath, false, true, this.conf)) continue;
                    this.console.printError("Failed to copy: '" + fileStatus.getPath().toString() + "to: '" + toPath.toString() + "'");
                    return 1;
                }
                LOG.debug("ReplCopyTask _files now tracks:" + fileStatus.getPath().toUri());
                this.console.printInfo("Tracking file: " + fileStatus.getPath().toUri());
                String chksumString = ReplChangeManager.getChksumString(fileStatus.getPath(), actualSrcFs);
                listBW.write(ReplChangeManager.encodeFileUri(fileStatus.getPath().toUri().toString(), chksumString) + "\n");
            }
            if (listBW != null) {
                listBW.close();
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private List<FileStatus> filesInFileListing(FileSystem fs, Path path) throws IOException {
        Path fileListing = new Path(path, "_files");
        LOG.debug("ReplCopyTask filesInFileListing() reading " + fileListing.toUri());
        if (!fs.exists(fileListing)) {
            LOG.debug("ReplCopyTask : _files does not exist");
            return null;
        }
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(fileListing)));
        String line = null;
        while ((line = br.readLine()) != null) {
            LOG.debug("ReplCopyTask :_filesReadLine:" + line);
            String[] fileWithChksum = ReplChangeManager.getFileWithChksumFromURI(line);
            try {
                FileStatus f = ReplChangeManager.getFileStatus(new Path(fileWithChksum[0]), fileWithChksum[1], this.conf);
                ret.add(f);
            }
            catch (MetaException e) {
                LOG.warn("Cannot find " + fileWithChksum[0] + " in source repo or cmroot");
            }
        }
        return ret;
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    @Override
    public String getName() {
        return "REPL_COPY";
    }

    public static Task<?> getLoadCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf) {
        Task<CopyWork> copyTask = null;
        LOG.debug("ReplCopyTask:getLoadCopyTask: " + srcPath + "=>" + dstPath);
        if (replicationSpec.isInReplicationScope()) {
            ReplCopyWork rcwork = new ReplCopyWork(srcPath, dstPath, false);
            LOG.debug("ReplCopyTask:\trcwork");
            if (replicationSpec.isLazy()) {
                LOG.debug("ReplCopyTask:\tlazy");
                rcwork.setReadListFromInput(true);
            }
            copyTask = TaskFactory.get(rcwork, conf, new Task[0]);
        } else {
            LOG.debug("ReplCopyTask:\tcwork");
            copyTask = TaskFactory.get(new CopyWork(srcPath, dstPath, false), conf, new Task[0]);
        }
        return copyTask;
    }

    public static Task<?> getDumpCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf) {
        Task<CopyWork> copyTask = null;
        LOG.debug("ReplCopyTask:getDumpCopyTask: " + srcPath + "=>" + dstPath);
        if (replicationSpec.isInReplicationScope()) {
            ReplCopyWork rcwork = new ReplCopyWork(srcPath, dstPath, false);
            LOG.debug("ReplCopyTask:\trcwork");
            if (replicationSpec.isLazy()) {
                LOG.debug("ReplCopyTask:\tlazy");
                rcwork.setListFilesOnOutputBehaviour(true);
            }
            copyTask = TaskFactory.get(rcwork, conf, new Task[0]);
        } else {
            LOG.debug("ReplCopyTask:\tcwork");
            copyTask = TaskFactory.get(new CopyWork(srcPath, dstPath, false), conf, new Task[0]);
        }
        return copyTask;
    }
}

