/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.NodeAttributeInfo;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributeKeyPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class NodeAttributeInfoPBImpl
extends NodeAttributeInfo {
    private YarnProtos.NodeAttributeInfoProto proto = YarnProtos.NodeAttributeInfoProto.getDefaultInstance();
    private YarnProtos.NodeAttributeInfoProto.Builder builder = null;
    private boolean viaProto = false;

    public NodeAttributeInfoPBImpl() {
        this.builder = YarnProtos.NodeAttributeInfoProto.newBuilder();
    }

    public NodeAttributeInfoPBImpl(YarnProtos.NodeAttributeInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.NodeAttributeInfoProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeAttributeInfoProto.newBuilder((YarnProtos.NodeAttributeInfoProto)this.proto);
        }
        this.viaProto = false;
    }

    public NodeAttributeKey getAttributeKey() {
        YarnProtos.NodeAttributeInfoProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAttributeKey()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAttributeKey());
    }

    public void setAttributeKey(NodeAttributeKey attributeKey) {
        this.maybeInitBuilder();
        if (attributeKey == null) {
            this.builder.clearAttributeKey();
            return;
        }
        this.builder.setAttributeKey(this.convertToProtoFormat(attributeKey));
    }

    public NodeAttributeType getAttributeType() {
        YarnProtos.NodeAttributeInfoProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAttributeType()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAttributeType());
    }

    public void setAttributeType(NodeAttributeType attributeType) {
        this.maybeInitBuilder();
        if (attributeType == null) {
            this.builder.clearAttributeType();
            return;
        }
        this.builder.setAttributeType(this.convertToProtoFormat(attributeType));
    }

    private YarnProtos.NodeAttributeTypeProto convertToProtoFormat(NodeAttributeType attributeType) {
        return YarnProtos.NodeAttributeTypeProto.valueOf((String)attributeType.name());
    }

    private NodeAttributeType convertFromProtoFormat(YarnProtos.NodeAttributeTypeProto containerState) {
        return NodeAttributeType.valueOf((String)containerState.name());
    }

    private NodeAttributeKeyPBImpl convertFromProtoFormat(YarnProtos.NodeAttributeKeyProto attributeKeyProto) {
        return new NodeAttributeKeyPBImpl(attributeKeyProto);
    }

    private YarnProtos.NodeAttributeKeyProto convertToProtoFormat(NodeAttributeKey attributeKey) {
        return ((NodeAttributeKeyPBImpl)attributeKey).getProto();
    }

    public int hashCode() {
        return this.getAttributeKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NodeAttributeInfo) {
            NodeAttributeInfo other = (NodeAttributeInfo)obj;
            return this.getAttributeKey().equals(other.getAttributeKey());
        }
        return false;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        NodeAttributeKey key = this.getAttributeKey();
        strBuilder.append(key.getAttributePrefix()).append("/").append(key.getAttributeName()).append("(").append(this.getAttributeType()).append(")");
        return strBuilder.toString();
    }
}

