/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public enum ReplicationFactor {
    ONE(1),
    THREE(3);

    private int value;

    private ReplicationFactor(int value) {
        this.value = value;
    }

    public static ReplicationFactor valueOf(int value) {
        if (value == 1) {
            return ONE;
        }
        if (value == 3) {
            return THREE;
        }
        throw new IllegalArgumentException("Unsupported value: " + value);
    }

    public static ReplicationFactor fromProto(HddsProtos.ReplicationFactor replicationFactor) {
        if (replicationFactor == null) {
            return null;
        }
        switch (replicationFactor) {
            case ONE: {
                return ONE;
            }
            case THREE: {
                return THREE;
            }
        }
        throw new IllegalArgumentException("Unsupported ProtoBuf replication factor: " + replicationFactor);
    }

    public int getValue() {
        return this.value;
    }
}

