/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterUncaughtExceptionHandler.class);
    private final ClusterOptions.UncaughtExceptionHandleMode handleMode;

    public ClusterUncaughtExceptionHandler(ClusterOptions.UncaughtExceptionHandleMode handleMode) {
        this.handleMode = handleMode;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.handleMode == ClusterOptions.UncaughtExceptionHandleMode.LOG) {
            LOG.error("WARNING: Thread '{}' produced an uncaught exception. If you want to fail on uncaught exceptions, then configure {} accordingly", new Object[]{t.getName(), ClusterOptions.UNCAUGHT_EXCEPTION_HANDLING.key(), e});
        } else {
            FatalExitExceptionHandler.INSTANCE.uncaughtException(t, e);
        }
    }
}

