/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class Restarting
extends StateWithExecutionGraph {
    private final Context context;
    private final Duration backoffTime;
    @Nullable
    private ScheduledFuture<?> goToWaitingForResourcesFuture;

    Restarting(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, Duration backoffTime) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger);
        this.context = context;
        this.backoffTime = backoffTime;
        this.getExecutionGraph().cancel();
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        if (this.goToWaitingForResourcesFuture != null) {
            this.goToWaitingForResourcesFuture.cancel(false);
        }
        super.onLeave(newState);
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.RESTARTING;
    }

    @Override
    public void cancel() {
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler());
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
        this.getLogger().debug("Ignored global failure because we are already restarting the job {}.", (Object)this.getJobId(), (Object)cause);
    }

    @Override
    boolean updateTaskExecutionState(TaskExecutionStateTransition taskExecutionStateTransition) {
        return this.getExecutionGraph().updateState(taskExecutionStateTransition);
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        Preconditions.checkArgument((globallyTerminalState == JobStatus.CANCELED ? 1 : 0) != 0);
        this.goToWaitingForResourcesFuture = this.context.runIfState(this, this.context::goToWaitingForResources, this.backoffTime);
    }

    static class Factory
    implements StateFactory<Restarting> {
        private final Context context;
        private final Logger log;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final Duration backoffTime;

        public Factory(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger log, Duration backoffTime) {
            this.context = context;
            this.log = log;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.backoffTime = backoffTime;
        }

        @Override
        public Class<Restarting> getStateClass() {
            return Restarting.class;
        }

        @Override
        public Restarting getState() {
            return new Restarting(this.context, this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.log, this.backoffTime);
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context {
        public void goToCanceling(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3);

        public void goToWaitingForResources();

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

