/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.util.Collector;

final class WriterCollector<E>
implements Collector<E> {
    private final ChannelWriterOutputView output;
    private final TypeSerializer<E> serializer;

    WriterCollector(ChannelWriterOutputView output, TypeSerializer<E> serializer) {
        this.output = output;
        this.serializer = serializer;
    }

    public void collect(E record) {
        try {
            this.serializer.serialize(record, (DataOutputView)this.output);
        }
        catch (IOException ioex) {
            throw new RuntimeException("An error occurred forwarding the record to the writer.", ioex);
        }
    }

    public void close() {
    }
}

