/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.util.UUID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class StandaloneLeaderRetrievalService
implements LeaderRetrievalService {
    private final Object startStopLock = new Object();
    private final String leaderAddress;
    private final UUID leaderId;
    private boolean started;

    @Deprecated
    public StandaloneLeaderRetrievalService(String leaderAddress) {
        this.leaderAddress = (String)Preconditions.checkNotNull((Object)leaderAddress);
        this.leaderId = HighAvailabilityServices.DEFAULT_LEADER_ID;
    }

    public StandaloneLeaderRetrievalService(String leaderAddress, UUID leaderId) {
        this.leaderAddress = (String)Preconditions.checkNotNull((Object)leaderAddress);
        this.leaderId = (UUID)Preconditions.checkNotNull((Object)leaderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(LeaderRetrievalListener listener) {
        Preconditions.checkNotNull((Object)listener, (String)"Listener must not be null.");
        Object object = this.startStopLock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"StandaloneLeaderRetrievalService can only be started once.");
            this.started = true;
            listener.notifyLeaderAddress(this.leaderAddress, this.leaderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            this.started = false;
        }
    }
}

