/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.security.AccessController;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.util.internal.PlatformDependent;
import org.apache.flink.shaded.netty4.io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import org.apache.flink.util.ExceptionUtils;
import sun.misc.Unsafe;

public final class PageSizeUtil {
    public static final int PAGE_SIZE_UNKNOWN = -1;
    public static final int DEFAULT_PAGE_SIZE = 4096;
    public static final int CONSERVATIVE_PAGE_SIZE_MULTIPLE = 65536;

    public static int getSystemPageSize() {
        try {
            return PageSizeUtilInternal.getSystemPageSize();
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError((Throwable)t);
            return -1;
        }
    }

    public static int getSystemPageSizeOrDefault() {
        int pageSize = PageSizeUtil.getSystemPageSize();
        return pageSize == -1 ? 4096 : pageSize;
    }

    public static int getSystemPageSizeOrConservativeMultiple() {
        int pageSize = PageSizeUtil.getSystemPageSize();
        return pageSize == -1 ? 65536 : pageSize;
    }

    private PageSizeUtil() {
    }

    private static final class PageSizeUtilInternal {
        private PageSizeUtilInternal() {
        }

        static int getSystemPageSize() {
            Unsafe unsafe = PageSizeUtilInternal.unsafe();
            return unsafe == null ? -1 : unsafe.pageSize();
        }

        @Nullable
        private static Unsafe unsafe() {
            if (PlatformDependent.hasUnsafe()) {
                return (Unsafe)AccessController.doPrivileged(() -> UnsafeAccess.UNSAFE);
            }
            return null;
        }
    }
}

