/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;

public class MemoryExecutionGraphInfoStore
implements ExecutionGraphInfoStore {
    private final Map<JobID, ExecutionGraphInfo> serializableExecutionGraphInfos = new HashMap<JobID, ExecutionGraphInfo>(4);

    @Override
    public int size() {
        return this.serializableExecutionGraphInfos.size();
    }

    @Override
    @Nullable
    public ExecutionGraphInfo get(JobID jobId) {
        return this.serializableExecutionGraphInfos.get(jobId);
    }

    @Override
    public void put(ExecutionGraphInfo serializableExecutionGraphInfo) throws IOException {
        this.serializableExecutionGraphInfos.put(serializableExecutionGraphInfo.getJobId(), serializableExecutionGraphInfo);
    }

    @Override
    public JobsOverview getStoredJobsOverview() {
        Collection allJobStatus = this.serializableExecutionGraphInfos.values().stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        return JobsOverview.create(allJobStatus);
    }

    @Override
    public Collection<JobDetails> getAvailableJobDetails() {
        return this.serializableExecutionGraphInfos.values().stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(JobDetails::createDetailsForJob).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public JobDetails getAvailableJobDetails(JobID jobId) {
        ExecutionGraphInfo archivedExecutionGraphInfo = this.serializableExecutionGraphInfos.get(jobId);
        if (archivedExecutionGraphInfo != null) {
            return JobDetails.createDetailsForJob(archivedExecutionGraphInfo.getArchivedExecutionGraph());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.serializableExecutionGraphInfos.clear();
    }
}

