/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointSubsumeHelper;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.util.Preconditions;

public class EmbeddedCompletedCheckpointStore
implements CompletedCheckpointStore {
    private final ArrayDeque<CompletedCheckpoint> checkpoints = new ArrayDeque(2);
    private final AtomicReference<JobStatus> shutdownStatus = new AtomicReference();
    private final int maxRetainedCheckpoints;

    private static void throwAlreadyShutdownException(JobStatus status) {
        throw new IllegalStateException(String.format("Store has been already shutdown with %s.", status));
    }

    public EmbeddedCompletedCheckpointStore() {
        this(1);
    }

    public EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints) {
        this(maxRetainedCheckpoints, Collections.emptyList());
    }

    public EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints, Collection<CompletedCheckpoint> initialCheckpoints) {
        Preconditions.checkArgument((maxRetainedCheckpoints > 0 ? 1 : 0) != 0);
        this.maxRetainedCheckpoints = maxRetainedCheckpoints;
        this.checkpoints.addAll(initialCheckpoints);
    }

    @Override
    public void addCheckpoint(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        if (this.shutdownStatus.get() != null) {
            EmbeddedCompletedCheckpointStore.throwAlreadyShutdownException(this.shutdownStatus.get());
        }
        this.checkpoints.addLast(checkpoint);
        CheckpointSubsumeHelper.subsume(this.checkpoints, this.maxRetainedCheckpoints, CompletedCheckpoint::discardOnSubsume);
    }

    @VisibleForTesting
    void removeOldestCheckpoint() throws Exception {
        CompletedCheckpoint checkpointToSubsume = this.checkpoints.removeFirst();
        checkpointToSubsume.discardOnSubsume();
    }

    @Override
    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) throws Exception {
        if (this.shutdownStatus.compareAndSet(null, jobStatus)) {
            if (jobStatus.isGloballyTerminalState()) {
                this.checkpoints.clear();
            }
        } else {
            EmbeddedCompletedCheckpointStore.throwAlreadyShutdownException(this.shutdownStatus.get());
        }
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxRetainedCheckpoints;
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return false;
    }

    @VisibleForTesting
    public Optional<JobStatus> getShutdownStatus() {
        return Optional.ofNullable(this.shutdownStatus.get());
    }
}

