/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletedCheckpointStore {
    public static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpointStore.class);

    public void addCheckpoint(CompletedCheckpoint var1, CheckpointsCleaner var2, Runnable var3) throws Exception;

    default public CompletedCheckpoint getLatestCheckpoint() throws Exception {
        List<CompletedCheckpoint> allCheckpoints = this.getAllCheckpoints();
        if (allCheckpoints.isEmpty()) {
            return null;
        }
        return allCheckpoints.get(allCheckpoints.size() - 1);
    }

    default public long getLatestCheckpointId() {
        try {
            List<CompletedCheckpoint> allCheckpoints = this.getAllCheckpoints();
            if (allCheckpoints.isEmpty()) {
                return 0L;
            }
            return allCheckpoints.get(allCheckpoints.size() - 1).getCheckpointID();
        }
        catch (Throwable throwable) {
            LOG.warn("Get the latest completed checkpoints failed", throwable);
            return 0L;
        }
    }

    public void shutdown(JobStatus var1, CheckpointsCleaner var2) throws Exception;

    public List<CompletedCheckpoint> getAllCheckpoints() throws Exception;

    public int getNumberOfRetainedCheckpoints();

    public int getMaxNumberOfRetainedCheckpoints();

    public boolean requiresExternalizedCheckpoints();
}

