/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.osgi.Builder;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="ant", requiresDependencyResolution=ResolutionScope.TEST)
public class AntPlugin
extends BundlePlugin {
    static final String BUILD_XML = "/build.xml";
    static final String BUILD_BND = "/maven-build.bnd";

    @Override
    protected void execute(Map<String, String> originalInstructions, BundlePlugin.ClassPathItem[] classpath) throws MojoExecutionException {
        String artifactId = this.getProject().getArtifactId();
        String baseDir = this.getProject().getBasedir().getPath();
        try {
            Builder builder = this.buildOSGiBundle(this.project, originalInstructions, classpath);
            Properties bndProperties = builder.getProperties();
            Iterator<Object> i = bndProperties.values().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof String) continue;
                i.remove();
            }
            bndProperties.setProperty("-output", "${maven.build.dir}/${maven.build.finalName}.jar");
            OutputStream out = this.buildContext.newFileOutputStream(new File(baseDir + BUILD_BND));
            bndProperties.store(out, " Merged BND Instructions");
            IOUtil.close((OutputStream)out);
            String buildXml = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(BUILD_XML));
            buildXml = StringUtils.replace((String)buildXml, (String)"BND_VERSION", (String)builder.getVersion());
            buildXml = StringUtils.replace((String)buildXml, (String)"ARTIFACT_ID", (String)artifactId);
            FileUtils.fileWrite((String)(baseDir + BUILD_XML), (String)buildXml);
            builder.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem creating Ant script", e);
        }
        this.getLog().info((CharSequence)("Wrote Ant bundle project for " + artifactId + " to " + baseDir));
    }
}

