/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.cancel.Cancel;
import org.apache.directory.shared.ldap.codec.extended.operations.cancel.CancelDecoder;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.InternalResultResponse;
import org.apache.directory.shared.ldap.message.extended.CancelResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelRequest
extends ExtendedRequestImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CancelRequest.class);
    private int cancelId;
    public static final String EXTENSION_OID = "1.3.6.1.1.8";

    public CancelRequest(int messageId, int cancelId) {
        super(messageId);
        this.setOid(EXTENSION_OID);
        this.cancelId = cancelId;
    }

    private void encodePayload() throws EncoderException {
        Cancel cancel = new Cancel();
        cancel.setCancelId(this.cancelId);
        this.payload = cancel.encode(null).array();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            try {
                this.encodePayload();
            }
            catch (EncoderException e) {
                LOG.error("Failed to encode payload GracefulShutdownRequest", e);
                throw new RuntimeException(e);
            }
        }
        return super.getPayload();
    }

    public void setPayload(byte[] payload) {
        CancelDecoder decoder = new CancelDecoder();
        try {
            Cancel cancel = (Cancel)decoder.decode(payload);
            if (payload != null) {
                this.payload = new byte[payload.length];
                System.arraycopy(payload, 0, this.payload, 0, payload.length);
            } else {
                this.payload = null;
            }
            this.cancelId = cancel.getCancelId();
        }
        catch (DecoderException e) {
            LOG.error("failed to decode payload", e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)((Object)this.getResultResponse());
    }

    public byte[] getEncodedValue() {
        return this.getPayload();
    }

    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CancelResponse(this.cancelId);
        }
        return this.response;
    }
}

