/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResultCodeEnum {
    SUCCESS(0),
    PARTIAL_RESULTS(9),
    COMPARE_FALSE(5),
    COMPARE_TRUE(6),
    REFERRAL(10),
    SASL_BIND_IN_PROGRESS(14),
    AUTH_METHOD_NOT_SUPPORTED(7),
    STRONG_AUTH_REQUIRED(8),
    CONFIDENTIALITY_REQUIRED(13),
    ALIAS_DEREFERENCING_PROBLEM(36),
    INAPPROPRIATE_AUTHENTICATION(48),
    INVALID_CREDENTIALS(49),
    INSUFFICIENT_ACCESS_RIGHTS(50),
    OPERATIONS_ERROR(1),
    PROTOCOL_ERROR(2),
    TIME_LIMIT_EXCEEDED(3),
    SIZE_LIMIT_EXCEEDED(4),
    ADMIN_LIMIT_EXCEEDED(11),
    UNAVAILABLE_CRITICAL_EXTENSION(12),
    BUSY(51),
    UNAVAILABLE(52),
    UNWILLING_TO_PERFORM(53),
    LOOP_DETECT(54),
    NO_SUCH_ATTRIBUTE(16),
    UNDEFINED_ATTRIBUTE_TYPE(17),
    INAPPROPRIATE_MATCHING(18),
    CONSTRAINT_VIOLATION(19),
    ATTRIBUTE_OR_VALUE_EXISTS(20),
    INVALID_ATTRIBUTE_SYNTAX(21),
    NO_SUCH_OBJECT(32),
    ALIAS_PROBLEM(33),
    INVALID_DN_SYNTAX(34),
    NAMING_VIOLATION(64),
    OBJECT_CLASS_VIOLATION(65),
    NOT_ALLOWED_ON_NON_LEAF(66),
    NOT_ALLOWED_ON_RDN(67),
    ENTRY_ALREADY_EXISTS(68),
    OBJECT_CLASS_MODS_PROHIBITED(69),
    AFFECTS_MULTIPLE_DSAS(71),
    OTHER(80),
    CANCELED(118),
    NO_SUCH_OPERATION(119),
    TOO_LATE(120),
    CANNOT_CANCEL(121),
    UNKNOWN(122);

    private int value;
    public static final Set<ResultCodeEnum> EMPTY_RESULT_CODE_SET;
    public static final Set<ResultCodeEnum> GENERAL_CODES;
    public static final Set<ResultCodeEnum> NON_ERRONEOUS_CODES;
    public static final Set<ResultCodeEnum> ATTRIBUTE_CODES;
    public static final Set<ResultCodeEnum> NAME_CODES;
    public static final Set<ResultCodeEnum> SECURITY_CODES;
    public static final Set<ResultCodeEnum> SERVICE_CODES;
    public static final Set<ResultCodeEnum> UPDATE_CODES;
    public static final Set<ResultCodeEnum> COMMON_CODES;
    public static final Set<ResultCodeEnum> BIND_CODES;
    public static final Set<ResultCodeEnum> SEARCH_CODES;
    public static final Set<ResultCodeEnum> MODIFY_CODES;
    public static final Set<ResultCodeEnum> ADD_CODES;
    public static final Set<ResultCodeEnum> DELETE_CODES;
    public static final Set<ResultCodeEnum> MODIFYDN_CODES;
    public static final Set<ResultCodeEnum> COMPARE_CODES;
    public static final Set<ResultCodeEnum> EXTENDED_CODES;
    public static final Set<ResultCodeEnum> ALL_CODES;
    public static final Set<ResultCodeEnum> NAMINGEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> SERVICEUNAVAILABLE_CODES;
    public static final Set<ResultCodeEnum> INVALIDATTRIBUTEVALUEEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> PARTIAL_RESULTSEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> LIMITEXCEEDEDEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> OPERATIONNOTSUPPOERTEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> INVALIDNAMEEXCEPTION_CODES;
    public static final Set<ResultCodeEnum> SCHEMAVIOLATIONEXCEPTION_CODES;

    private ResultCodeEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int getResultCode() {
        return this.value;
    }

    public static ResultCodeEnum getResultCode(int value) {
        switch (value) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONS_ERROR;
            }
            case 2: {
                return PROTOCOL_ERROR;
            }
            case 3: {
                return TIME_LIMIT_EXCEEDED;
            }
            case 4: {
                return SIZE_LIMIT_EXCEEDED;
            }
            case 5: {
                return COMPARE_FALSE;
            }
            case 6: {
                return COMPARE_TRUE;
            }
            case 7: {
                return AUTH_METHOD_NOT_SUPPORTED;
            }
            case 8: {
                return STRONG_AUTH_REQUIRED;
            }
            case 9: {
                return PARTIAL_RESULTS;
            }
            case 10: {
                return REFERRAL;
            }
            case 11: {
                return ADMIN_LIMIT_EXCEEDED;
            }
            case 12: {
                return UNAVAILABLE_CRITICAL_EXTENSION;
            }
            case 13: {
                return CONFIDENTIALITY_REQUIRED;
            }
            case 14: {
                return SASL_BIND_IN_PROGRESS;
            }
            case 16: {
                return NO_SUCH_ATTRIBUTE;
            }
            case 17: {
                return UNDEFINED_ATTRIBUTE_TYPE;
            }
            case 18: {
                return INAPPROPRIATE_MATCHING;
            }
            case 19: {
                return CONSTRAINT_VIOLATION;
            }
            case 20: {
                return ATTRIBUTE_OR_VALUE_EXISTS;
            }
            case 21: {
                return INVALID_ATTRIBUTE_SYNTAX;
            }
            case 32: {
                return NO_SUCH_OBJECT;
            }
            case 33: {
                return ALIAS_PROBLEM;
            }
            case 34: {
                return INVALID_DN_SYNTAX;
            }
            case 35: {
                return UNKNOWN;
            }
            case 36: {
                return ALIAS_DEREFERENCING_PROBLEM;
            }
            case 48: {
                return INAPPROPRIATE_AUTHENTICATION;
            }
            case 49: {
                return INVALID_CREDENTIALS;
            }
            case 50: {
                return INSUFFICIENT_ACCESS_RIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 52: {
                return UNAVAILABLE;
            }
            case 53: {
                return UNWILLING_TO_PERFORM;
            }
            case 54: {
                return LOOP_DETECT;
            }
            case 64: {
                return NAMING_VIOLATION;
            }
            case 65: {
                return OBJECT_CLASS_VIOLATION;
            }
            case 66: {
                return NOT_ALLOWED_ON_NON_LEAF;
            }
            case 67: {
                return NOT_ALLOWED_ON_RDN;
            }
            case 68: {
                return ENTRY_ALREADY_EXISTS;
            }
            case 69: {
                return OBJECT_CLASS_MODS_PROHIBITED;
            }
            case 71: {
                return AFFECTS_MULTIPLE_DSAS;
            }
            case 80: {
                return OTHER;
            }
            case 118: {
                return CANCELED;
            }
            case 129: {
                return NO_SUCH_OPERATION;
            }
            case 120: {
                return TOO_LATE;
            }
            case 121: {
                return CANNOT_CANCEL;
            }
        }
        return UNKNOWN;
    }

    public static Set<ResultCodeEnum> getGeneralCodes() {
        return GENERAL_CODES;
    }

    public static Set<ResultCodeEnum> getNonErroneousCodes() {
        return NON_ERRONEOUS_CODES;
    }

    public static Set<ResultCodeEnum> getAttributeCodes() {
        return ATTRIBUTE_CODES;
    }

    public static Set<ResultCodeEnum> getNameCodes() {
        return NAME_CODES;
    }

    public static Set<ResultCodeEnum> getSecurityCodes() {
        return SECURITY_CODES;
    }

    public static Set<ResultCodeEnum> getServiceCodes() {
        return SERVICE_CODES;
    }

    public static Set<ResultCodeEnum> getUpdateCodes() {
        return UPDATE_CODES;
    }

    public static Set<ResultCodeEnum> getCommonCodes() {
        return COMMON_CODES;
    }

    public static Set<ResultCodeEnum> getBindCodes() {
        return BIND_CODES;
    }

    public static Set<ResultCodeEnum> getSearchCodes() {
        return SEARCH_CODES;
    }

    public static Set<ResultCodeEnum> getModifyCodes() {
        return MODIFY_CODES;
    }

    public static Set<ResultCodeEnum> getAddCodes() {
        return ADD_CODES;
    }

    public static Set<ResultCodeEnum> getDeleteCodes() {
        return DELETE_CODES;
    }

    public static Set<ResultCodeEnum> getModifyDnCodes() {
        return MODIFYDN_CODES;
    }

    public static Set<ResultCodeEnum> getCompareCodes() {
        return COMPARE_CODES;
    }

    public static Set<ResultCodeEnum> getExtendedCodes() {
        return EXTENDED_CODES;
    }

    public static Set<ResultCodeEnum> getAllCodes() {
        return ALL_CODES;
    }

    public static ResultCodeEnum getBestEstimate(Throwable t, MessageTypeEnum type) {
        Set<ResultCodeEnum> set = ResultCodeEnum.getResultCodes(t);
        if (set.isEmpty()) {
            return OTHER;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (type == null) {
            HashSet<ResultCodeEnum> tmp = new HashSet<ResultCodeEnum>();
            tmp.addAll(set);
            tmp.removeAll(NON_ERRONEOUS_CODES);
            if (tmp.isEmpty()) {
                return OTHER;
            }
            return (ResultCodeEnum)((Object)tmp.iterator().next());
        }
        Set<ResultCodeEnum> candidates = EMPTY_RESULT_CODE_SET;
        switch (type) {
            case ABANDON_REQUEST: {
                return set.iterator().next();
            }
            case ADD_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, ADD_CODES);
                break;
            }
            case ADD_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, ADD_CODES);
                break;
            }
            case BIND_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, BIND_CODES);
                break;
            }
            case BIND_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, BIND_CODES);
                break;
            }
            case COMPARE_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, COMPARE_CODES);
                break;
            }
            case COMPARE_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, COMPARE_CODES);
                break;
            }
            case DEL_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, DELETE_CODES);
                break;
            }
            case DEL_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, DELETE_CODES);
                break;
            }
            case EXTENDED_REQ: {
                candidates = ResultCodeEnum.intersection(set, EXTENDED_CODES);
                break;
            }
            case EXTENDED_RESP: {
                candidates = ResultCodeEnum.intersection(set, EXTENDED_CODES);
                break;
            }
            case MOD_DN_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, MODIFYDN_CODES);
                break;
            }
            case MOD_DN_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, MODIFYDN_CODES);
                break;
            }
            case MODIFY_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, MODIFY_CODES);
                break;
            }
            case MODIFY_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, MODIFY_CODES);
                break;
            }
            case SEARCH_REQUEST: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case SEARCH_RES_DONE: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case SEARCH_RES_ENTRY: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case SEARCH_RES_REF: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case UNBIND_REQUEST: {
                return set.iterator().next();
            }
        }
        candidates.removeAll(NON_ERRONEOUS_CODES);
        if (candidates.isEmpty()) {
            return OTHER;
        }
        return candidates.iterator().next();
    }

    private static Set<ResultCodeEnum> intersection(Set<ResultCodeEnum> s1, Set<ResultCodeEnum> s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return new HashSet<ResultCodeEnum>();
        }
        HashSet<ResultCodeEnum> intersection = new HashSet<ResultCodeEnum>();
        if (s1.size() <= s2.size()) {
            for (ResultCodeEnum item : s1) {
                if (!s2.contains((Object)item)) continue;
                intersection.add(item);
            }
        } else {
            for (ResultCodeEnum item : s2) {
                if (!s1.contains((Object)item)) continue;
                intersection.add(item);
            }
        }
        return intersection;
    }

    public static Set<ResultCodeEnum> getResultCodes(Throwable t) {
        ResultCodeEnum rc = ResultCodeEnum.getResultCode(t);
        if (rc != null) {
            return Collections.singleton(rc);
        }
        if (t instanceof SchemaViolationException) {
            return SCHEMAVIOLATIONEXCEPTION_CODES;
        }
        if (t instanceof InvalidNameException) {
            return INVALIDNAMEEXCEPTION_CODES;
        }
        if (t instanceof OperationNotSupportedException) {
            return OPERATIONNOTSUPPOERTEXCEPTION_CODES;
        }
        if (t instanceof LimitExceededException) {
            return LIMITEXCEEDEDEXCEPTION_CODES;
        }
        if (t instanceof PartialResultException) {
            return PARTIAL_RESULTSEXCEPTION_CODES;
        }
        if (t instanceof InvalidAttributeValueException) {
            return INVALIDATTRIBUTEVALUEEXCEPTION_CODES;
        }
        if (t instanceof ServiceUnavailableException) {
            return SERVICEUNAVAILABLE_CODES;
        }
        if (t instanceof AuthenticationNotSupportedException) {
            return AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES;
        }
        if (t instanceof NamingException) {
            return NAMINGEXCEPTION_CODES;
        }
        return EMPTY_RESULT_CODE_SET;
    }

    public static ResultCodeEnum getResultCode(Throwable t) {
        if (t instanceof LdapException) {
            return ((LdapException)((Object)t)).getResultCode();
        }
        if (t instanceof CommunicationException) {
            return PROTOCOL_ERROR;
        }
        if (t instanceof TimeLimitExceededException) {
            return TIME_LIMIT_EXCEEDED;
        }
        if (t instanceof SizeLimitExceededException) {
            return SIZE_LIMIT_EXCEEDED;
        }
        if (t instanceof AuthenticationException) {
            return INVALID_CREDENTIALS;
        }
        if (t instanceof NoPermissionException) {
            return INSUFFICIENT_ACCESS_RIGHTS;
        }
        if (t instanceof NoSuchAttributeException) {
            return NO_SUCH_ATTRIBUTE;
        }
        if (t instanceof InvalidAttributeIdentifierException) {
            return UNDEFINED_ATTRIBUTE_TYPE;
        }
        if (t instanceof InvalidSearchFilterException) {
            return INAPPROPRIATE_MATCHING;
        }
        if (t instanceof AttributeInUseException) {
            return ATTRIBUTE_OR_VALUE_EXISTS;
        }
        if (t instanceof NameNotFoundException) {
            return NO_SUCH_OBJECT;
        }
        if (t instanceof NameAlreadyBoundException) {
            return ENTRY_ALREADY_EXISTS;
        }
        if (t instanceof ContextNotEmptyException) {
            return NOT_ALLOWED_ON_NON_LEAF;
        }
        return null;
    }

    static {
        EMPTY_RESULT_CODE_SET = new HashSet<ResultCodeEnum>();
        GENERAL_CODES = Collections.singleton(OTHER);
        HashSet<ResultCodeEnum> set = new HashSet<ResultCodeEnum>();
        set.add(SUCCESS);
        set.add(COMPARE_TRUE);
        set.add(COMPARE_FALSE);
        set.add(REFERRAL);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(CANCELED);
        NON_ERRONEOUS_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONSTRAINT_VIOLATION);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        ATTRIBUTE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(INVALID_DN_SYNTAX);
        NAME_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(INVALID_CREDENTIALS);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        SECURITY_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOL_ERROR);
        set.add(OPERATIONS_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANNOT_CANCEL);
        set.add(TOO_LATE);
        set.add(NO_SUCH_OPERATION);
        SERVICE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NAMING_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(AFFECTS_MULTIPLE_DSAS);
        UPDATE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        COMMON_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(INVALID_CREDENTIALS);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        BIND_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        SEARCH_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        MODIFY_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(NAMING_VIOLATION);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        ADD_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        DELETE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(NAMING_VIOLATION);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        MODIFYDN_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONS_ERROR);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(COMPARE_FALSE);
        set.add(COMPARE_TRUE);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(NO_SUCH_OBJECT);
        set.add(INVALID_DN_SYNTAX);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLING_TO_PERFORM);
        set.add(LOOP_DETECT);
        set.add(REFERRAL);
        set.add(OTHER);
        set.add(CANCELED);
        COMPARE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(SUCCESS);
        set.add(OPERATIONS_ERROR);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(COMPARE_FALSE);
        set.add(COMPARE_TRUE);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(REFERRAL);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONSTRAINT_VIOLATION);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(INVALID_DN_SYNTAX);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        set.add(INVALID_CREDENTIALS);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLING_TO_PERFORM);
        set.add(LOOP_DETECT);
        set.add(NAMING_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(OTHER);
        set.add(CANCELED);
        EXTENDED_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(SUCCESS);
        set.add(OPERATIONS_ERROR);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(COMPARE_FALSE);
        set.add(COMPARE_TRUE);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(PARTIAL_RESULTS);
        set.add(REFERRAL);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONSTRAINT_VIOLATION);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(INVALID_DN_SYNTAX);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        set.add(INVALID_CREDENTIALS);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLING_TO_PERFORM);
        set.add(LOOP_DETECT);
        set.add(NAMING_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(OTHER);
        set.add(CANNOT_CANCEL);
        set.add(TOO_LATE);
        set.add(NO_SUCH_OPERATION);
        set.add(CANCELED);
        ALL_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONS_ERROR);
        set.add(ALIAS_PROBLEM);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(LOOP_DETECT);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(OTHER);
        NAMINGEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(UNAVAILABLE);
        SERVICEUNAVAILABLE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(CONSTRAINT_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        INVALIDATTRIBUTEVALUEEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(PARTIAL_RESULTS);
        set.add(REFERRAL);
        PARTIAL_RESULTSEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(REFERRAL);
        set.add(ADMIN_LIMIT_EXCEEDED);
        LIMITEXCEEDEDEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(UNWILLING_TO_PERFORM);
        OPERATIONNOTSUPPOERTEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(INVALID_DN_SYNTAX);
        set.add(NAMING_VIOLATION);
        INVALIDNAMEEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        SCHEMAVIOLATIONEXCEPTION_CODES = Collections.unmodifiableSet(set);
    }
}

