/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.cancel;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;

public class Cancel
extends AbstractAsn1Object {
    private int cancelId;
    private int cancelSequenceLength;

    public Cancel(int cancelId) {
        this.cancelId = cancelId;
    }

    public Cancel() {
    }

    public int getCancelId() {
        return this.cancelId;
    }

    public void setCancelId(int cancelId) {
        this.cancelId = cancelId;
    }

    public int computeLength() {
        this.cancelSequenceLength = 2 + Value.getNbBytes(this.cancelId);
        return 2 + this.cancelSequenceLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes(this.cancelSequenceLength));
        Value.encode(bb, this.cancelId);
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cancel extended operation");
        sb.append("    cancelId : ").append(this.cancelId).append('\n');
        return sb.toString();
    }
}

