/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndEvaluator
implements Evaluator<AndNode, ServerEntry> {
    private final List<Evaluator<? extends ExprNode, ServerEntry>> evaluators;
    private final AndNode node;

    public AndEvaluator(AndNode node, List<Evaluator<? extends ExprNode, ServerEntry>> evaluators) {
        this.node = node;
        this.evaluators = this.optimize(evaluators);
    }

    private List<Evaluator<? extends ExprNode, ServerEntry>> optimize(List<Evaluator<? extends ExprNode, ServerEntry>> unoptimized) {
        ArrayList<Evaluator<? extends ExprNode, ServerEntry>> optimized = new ArrayList<Evaluator<? extends ExprNode, ServerEntry>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new Comparator<Evaluator<?, ServerEntry>>(){

            @Override
            public int compare(Evaluator<?, ServerEntry> e1, Evaluator<?, ServerEntry> e2) {
                long scanCount2;
                long scanCount1 = (Long)e1.getExpression().get("count");
                if (scanCount1 == (scanCount2 = ((Long)e2.getExpression().get("count")).longValue())) {
                    return 0;
                }
                if (scanCount1 < scanCount2) {
                    return -1;
                }
                return 1;
            }
        });
        return optimized;
    }

    @Override
    public boolean evaluate(Long id) throws Exception {
        for (Evaluator<? extends ExprNode, ServerEntry> evaluator : this.evaluators) {
            if (evaluator.evaluate(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(ServerEntry entry) throws Exception {
        for (Evaluator<? extends ExprNode, ServerEntry> evaluator : this.evaluators) {
            if (evaluator.evaluate(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        for (Evaluator<? extends ExprNode, ServerEntry> evaluator : this.evaluators) {
            if (evaluator.evaluate((ServerEntry)((Object)indexEntry))) continue;
            return false;
        }
        return true;
    }

    @Override
    public AndNode getExpression() {
        return this.node;
    }
}

