/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndCursor<V>
extends AbstractIndexCursor<V, ServerEntry> {
    private static final String UNSUPPORTED_MSG = "AndCursors are not ordered and do not support positioning by element.";
    private final IndexCursor<V, ServerEntry> wrapped;
    private final List<Evaluator<? extends ExprNode, ServerEntry>> evaluators;
    private boolean available = false;

    public AndCursor(IndexCursor<V, ServerEntry> wrapped, List<Evaluator<? extends ExprNode, ServerEntry>> evaluators) {
        this.wrapped = wrapped;
        this.evaluators = this.optimize(evaluators);
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(Long id, V value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(Long id, V value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void before(IndexEntry<V, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void after(IndexEntry<V, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.wrapped.get();
            if (!this.matches(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return (IndexEntry)this.wrapped.get();
        }
        throw new InvalidCursorPositionException("Cursor has not been positioned yet.");
    }

    @Override
    public boolean isElementReused() {
        return this.wrapped.isElementReused();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.wrapped.close();
    }

    private List<Evaluator<? extends ExprNode, ServerEntry>> optimize(List<Evaluator<? extends ExprNode, ServerEntry>> unoptimized) {
        ArrayList<Evaluator<? extends ExprNode, ServerEntry>> optimized = new ArrayList<Evaluator<? extends ExprNode, ServerEntry>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new Comparator<Evaluator<?, ServerEntry>>(){

            @Override
            public int compare(Evaluator<?, ServerEntry> e1, Evaluator<?, ServerEntry> e2) {
                long scanCount2;
                long scanCount1 = (Long)e1.getExpression().get("count");
                if (scanCount1 == (scanCount2 = ((Long)e2.getExpression().get("count")).longValue())) {
                    return 0;
                }
                if (scanCount1 < scanCount2) {
                    return -1;
                }
                return 1;
            }
        });
        return optimized;
    }

    private boolean matches(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        for (Evaluator<? extends ExprNode, ServerEntry> evaluator : this.evaluators) {
            if (evaluator.evaluate((ServerEntry)((Object)indexEntry))) continue;
            return false;
        }
        return true;
    }
}

