/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.message.InternalDeleteRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DeleteOperationContext
extends AbstractChangeOperationContext {
    private ClonedServerEntry entry;

    public DeleteOperationContext(CoreSession session) {
        super(session);
    }

    public DeleteOperationContext(CoreSession session, LdapDN deleteDn) {
        super(session, deleteDn);
    }

    public DeleteOperationContext(CoreSession session, InternalDeleteRequest deleteRequest) {
        super(session, deleteRequest.getName());
        this.requestControls = deleteRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public String getName() {
        return MessageTypeEnum.DEL_REQUEST.name();
    }

    public String toString() {
        return "DeleteContext for DN '" + this.getDn().getUpName() + "'";
    }

    public void setEntry(ClonedServerEntry entry) {
        this.entry = entry;
    }

    public ClonedServerEntry getEntry() {
        return this.entry;
    }
}

