/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.directory.server.core.avltree.Marshaller;

public class DefaultMarshaller
implements Marshaller {
    public static final DefaultMarshaller INSTANCE = new DefaultMarshaller();

    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        out.writeObject(object);
        out.flush();
        byte[] data = byteStream.toByteArray();
        out.close();
        return data;
    }

    public Object deserialize(byte[] bytes) throws IOException {
        Object object;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(byteStream);
        try {
            object = in.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException("Could not find class");
            ioe.initCause(e);
            throw ioe;
        }
        return object;
    }
}

