/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.authz.GroupCache;
import org.apache.directory.server.core.authz.TupleCache;
import org.apache.directory.server.core.authz.support.ACDFEngine;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AciAuthorizationInterceptor.class);
    private static final String AC_SUBENTRY_ATTR = "accessControlSubentries";
    private static final Collection<MicroOperation> ADD_PERMS;
    private static final Collection<MicroOperation> READ_PERMS;
    private static final Collection<MicroOperation> COMPARE_PERMS;
    private static final Collection<MicroOperation> SEARCH_ENTRY_PERMS;
    private static final Collection<MicroOperation> SEARCH_ATTRVAL_PERMS;
    private static final Collection<MicroOperation> REMOVE_PERMS;
    private static final Collection<MicroOperation> MATCHEDNAME_PERMS;
    private static final Collection<MicroOperation> BROWSE_PERMS;
    private static final Collection<MicroOperation> LOOKUP_PERMS;
    private static final Collection<MicroOperation> REPLACE_PERMS;
    private static final Collection<MicroOperation> RENAME_PERMS;
    private static final Collection<MicroOperation> EXPORT_PERMS;
    private static final Collection<MicroOperation> IMPORT_PERMS;
    private static final Collection<MicroOperation> MOVERENAME_PERMS;
    private TupleCache tupleCache;
    private GroupCache groupCache;
    private ACIItemParser aciParser;
    private ACDFEngine engine;
    private InterceptorChain chain;
    private Registries registries;
    private AttributeTypeRegistry atRegistry;
    private boolean enabled;
    private String subschemaSubentryDn;
    private AttributeType objectClassType;
    private AttributeType acSubentryType;
    private String subentryOid;
    private AttributeType entryAciType;
    private AttributeType subentryAciType;
    public static final SearchControls DEFAULT_SEARCH_CONTROLS;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
        this.tupleCache = new TupleCache(adminSession);
        this.groupCache = new GroupCache(adminSession);
        this.registries = directoryService.getRegistries();
        this.atRegistry = this.registries.getAttributeTypeRegistry();
        OidRegistry oidRegistry = this.registries.getOidRegistry();
        String objectClassOid = oidRegistry.getOid("objectClass");
        this.subentryOid = oidRegistry.getOid("subentry");
        String acSubentryOid = oidRegistry.getOid(AC_SUBENTRY_ATTR);
        this.objectClassType = this.atRegistry.lookup(objectClassOid);
        this.acSubentryType = this.atRegistry.lookup(acSubentryOid);
        this.entryAciType = this.atRegistry.lookup("2.5.24.5");
        this.subentryAciType = this.atRegistry.lookup("2.5.24.6");
        this.aciParser = new ACIItemParser(new ConcreteNameComponentNormalizer(this.atRegistry, oidRegistry), this.atRegistry.getNormalizerMapping());
        this.engine = new ACDFEngine(this.registries.getOidRegistry(), this.atRegistry);
        this.chain = directoryService.getInterceptorChain();
        this.enabled = directoryService.isAccessControlEnabled();
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        LdapDN subschemaSubentryDnName = new LdapDN(subschemaSubentry.getString());
        subschemaSubentryDnName.normalize(this.atRegistry.getNormalizerMapping());
        this.subschemaSubentryDn = subschemaSubentryDnName.toNormName();
    }

    private void protectCriticalEntries(LdapDN dn) throws Exception {
        LdapDN principalDn = AciAuthorizationInterceptor.getPrincipal().getJndiName();
        if (dn.isEmpty()) {
            String msg = "The rootDSE cannot be deleted, moved or renamed!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the admin";
            msg = msg + " account.  No one not even the admin can del, move or";
            msg = msg + " rename " + dn.getUpName() + "!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    private void addPerscriptiveAciTuples(OperationContext opContext, Collection<ACITuple> tuples, LdapDN dn, ServerEntry entry) throws Exception {
        EntryAttribute subentries;
        EntryAttribute oc = null;
        oc = entry instanceof ClonedServerEntry ? ((ClonedServerEntry)entry).getOriginalEntry().get(this.objectClassType) : entry.get(this.objectClassType);
        if (oc.contains("subentry") || oc.contains(this.subentryOid)) {
            LdapDN parentDn = (LdapDN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
        }
        if ((subentries = entry.get(this.acSubentryType)) == null) {
            return;
        }
        for (Value value : subentries) {
            String subentryDn = value.getString();
            tuples.addAll(this.tupleCache.getACITuples(subentryDn));
        }
    }

    private void addEntryAciTuples(Collection<ACITuple> tuples, ServerEntry entry) throws Exception {
        EntryAttribute entryAci = entry.get(this.entryAciType);
        if (entryAci == null) {
            return;
        }
        for (Value value : entryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse entryACI: " + aciString;
                LOG.error(msg, e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    private void addSubentryAciTuples(OperationContext opContext, Collection<ACITuple> tuples, LdapDN dn, ServerEntry entry) throws Exception {
        if (!entry.contains("objectClass", "subentry")) {
            return;
        }
        LdapDN parentDn = (LdapDN)dn.clone();
        parentDn.remove(dn.size() - 1);
        ServerEntry administrativeEntry = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS).getOriginalEntry();
        EntryAttribute subentryAci = administrativeEntry.get(this.subentryAciType);
        if (subentryAci == null) {
            return;
        }
        for (Value value : subentryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse subentryACI: " + aciString;
                LOG.error(msg, e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapPrincipal principal = addContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        ClonedServerEntry serverEntry = addContext.getEntry();
        LdapDN name = addContext.getDn();
        if (!this.enabled) {
            next.add(addContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.add(addContext);
            this.tupleCache.subentryAdded(name, serverEntry);
            this.groupCache.groupAdded(name, serverEntry);
            return;
        }
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry subentryAttrs = subentryInterceptor.getSubentryAttributes(name, serverEntry);
        for (EntryAttribute attribute : serverEntry) {
            subentryAttrs.put(attribute);
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(addContext, tuples, name, subentryAttrs);
        this.addSubentryAciTuples(addContext, tuples, name, subentryAttrs);
        this.engine.checkPermission(this.registries, addContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, ADD_PERMS, tuples, subentryAttrs, null);
        for (EntryAttribute attribute : serverEntry) {
            for (Value value : attribute) {
                this.engine.checkPermission(this.registries, addContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, attribute.getUpId(), value, ADD_PERMS, tuples, serverEntry, null);
            }
        }
        next.add(addContext);
        this.tupleCache.subentryAdded(name, serverEntry);
        this.groupCache.groupAdded(name, serverEntry);
    }

    private boolean isTheAdministrator(LdapDN normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws Exception {
        LdapDN name = deleteContext.getDn();
        LdapPrincipal principal = deleteContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.delete(deleteContext);
            return;
        }
        ClonedServerEntry entry = deleteContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        this.protectCriticalEntries(name);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.delete(deleteContext);
            this.tupleCache.subentryDeleted(name, entry);
            this.groupCache.groupDeleted(name, entry);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(deleteContext, tuples, name, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(deleteContext, tuples, name, entry);
        this.engine.checkPermission(this.registries, deleteContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, REMOVE_PERMS, tuples, entry, null);
        next.delete(deleteContext);
        this.tupleCache.subentryDeleted(name, entry);
        this.groupCache.groupDeleted(name, entry);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.modify(opContext);
            return;
        }
        List<Modification> mods = opContext.getModItems();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modify(opContext);
            ClonedServerEntry modifiedEntry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
            this.tupleCache.subentryModified(name, mods, (ServerEntry)modifiedEntry);
            this.groupCache.groupModified(name, mods, entry, this.registries);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(opContext, tuples, name, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(opContext, tuples, name, entry);
        this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, Collections.singleton(MicroOperation.MODIFY), tuples, entry, null);
        Collection<MicroOperation> perms = null;
        ServerEntry entryView = entry.clone();
        for (Modification mod : mods) {
            ServerAttribute attr = (ServerAttribute)mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    perms = ADD_PERMS;
                    if (entry.get(attr.getId()) != null) break;
                    this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getId(), null, perms, tuples, entry, null);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    perms = REMOVE_PERMS;
                    EntryAttribute entryAttr = entry.get(attr.getId());
                    if (entryAttr == null || entryAttr.size() != 1) break;
                    this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getId(), null, perms, tuples, entry, null);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    perms = REPLACE_PERMS;
                }
            }
            entryView = ServerEntryUtils.getTargetEntry(mod, entryView, this.registries);
            for (Value value : attr) {
                this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getId(), value, perms, tuples, entry, entryView);
            }
        }
        next.modify(opContext);
        ClonedServerEntry modifiedEntry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        this.tupleCache.subentryModified(name, mods, (ServerEntry)modifiedEntry);
        this.groupCache.groupModified(name, mods, entry, this.registries);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext entryContext) throws Exception {
        LdapDN name = entryContext.getDn();
        if (!this.enabled) {
            return name.size() == 0 || next.hasEntry(entryContext);
        }
        boolean answer = next.hasEntry(entryContext);
        if (name.size() == 0) {
            return answer;
        }
        LdapPrincipal principal = entryContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            return answer;
        }
        ClonedServerEntry entry = entryContext.lookup(name, ByPassConstants.HAS_ENTRY_BYPASS);
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(entryContext, tuples, name, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry.getOriginalEntry());
        this.addSubentryAciTuples(entryContext, tuples, name, entry.getOriginalEntry());
        this.engine.checkPermission(this.registries, entryContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, BROWSE_PERMS, tuples, entry.getOriginalEntry(), null);
        return next.hasEntry(entryContext);
    }

    private void checkLookupAccess(LookupOperationContext lookupContext, ServerEntry entry) throws Exception {
        if (lookupContext.getDn().toString().trim().equals("")) {
            return;
        }
        LdapPrincipal principal = lookupContext.getSession().getEffectivePrincipal();
        LdapDN userName = principal.getJndiName();
        Set<LdapDN> userGroups = this.groupCache.getGroups(userName.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(lookupContext, tuples, lookupContext.getDn(), entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(lookupContext, tuples, lookupContext.getDn(), entry);
        this.engine.checkPermission(this.registries, lookupContext, userGroups, userName, principal.getAuthenticationLevel(), lookupContext.getDn(), null, null, LOOKUP_PERMS, tuples, entry, null);
        for (EntryAttribute attribute : entry) {
            for (Value value : attribute) {
                this.engine.checkPermission(this.registries, lookupContext, userGroups, userName, principal.getAuthenticationLevel(), lookupContext.getDn(), attribute.getUpId(), value, READ_PERMS, tuples, entry, null);
            }
        }
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws Exception {
        LdapPrincipal principal = lookupContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!principalDn.isNormalized()) {
            principalDn.normalize(this.atRegistry.getNormalizerMapping());
        }
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.lookup(lookupContext);
        }
        lookupContext.setByPassed(ByPassConstants.LOOKUP_BYPASS);
        ClonedServerEntry entry = lookupContext.getSession().getDirectoryService().getOperationManager().lookup(lookupContext);
        this.checkLookupAccess(lookupContext, entry);
        return next.lookup(lookupContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws Exception {
        LdapDN name = renameContext.getDn();
        ClonedServerEntry entry = renameContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        LdapPrincipal principal = renameContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)name.clone();
        newName.remove(name.size() - 1);
        newName.add(renameContext.getNewRdn());
        if (!this.enabled) {
            next.rename(renameContext);
            return;
        }
        this.protectCriticalEntries(name);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.rename(renameContext);
            this.tupleCache.subentryRenamed(name, newName);
            this.groupCache.groupRenamed(name, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(renameContext, tuples, name, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(renameContext, tuples, name, entry);
        this.engine.checkPermission(this.registries, renameContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, RENAME_PERMS, tuples, entry, null);
        next.rename(renameContext);
        this.tupleCache.subentryRenamed(name, newName);
        this.groupCache.groupRenamed(name, newName);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws Exception {
        LdapDN oriChildName = moveAndRenameContext.getDn();
        LdapDN newParentName = moveAndRenameContext.getParent();
        ClonedServerEntry entry = moveAndRenameContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        LdapPrincipal principal = moveAndRenameContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(moveAndRenameContext.getNewRdn().getUpName());
        if (!this.enabled) {
            next.moveAndRename(moveAndRenameContext);
            return;
        }
        this.protectCriticalEntries(oriChildName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.moveAndRename(moveAndRenameContext);
            this.tupleCache.subentryRenamed(oriChildName, newName);
            this.groupCache.groupRenamed(oriChildName, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, tuples, oriChildName, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveAndRenameContext, tuples, oriChildName, entry);
        this.engine.checkPermission(this.registries, moveAndRenameContext, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, MOVERENAME_PERMS, tuples, entry, null);
        ClonedServerEntry importedEntry = moveAndRenameContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry subentryAttrs = subentryInterceptor.getSubentryAttributes(newName, importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(this.registries, moveAndRenameContext, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs, null);
        next.moveAndRename(moveAndRenameContext);
        this.tupleCache.subentryRenamed(oriChildName, newName);
        this.groupCache.groupRenamed(oriChildName, newName);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws Exception {
        LdapDN oriChildName = moveContext.getDn();
        LdapDN newParentName = moveContext.getParent();
        ClonedServerEntry entry = moveContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(oriChildName.get(oriChildName.size() - 1));
        LdapPrincipal principal = moveContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.move(moveContext);
            return;
        }
        this.protectCriticalEntries(oriChildName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.move(moveContext);
            this.tupleCache.subentryRenamed(oriChildName, newName);
            this.groupCache.groupRenamed(oriChildName, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, tuples, oriChildName, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveContext, tuples, oriChildName, entry);
        this.engine.checkPermission(this.registries, moveContext, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, EXPORT_PERMS, tuples, entry, null);
        ClonedServerEntry importedEntry = moveContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry subentryAttrs = subentryInterceptor.getSubentryAttributes(newName, importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(this.registries, moveContext, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs, null);
        next.move(moveContext);
        this.tupleCache.subentryRenamed(oriChildName, newName);
        this.groupCache.groupRenamed(oriChildName, newName);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext opContext) throws Exception {
        LdapPrincipal user = opContext.getSession().getEffectivePrincipal();
        EntryFilteringCursor cursor = next.list(opContext);
        if (this.isPrincipalAnAdministrator(user.getJndiName()) || !this.enabled) {
            return cursor;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        cursor.addEntryFilter(authzFilter);
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext opContext) throws Exception {
        boolean isRootDSELookup;
        LdapPrincipal user = opContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = user.getJndiName();
        EntryFilteringCursor cursor = next.search(opContext);
        boolean isSubschemaSubentryLookup = this.subschemaSubentryDn.equals(opContext.getDn().getNormName());
        SearchControls searchCtls = opContext.getSearchControls();
        boolean bl = isRootDSELookup = opContext.getDn().size() == 0 && searchCtls.getSearchScope() == 0;
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled || isRootDSELookup || isSubschemaSubentryLookup) {
            return cursor;
        }
        cursor.addEntryFilter(new AuthorizationFilter());
        return cursor;
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) {
        return this.groupCache.isPrincipalAnAdministrator(principalDn);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        String oid = opContext.getOid();
        Value<?> value = opContext.getValue();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.compare(opContext);
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(opContext, tuples, name, entry.getOriginalEntry());
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(opContext, tuples, name, entry);
        this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, READ_PERMS, tuples, entry, null);
        this.engine.checkPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), name, oid, value, COMPARE_PERMS, tuples, entry, null);
        return next.compare(opContext);
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws Exception {
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.getMatchedName(opContext);
        }
        LdapDN matched = next.getMatchedName(opContext);
        while (matched.size() > 0) {
            ClonedServerEntry entry = opContext.lookup(matched, ByPassConstants.GETMATCHEDDN_BYPASS);
            Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
            HashSet<ACITuple> tuples = new HashSet<ACITuple>();
            this.addPerscriptiveAciTuples(opContext, tuples, matched, entry.getOriginalEntry());
            this.addEntryAciTuples(tuples, entry);
            this.addSubentryAciTuples(opContext, tuples, matched, entry);
            if (this.engine.hasPermission(this.registries, opContext, userGroups, principalDn, principal.getAuthenticationLevel(), matched, null, null, MATCHEDNAME_PERMS, tuples, entry, null)) {
                return matched;
            }
            matched.remove(matched.size() - 1);
        }
        return matched;
    }

    public void cacheNewGroup(LdapDN name, ServerEntry entry) throws Exception {
        this.groupCache.groupAdded(name, entry);
    }

    private boolean filter(OperationContext opContext, LdapDN normName, ClonedServerEntry clonedEntry) throws Exception {
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        LdapDN userDn = principal.getJndiName();
        Set<LdapDN> userGroups = this.groupCache.getGroups(userDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(opContext, tuples, normName, clonedEntry.getOriginalEntry());
        this.addEntryAciTuples(tuples, clonedEntry.getOriginalEntry());
        this.addSubentryAciTuples(opContext, tuples, normName, clonedEntry.getOriginalEntry());
        if (!this.engine.hasPermission(this.registries, opContext, userGroups, userDn, principal.getAuthenticationLevel(), normName, null, null, SEARCH_ENTRY_PERMS, tuples, clonedEntry.getOriginalEntry(), null)) {
            return false;
        }
        ArrayList<AttributeType> attributeToRemove = new ArrayList<AttributeType>();
        for (AttributeType attributeType : clonedEntry.getAttributeTypes()) {
            String id = attributeType.getName();
            EntryAttribute attr = clonedEntry.get(attributeType);
            if (!this.engine.hasPermission(this.registries, opContext, userGroups, userDn, principal.getAuthenticationLevel(), normName, id, null, SEARCH_ATTRVAL_PERMS, tuples, clonedEntry, null)) {
                attributeToRemove.add(attributeType);
                continue;
            }
            ArrayList<Value> valueToRemove = new ArrayList<Value>();
            for (Value value : attr) {
                if (this.engine.hasPermission(this.registries, opContext, userGroups, userDn, principal.getAuthenticationLevel(), normName, attr.getUpId(), value, SEARCH_ATTRVAL_PERMS, tuples, clonedEntry, null)) continue;
                valueToRemove.add(value);
            }
            for (Value value : valueToRemove) {
                attr.remove(value);
            }
            if (attr.size() != 0) continue;
            attributeToRemove.add(attributeType);
        }
        for (AttributeType attributeType : attributeToRemove) {
            clonedEntry.removeAttributes(attributeType);
        }
        return true;
    }

    static {
        HashSet<MicroOperation> set = new HashSet<MicroOperation>(2);
        set.add(MicroOperation.BROWSE);
        set.add(MicroOperation.RETURN_DN);
        SEARCH_ENTRY_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.READ);
        set.add(MicroOperation.BROWSE);
        LOOKUP_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.ADD);
        set.add(MicroOperation.REMOVE);
        REPLACE_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.EXPORT);
        set.add(MicroOperation.RENAME);
        MOVERENAME_PERMS = Collections.unmodifiableCollection(set);
        SEARCH_ATTRVAL_PERMS = Collections.singleton(MicroOperation.READ);
        ADD_PERMS = Collections.singleton(MicroOperation.ADD);
        READ_PERMS = Collections.singleton(MicroOperation.READ);
        COMPARE_PERMS = Collections.singleton(MicroOperation.COMPARE);
        REMOVE_PERMS = Collections.singleton(MicroOperation.REMOVE);
        MATCHEDNAME_PERMS = Collections.singleton(MicroOperation.DISCLOSE_ON_ERROR);
        BROWSE_PERMS = Collections.singleton(MicroOperation.BROWSE);
        RENAME_PERMS = Collections.singleton(MicroOperation.RENAME);
        EXPORT_PERMS = Collections.singleton(MicroOperation.EXPORT);
        IMPORT_PERMS = Collections.singleton(MicroOperation.IMPORT);
        DEFAULT_SEARCH_CONTROLS = new SearchControls();
    }

    class AuthorizationFilter
    implements EntryFilter {
        AuthorizationFilter() {
        }

        public boolean accept(SearchingOperationContext operationContext, ClonedServerEntry entry) throws Exception {
            LdapDN normName = entry.getDn().normalize(AciAuthorizationInterceptor.this.atRegistry.getNormalizerMapping());
            return AciAuthorizationInterceptor.this.filter(operationContext, normName, entry);
        }
    }
}

