/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationBrokerPlugin;
import org.apache.activemq.artemis.core.config.brokerConnectivity.BrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.RoleSet;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.metrics.ActiveMQMetricsPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBridgePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConnectionPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerCriticalPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerFederationPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerResourcePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.ObjectInputStreamWithClassLoader;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.FluentPropertyBeanIntrospectorWithIgnores;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
implements Configuration,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final JournalType DEFAULT_JOURNAL_TYPE = JournalType.ASYNCIO;
    public static final String PROPERTY_CLASS_SUFFIX = ".class";
    public static final String REDACTED = "**redacted**";
    private static final long serialVersionUID = 4077088945050267843L;
    private String name = "localhost";
    private boolean persistenceEnabled = ActiveMQDefaultConfiguration.isDefaultPersistenceEnabled();
    private int maxRedeliveryRecords = ActiveMQDefaultConfiguration.getDefaultMaxRedeliveryRecords();
    private boolean journalDatasync = ActiveMQDefaultConfiguration.isDefaultJournalDatasync();
    protected long fileDeploymentScanPeriod = ActiveMQDefaultConfiguration.getDefaultFileDeployerScanPeriod();
    private boolean persistDeliveryCountBeforeDelivery = ActiveMQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery();
    private int scheduledThreadPoolMaxSize = ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize();
    private int threadPoolMaxSize = ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize();
    private long securityInvalidationInterval = ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval();
    private long authenticationCacheSize = ActiveMQDefaultConfiguration.getDefaultAuthenticationCacheSize();
    private long authorizationCacheSize = ActiveMQDefaultConfiguration.getDefaultAuthorizationCacheSize();
    private boolean securityEnabled = ActiveMQDefaultConfiguration.isDefaultSecurityEnabled();
    private boolean gracefulShutdownEnabled = ActiveMQDefaultConfiguration.isDefaultGracefulShutdownEnabled();
    private long gracefulShutdownTimeout = ActiveMQDefaultConfiguration.getDefaultGracefulShutdownTimeout();
    protected boolean jmxManagementEnabled = ActiveMQDefaultConfiguration.isDefaultJmxManagementEnabled();
    protected String jmxDomain = ActiveMQDefaultConfiguration.getDefaultJmxDomain();
    protected boolean jmxUseBrokerName = ActiveMQDefaultConfiguration.isDefaultJMXUseBrokerName();
    protected long connectionTTLOverride = ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride();
    protected boolean asyncConnectionExecutionEnabled = ActiveMQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled();
    private long messageExpiryScanPeriod = ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod();
    private int messageExpiryThreadPriority = ActiveMQDefaultConfiguration.getDefaultMessageExpiryThreadPriority();
    private long addressQueueScanPeriod = ActiveMQDefaultConfiguration.getDefaultAddressQueueScanPeriod();
    protected int idCacheSize = ActiveMQDefaultConfiguration.getDefaultIdCacheSize();
    private boolean persistIDCache = ActiveMQDefaultConfiguration.isDefaultPersistIdCache();
    private List<String> incomingInterceptorClassNames = new ArrayList<String>();
    private List<String> outgoingInterceptorClassNames = new ArrayList<String>();
    protected Map<String, TransportConfiguration> connectorConfigs = new HashMap<String, TransportConfiguration>();
    private Set<TransportConfiguration> acceptorConfigs = new HashSet<TransportConfiguration>();
    protected List<BridgeConfiguration> bridgeConfigurations = new ArrayList<BridgeConfiguration>();
    protected List<DivertConfiguration> divertConfigurations = new ArrayList<DivertConfiguration>();
    protected List<ConnectionRouterConfiguration> connectionRouters = new ArrayList<ConnectionRouterConfiguration>();
    protected List<ClusterConnectionConfiguration> clusterConfigurations = new ArrayList<ClusterConnectionConfiguration>();
    protected List<AMQPBrokerConnectConfiguration> amqpBrokerConnectConfigurations = new ArrayList<AMQPBrokerConnectConfiguration>();
    protected List<FederationConfiguration> federationConfigurations = new ArrayList<FederationConfiguration>();
    @Deprecated
    private List<CoreQueueConfiguration> coreQueueConfigurations = new ArrayList<CoreQueueConfiguration>();
    private List<CoreAddressConfiguration> addressConfigurations = new ArrayList<CoreAddressConfiguration>();
    protected transient List<BroadcastGroupConfiguration> broadcastGroupConfigurations = new ArrayList<BroadcastGroupConfiguration>();
    protected transient Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations = new LinkedHashMap<String, DiscoveryGroupConfiguration>();
    private String pagingDirectory = ActiveMQDefaultConfiguration.getDefaultPagingDir();
    private int maxConcurrentPageIO = ActiveMQDefaultConfiguration.getDefaultMaxConcurrentPageIo();
    private boolean readWholePage = ActiveMQDefaultConfiguration.isDefaultReadWholePage();
    protected String largeMessagesDirectory = ActiveMQDefaultConfiguration.getDefaultLargeMessagesDir();
    protected String bindingsDirectory = ActiveMQDefaultConfiguration.getDefaultBindingsDirectory();
    protected boolean createBindingsDir = ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir();
    protected String journalDirectory = ActiveMQDefaultConfiguration.getDefaultJournalDir();
    protected String journalRetentionDirectory = null;
    protected long journalRetentionMaxBytes = 0L;
    protected long journalRetentionPeriod;
    protected String nodeManagerLockDirectory = null;
    protected boolean createJournalDir = ActiveMQDefaultConfiguration.isDefaultCreateJournalDir();
    public JournalType journalType = DEFAULT_JOURNAL_TYPE;
    protected boolean largeMessageSync = ActiveMQDefaultConfiguration.isDefaultLargeMessageSync();
    protected boolean journalSyncTransactional = ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional();
    protected boolean journalSyncNonTransactional = ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional();
    protected int journalCompactMinFiles = ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles();
    protected int journalCompactPercentage = ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage();
    protected int journalFileOpenTimeout = ActiveMQDefaultConfiguration.getDefaultJournalFileOpenTimeout();
    protected int journalFileSize = ActiveMQDefaultConfiguration.getDefaultJournalFileSize();
    protected int journalPoolFiles = ActiveMQDefaultConfiguration.getDefaultJournalPoolFiles();
    protected int journalMinFiles = ActiveMQDefaultConfiguration.getDefaultJournalMinFiles();
    protected int journalMaxAtticFilesFiles = ActiveMQDefaultConfiguration.getDefaultJournalMaxAtticFiles();
    protected int journalMaxIO_AIO = ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio();
    protected int journalBufferTimeout_AIO = ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutAio();
    protected Integer deviceBlockSize = null;
    protected int journalBufferSize_AIO = ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeAio();
    protected int journalMaxIO_NIO = ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio();
    protected int journalBufferTimeout_NIO = ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio();
    protected int journalBufferSize_NIO = ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeNio();
    protected boolean logJournalWriteRate = ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate();
    private WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
    private boolean messageCounterEnabled = ActiveMQDefaultConfiguration.isDefaultMessageCounterEnabled();
    private long messageCounterSamplePeriod = ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod();
    private int messageCounterMaxDayHistory = ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory();
    private long transactionTimeout = ActiveMQDefaultConfiguration.getDefaultTransactionTimeout();
    private long transactionTimeoutScanPeriod = ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod();
    private SimpleString managementAddress = ActiveMQDefaultConfiguration.getDefaultManagementAddress();
    private SimpleString managementNotificationAddress = ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress();
    protected String clusterUser = ActiveMQDefaultConfiguration.getDefaultClusterUser();
    protected String clusterPassword = ActiveMQDefaultConfiguration.getDefaultClusterPassword();
    private long serverDumpInterval = ActiveMQDefaultConfiguration.getDefaultServerDumpInterval();
    protected boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private int memoryWarningThreshold = ActiveMQDefaultConfiguration.getDefaultMemoryWarningThreshold();
    private long memoryMeasureInterval = ActiveMQDefaultConfiguration.getDefaultMemoryMeasureInterval();
    protected GroupingHandlerConfiguration groupingHandlerConfiguration;
    private Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private Map<String, ResourceLimitSettings> resourceLimitSettings = new HashMap<String, ResourceLimitSettings>();
    private Map<String, Set<Role>> securitySettings = new HashMap<String, Set<Role>>();
    private List<SecuritySettingPlugin> securitySettingPlugins = new ArrayList<SecuritySettingPlugin>();
    private MetricsConfiguration metricsConfiguration = null;
    private final List<ActiveMQServerBasePlugin> brokerPlugins = new CopyOnWriteArrayList<ActiveMQServerBasePlugin>();
    private final List<ActiveMQServerConnectionPlugin> brokerConnectionPlugins = new CopyOnWriteArrayList<ActiveMQServerConnectionPlugin>();
    private final List<ActiveMQServerSessionPlugin> brokerSessionPlugins = new CopyOnWriteArrayList<ActiveMQServerSessionPlugin>();
    private final List<ActiveMQServerConsumerPlugin> brokerConsumerPlugins = new CopyOnWriteArrayList<ActiveMQServerConsumerPlugin>();
    private final List<ActiveMQServerAddressPlugin> brokerAddressPlugins = new CopyOnWriteArrayList<ActiveMQServerAddressPlugin>();
    private final List<ActiveMQServerQueuePlugin> brokerQueuePlugins = new CopyOnWriteArrayList<ActiveMQServerQueuePlugin>();
    private final List<ActiveMQServerBindingPlugin> brokerBindingPlugins = new CopyOnWriteArrayList<ActiveMQServerBindingPlugin>();
    private final List<ActiveMQServerMessagePlugin> brokerMessagePlugins = new CopyOnWriteArrayList<ActiveMQServerMessagePlugin>();
    private final List<ActiveMQServerBridgePlugin> brokerBridgePlugins = new CopyOnWriteArrayList<ActiveMQServerBridgePlugin>();
    private final List<ActiveMQServerCriticalPlugin> brokerCriticalPlugins = new CopyOnWriteArrayList<ActiveMQServerCriticalPlugin>();
    private final List<ActiveMQServerFederationPlugin> brokerFederationPlugins = new CopyOnWriteArrayList<ActiveMQServerFederationPlugin>();
    private final List<AMQPFederationBrokerPlugin> brokerAMQPFederationPlugins = new CopyOnWriteArrayList<AMQPFederationBrokerPlugin>();
    private final List<ActiveMQServerResourcePlugin> brokerResourcePlugins = new CopyOnWriteArrayList<ActiveMQServerResourcePlugin>();
    private Map<String, Set<String>> securityRoleNameMappings = new HashMap<String, Set<String>>();
    protected List<ConnectorServiceConfiguration> connectorServiceConfigurations = new ArrayList<ConnectorServiceConfiguration>();
    private Boolean maskPassword = ActiveMQDefaultConfiguration.isDefaultMaskPassword();
    private transient String passwordCodec;
    private boolean resolveProtocols = ActiveMQDefaultConfiguration.isDefaultResolveProtocols();
    private long journalLockAcquisitionTimeout = ActiveMQDefaultConfiguration.getDefaultJournalLockAcquisitionTimeout();
    private HAPolicyConfiguration haPolicyConfiguration;
    private StoreConfiguration storeConfiguration;
    protected boolean populateValidatedUser = ActiveMQDefaultConfiguration.isDefaultPopulateValidatedUser();
    protected boolean rejectEmptyValidatedUser = ActiveMQDefaultConfiguration.isDefaultRejectEmptyValidatedUser();
    private long connectionTtlCheckInterval = ActiveMQDefaultConfiguration.getDefaultConnectionTtlCheckInterval();
    private URL configurationUrl;
    private long configurationFileRefreshPeriod = ActiveMQDefaultConfiguration.getDefaultConfigurationFileRefreshPeriod();
    private Long globalMaxSize;
    private Long globalMaxMessages;
    private boolean amqpUseCoreSubscriptionNaming = ActiveMQDefaultConfiguration.getDefaultAmqpUseCoreSubscriptionNaming();
    private int maxDiskUsage = ActiveMQDefaultConfiguration.getDefaultMaxDiskUsage();
    private long minDiskFree = ActiveMQDefaultConfiguration.getDefaultMinDiskFree();
    private int diskScanPeriod = ActiveMQDefaultConfiguration.getDefaultDiskScanPeriod();
    private String systemPropertyPrefix = ActiveMQDefaultConfiguration.getDefaultSystemPropertyPrefix();
    private String brokerPropertiesKeySurround = ActiveMQDefaultConfiguration.getDefaultBrokerPropertiesKeySurround();
    private String brokerPropertiesRemoveValue = ActiveMQDefaultConfiguration.getDefaultBrokerPropertiesRemoveValue();
    private String networkCheckList = ActiveMQDefaultConfiguration.getDefaultNetworkCheckList();
    private String networkURLList = ActiveMQDefaultConfiguration.getDefaultNetworkCheckURLList();
    private long networkCheckPeriod = ActiveMQDefaultConfiguration.getDefaultNetworkCheckPeriod();
    private int networkCheckTimeout = ActiveMQDefaultConfiguration.getDefaultNetworkCheckTimeout();
    private String networkCheckNIC = ActiveMQDefaultConfiguration.getDefaultNetworkCheckNic();
    private String networkCheckPingCommand = NetworkHealthCheck.IPV4_DEFAULT_COMMAND;
    private String networkCheckPing6Command = NetworkHealthCheck.IPV6_DEFAULT_COMMAND;
    private String internalNamingPrefix = ActiveMQDefaultConfiguration.getInternalNamingPrefix();
    private boolean criticalAnalyzer = ActiveMQDefaultConfiguration.getCriticalAnalyzer();
    private CriticalAnalyzerPolicy criticalAnalyzerPolicy = ActiveMQDefaultConfiguration.getCriticalAnalyzerPolicy();
    private long criticalAnalyzerTimeout = ActiveMQDefaultConfiguration.getCriticalAnalyzerTimeout();
    private long criticalAnalyzerCheckPeriod = 0L;
    private int pageSyncTimeout = ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio();
    private String uuidNamespace = ActiveMQDefaultConfiguration.getDefaultUuidNamespace();
    private long mqttSessionScanInterval = ActiveMQDefaultConfiguration.getMqttSessionScanInterval();
    private long mqttSessionStatePersistenceTimeout = ActiveMQDefaultConfiguration.getMqttSessionStatePersistenceTimeout();
    private boolean mqttSessionStatePersistenceEnabled = ActiveMQDefaultConfiguration.getMqttSubscriptionPersistenceEnabled();
    private boolean suppressSessionNotifications = ActiveMQDefaultConfiguration.getDefaultSuppressSessionNotifications();
    private String literalMatchMarkers = ActiveMQDefaultConfiguration.getLiteralMatchMarkers();
    private String viewPermissionMethodMatchPattern = ActiveMQDefaultConfiguration.getViewPermissionMethodMatchPattern();
    private String managementRbacPrefix = ActiveMQDefaultConfiguration.getManagementRbacPrefix();
    private boolean managementMessagesRbac = ActiveMQDefaultConfiguration.getManagementMessagesRbac();
    private int mirrorAckManagerQueueAttempts = ActiveMQDefaultConfiguration.getMirrorAckManagerQueueAttempts();
    private int mirrorAckManagerPageAttempts = ActiveMQDefaultConfiguration.getMirrorAckManagerPageAttempts();
    private boolean mirrorAckManagerWarnUnacked = ActiveMQDefaultConfiguration.getMirrorAckManagerWarnUnacked();
    private int mirrorAckManagerRetryDelay = ActiveMQDefaultConfiguration.getMirrorAckManagerRetryDelay();
    private boolean mirrorPageTransaction = ActiveMQDefaultConfiguration.getMirrorPageTransaction();
    private int globalMaxSizePercentOfJvmMaxMemory = 50;
    private boolean purgePageFolders = ActiveMQDefaultConfiguration.getPurgePageFolders();
    private File artemisInstance;
    private transient JsonObject jsonStatus = JsonLoader.createObjectBuilder().build();
    private final Set<String> keysToRedact = new HashSet<String>();
    final Set<String> ignored = Set.of("status", "securityRoleNameMappings", "queueConfigs", "encodeSize", "federationPolicyMap", "policySets", "AMQPConnection", "AMQPConnectionConfigurations", "combinedParams", "type", "uri", "parent", "connectionElements");

    private JsonObject getJsonStatus() {
        if (this.jsonStatus == null) {
            this.jsonStatus = JsonLoader.createObjectBuilder().build();
        }
        return this.jsonStatus;
    }

    @Override
    public String getJournalRetentionDirectory() {
        return this.journalRetentionDirectory;
    }

    @Override
    public ConfigurationImpl setJournalRetentionDirectory(String dir) {
        this.journalRetentionDirectory = dir;
        return this;
    }

    @Override
    public File getJournalRetentionLocation() {
        if (this.journalRetentionDirectory == null) {
            return null;
        }
        return this.subFolder(this.getJournalRetentionDirectory());
    }

    @Override
    public long getJournalRetentionPeriod() {
        return this.journalRetentionPeriod;
    }

    @Override
    public Configuration setJournalRetentionPeriod(TimeUnit unit, long period) {
        this.journalRetentionPeriod = period <= 0L ? -1L : unit.toMillis(period);
        return this;
    }

    public void setJournalRetentionPeriod(long periodMillis) {
        this.journalRetentionPeriod = periodMillis <= 0L ? -1L : periodMillis;
    }

    @Override
    public long getJournalRetentionMaxBytes() {
        return this.journalRetentionMaxBytes;
    }

    @Override
    public ConfigurationImpl setJournalRetentionMaxBytes(long bytes) {
        this.journalRetentionMaxBytes = bytes;
        return this;
    }

    @Override
    public Configuration setSystemPropertyPrefix(String systemPropertyPrefix) {
        this.systemPropertyPrefix = systemPropertyPrefix;
        return this;
    }

    @Override
    public String getSystemPropertyPrefix() {
        return this.systemPropertyPrefix;
    }

    public String getBrokerPropertiesKeySurround() {
        return this.brokerPropertiesKeySurround;
    }

    public void setBrokerPropertiesKeySurround(String brokerPropertiesKeySurround) {
        this.brokerPropertiesKeySurround = brokerPropertiesKeySurround;
    }

    public String getBrokerPropertiesRemoveValue() {
        return this.brokerPropertiesRemoveValue;
    }

    @Override
    public Configuration parseProperties(String fileUrlToProperties) throws Exception {
        if ((fileUrlToProperties = this.resolvePropertiesSources(fileUrlToProperties)) != null) {
            for (String fileUrl : fileUrlToProperties.split(",")) {
                if (fileUrl.endsWith("/")) {
                    Object[] files;
                    File dir = new File(fileUrl);
                    if (!dir.exists() || (files = dir.list((file, s) -> s.endsWith(".json") || s.endsWith(".properties"))) == null || files.length <= 0) continue;
                    Arrays.sort(files);
                    for (Object fileName : files) {
                        this.parseFileProperties(new File(dir, (String)fileName));
                    }
                    continue;
                }
                this.parseFileProperties(new File(fileUrl));
            }
        }
        this.parsePrefixedProperties(System.getProperties(), this.systemPropertyPrefix);
        return this;
    }

    public void parseFileProperties(File file) throws Exception {
        ConfigurationImpl configuration = this;
        InsertionOrderedProperties brokerProperties = new InsertionOrderedProperties();
        try (CheckedInputStream checkedInputStream = new CheckedInputStream(new FileInputStream(file), new Adler32());){
            try {
                if (file.getName().endsWith(".json")) {
                    brokerProperties.loadJson(configuration, checkedInputStream);
                } else {
                    brokerProperties.load(checkedInputStream);
                }
                brokerProperties.setFileChecksum(checkedInputStream.getChecksum().getValue());
            }
            catch (Exception readOrParseError) {
                logger.debug("Properties config load error on file {}, {}", (Object)file.getName(), (Object)readOrParseError);
                this.updateApplyStatus(file.getName(), Map.of("loadError", readOrParseError.toString()));
                checkedInputStream.close();
                return;
            }
        }
        this.parsePrefixedProperties(this, file.getName(), brokerProperties, null);
    }

    public void parsePrefixedProperties(Properties properties, String prefix) throws Exception {
        this.parsePrefixedProperties(this, "system-" + prefix, properties, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parsePrefixedProperties(Object target, String name, Properties properties, String prefix) throws Exception {
        LinkedHashMap<String, Object> beanProperties = new LinkedHashMap<String, Object>();
        Adler32 checksum = new Adler32();
        Properties properties2 = properties;
        synchronized (properties2) {
            String key = null;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                key = entry.getKey().toString();
                if (prefix != null) {
                    if (!key.startsWith(prefix)) continue;
                    key = entry.getKey().toString().substring(prefix.length());
                }
                String value = entry.getValue().toString();
                checksum.update(key.getBytes(StandardCharsets.UTF_8));
                checksum.update(61);
                checksum.update(value.getBytes(StandardCharsets.UTF_8));
                value = XMLUtil.replaceSystemPropsInString((String)value);
                key = XMLUtil.replaceSystemPropsInString((String)key);
                boolean masked = PasswordMaskingUtil.isEncMasked((String)value);
                if (masked) {
                    value = PasswordMaskingUtil.resolveMask(null, (String)value, (String)this.getPasswordCodec());
                    this.keysToRedact.add(key);
                }
                logger.debug("Property config, {}={}", (Object)key, (Object)(masked || this.shouldRedact(key) ? REDACTED : value));
                beanProperties.put(key, value);
            }
        }
        long fileAlder32 = 0L;
        if (properties instanceof InsertionOrderedProperties) {
            InsertionOrderedProperties insertionOrderedProperties = (InsertionOrderedProperties)properties;
            fileAlder32 = insertionOrderedProperties.getFileChecksum();
        }
        this.updateReadPropertiesStatus(name, checksum.getValue(), fileAlder32);
        if (!beanProperties.isEmpty()) {
            this.populateWithProperties(target, name, beanProperties);
        }
    }

    public void populateWithProperties(Object target, String propsId, Map<String, Object> beanProperties) throws InvocationTargetException, IllegalAccessException {
        final CollectionAutoFillPropertiesUtil autoFillCollections = new CollectionAutoFillPropertiesUtil(this.getBrokerPropertiesRemoveValue(beanProperties));
        BeanUtilsBean beanUtils = new BeanUtilsBean(new ConvertUtilsBean(), autoFillCollections){

            private Object initProperty(Object bean, String name) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
                Object propertyInstance;
                PropertyDescriptor descriptor = this.getPropertyUtils().getPropertyDescriptor(bean, name);
                if (descriptor == null) {
                    throw new InvocationTargetException(null, "No accessor method descriptor for: " + name + " on: " + String.valueOf(bean.getClass()));
                }
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null) {
                    throw new InvocationTargetException(null, "No Write method for: " + name + " on: " + String.valueOf(bean.getClass()));
                }
                try {
                    propertyInstance = descriptor.getPropertyType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new InvocationTargetException(e);
                }
                writeMethod.invoke(bean, propertyInstance);
                return propertyInstance;
            }

            public void setProperty(Object bean, String name, Object value) throws InvocationTargetException, IllegalAccessException {
                if (logger.isDebugEnabled()) {
                    logger.debug("setProperty on {}, name: {}, value: {}", new Object[]{bean.getClass(), name, value});
                }
                Object target = bean;
                Resolver resolver = this.getPropertyUtils().getResolver();
                while (resolver.hasNested(name)) {
                    try {
                        String nextName = resolver.next(name);
                        Object nextTarget = this.getPropertyUtils().getProperty(target, nextName);
                        if (nextTarget == null) {
                            if (resolver.isMapped(nextName)) {
                                throw new InvocationTargetException(null, "Entry does not exist in: " + resolver.getProperty(name) + " for mapped key: " + resolver.getKey(name));
                            }
                            nextTarget = this.initProperty(target, nextName);
                        }
                        target = nextTarget;
                        name = resolver.remove(name);
                    }
                    catch (NoSuchMethodException e) {
                        throw new InvocationTargetException(e, "No getter for property:" + name + ", on: " + String.valueOf(bean));
                    }
                }
                logger.trace("resolved target, bean: {}, name: {}", target.getClass(), (Object)name);
                String propName = resolver.getProperty(name);
                if (autoFillCollections.isRemoveValue(value)) {
                    logger.trace("removing from target, bean: {}, name: {}", target.getClass(), (Object)name);
                    if (!autoFillCollections.collections.isEmpty()) {
                        autoFillCollections.collections.pop();
                    }
                    if (target instanceof Map) {
                        Map targetMap = (Map)target;
                        Iterator i = targetMap.entrySet().iterator();
                        while (i.hasNext()) {
                            String key = (String)i.next().getKey();
                            if (!propName.equals(key)) continue;
                            i.remove();
                            break;
                        }
                    } else {
                        if (target instanceof Collection) {
                            Collection targetCollection = (Collection)target;
                            try {
                                autoFillCollections.removeByNameProperty(propName, targetCollection);
                            }
                            catch (NoSuchMethodException e) {
                                throw new InvocationTargetException(e, "Can only remove named entries from collections or maps. property: " + name + ", on: " + String.valueOf(target));
                            }
                        }
                        try {
                            target = this.getPropertyUtils().getProperty(target, name);
                        }
                        catch (NoSuchMethodException e) {
                            throw new InvocationTargetException(e, "Can only clear entries from collection or map properties that are accessible. property: " + name + ", on: " + String.valueOf(target));
                        }
                        if (target instanceof Map) {
                            Map mapToClear = (Map)target;
                            mapToClear.clear();
                        } else if (target instanceof Collection) {
                            Collection collectionToClear = (Collection)target;
                            collectionToClear.clear();
                        } else {
                            throw new InvocationTargetException(null, "Can only clear entries from collection or map properties. property: " + name + ", on: " + String.valueOf(target));
                        }
                    }
                    logger.trace("removed from target, bean: {}, name: {}", target.getClass(), (Object)name);
                    return;
                }
                Class type = null;
                int index = resolver.getIndex(name);
                String key = resolver.getKey(name);
                if (target instanceof DynaBean) {
                    throw new InvocationTargetException(null, "Cannot determine DynaBean type to access: " + name + " on: " + String.valueOf(target));
                }
                if (target instanceof Map) {
                    type = Object.class;
                } else if (target != null && target.getClass().isArray() && index >= 0) {
                    type = Array.get(target, index).getClass();
                } else {
                    PropertyDescriptor descriptor = null;
                    try {
                        descriptor = this.getPropertyUtils().getPropertyDescriptor(target, name);
                        if (descriptor == null) {
                            throw new InvocationTargetException(null, "No accessor method descriptor for: " + name + " on: " + String.valueOf(target.getClass()));
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new InvocationTargetException(e, "Failed to get descriptor for: " + name + " on: " + String.valueOf(target.getClass()));
                    }
                    if (descriptor instanceof MappedPropertyDescriptor) {
                        MappedPropertyDescriptor mappedPropertyDescriptor = (MappedPropertyDescriptor)descriptor;
                        if (mappedPropertyDescriptor.getMappedWriteMethod() == null) {
                            throw new InvocationTargetException(null, "No mapped Write method for: " + name + " on: " + String.valueOf(target.getClass()));
                        }
                        type = mappedPropertyDescriptor.getMappedPropertyType();
                    } else if (index >= 0 && descriptor instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)descriptor;
                        if (indexedPropertyDescriptor.getIndexedWriteMethod() == null) {
                            throw new InvocationTargetException(null, "No indexed Write method for: " + name + " on: " + String.valueOf(target.getClass()));
                        }
                        type = indexedPropertyDescriptor.getIndexedPropertyType();
                    } else if (index >= 0 && List.class.isAssignableFrom(descriptor.getPropertyType())) {
                        type = Object.class;
                    } else if (key != null) {
                        if (descriptor.getReadMethod() == null) {
                            throw new InvocationTargetException(null, "No Read method for: " + name + " on: " + String.valueOf(target.getClass()));
                        }
                        type = value == null ? Object.class : value.getClass();
                    } else {
                        if (descriptor.getWriteMethod() == null) {
                            throw new InvocationTargetException(null, "No Write method for: " + name + " on: " + String.valueOf(target.getClass()));
                        }
                        type = descriptor.getPropertyType();
                    }
                }
                Object newValue = null;
                if (type.isArray() && index < 0) {
                    if (value == null) {
                        String[] values = new String[]{null};
                        newValue = this.getConvertUtils().convert(values, type);
                    } else if (value instanceof String) {
                        newValue = this.getConvertUtils().convert(value, type);
                    } else if (value instanceof String[]) {
                        strings = (String[])value;
                        newValue = this.getConvertUtils().convert(strings, type);
                    } else {
                        newValue = this.convert(value, type);
                    }
                } else if (type.isArray()) {
                    if (value instanceof String || value == null) {
                        newValue = this.getConvertUtils().convert((String)value, type.getComponentType());
                    } else if (value instanceof String[]) {
                        strings = (String[])value;
                        newValue = this.getConvertUtils().convert(strings[0], type.getComponentType());
                    } else {
                        newValue = this.convert(value, type.getComponentType());
                    }
                } else if (value instanceof String) {
                    String possibleDotClassValue = (String)value;
                    if (type != String.class && ConfigurationImpl.isClassProperty(possibleDotClassValue)) {
                        String clazzName = ConfigurationImpl.extractPropertyClassName(possibleDotClassValue);
                        try {
                            newValue = ClassloadingUtil.getInstanceWithTypeCheck((String)clazzName, (Class)type, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e, " for dot class value: " + possibleDotClassValue + ", on: " + String.valueOf(bean));
                        }
                    } else {
                        newValue = this.getConvertUtils().convert(possibleDotClassValue, type);
                    }
                } else if (value instanceof String[]) {
                    String[] strings = (String[])value;
                    newValue = this.getConvertUtils().convert(strings[0], type);
                } else {
                    newValue = this.convert(value, type);
                }
                try {
                    this.getPropertyUtils().setProperty(target, name, newValue);
                }
                catch (NoSuchMethodException e) {
                    throw new InvocationTargetException(e, "Cannot set: " + propName + " on: " + String.valueOf(target.getClass()));
                }
            }
        };
        autoFillCollections.setBeanUtilsBean(beanUtils);
        beanUtils.getPropertyUtils().setResolver((Resolver)new SurroundResolver(this.getBrokerPropertiesKeySurround(beanProperties)));
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return (T)SimpleString.of((String)value.toString());
            }
        }, SimpleString.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                NamedPropertyConfiguration instance = new NamedPropertyConfiguration();
                instance.setName(value.toString());
                instance.setProperties(new HashMap<String, String>());
                return (T)instance;
            }
        }, NamedPropertyConfiguration.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (StoreConfiguration.StoreType.DATABASE.toString().equals(value)) {
                    return (T)new DatabaseStorageConfiguration();
                }
                throw ActiveMQMessageBundle.BUNDLE.unsupportedStorePropertyType();
            }
        }, StoreConfiguration.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                ArrayList<String> convertedValue = new ArrayList<String>();
                for (String entry : value.toString().split(",")) {
                    convertedValue.add(entry);
                }
                return (T)convertedValue;
            }
        }, List.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                HashSet<String> convertedValue = new HashSet<String>();
                for (String entry : value.toString().split(",")) {
                    convertedValue.add(entry);
                }
                return (T)convertedValue;
            }
        }, Set.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                HashMap<String, String> convertedValue = new HashMap<String, String>();
                for (String entry : value.toString().split(",")) {
                    if (entry.isBlank()) continue;
                    String[] kv = entry.split("=");
                    if (2 != kv.length) {
                        throw new IllegalArgumentException("map value " + String.valueOf(value) + " not in k=v format");
                    }
                    convertedValue.put(kv[0], kv[1]);
                }
                return (T)convertedValue;
            }
        }, Map.class);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return (T)Long.valueOf(ByteUtil.convertTextBytes((String)value.toString()));
            }
        }, Long.TYPE);
        beanUtils.getConvertUtils().register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                HAPolicyConfiguration.TYPE haPolicyType = HAPolicyConfiguration.TYPE.valueOf(value.toString());
                return (T)(switch (haPolicyType) {
                    default -> throw new IncompatibleClassChangeError();
                    case HAPolicyConfiguration.TYPE.PRIMARY_ONLY -> new LiveOnlyPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.REPLICATION_PRIMARY_QUORUM_VOTING -> new ReplicatedPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.REPLICATION_BACKUP_QUORUM_VOTING -> new ReplicaPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.SHARED_STORE_PRIMARY -> new SharedStorePrimaryPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.SHARED_STORE_BACKUP -> new SharedStoreBackupPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.COLOCATED -> new ColocatedPolicyConfiguration();
                    case HAPolicyConfiguration.TYPE.REPLICATION_PRIMARY_LOCK_MANAGER -> ReplicationPrimaryPolicyConfiguration.withDefault();
                    case HAPolicyConfiguration.TYPE.REPLICATION_BACKUP_LOCK_MANAGER -> ReplicationBackupPolicyConfiguration.withDefault();
                });
            }
        }, HAPolicyConfiguration.class);
        BeanSupport.customise((BeanUtilsBean)beanUtils);
        logger.trace("populate: bean: {} with {}", (Object)this, beanProperties);
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : beanProperties.entrySet()) {
            String name = entry.getKey();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("set property target={}, name = {}, value = {}", new Object[]{target.getClass(), name, entry.getValue()});
                }
                beanUtils.setProperty(target, name, entry.getValue());
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.trace("failed to populate property with key: {}", (Object)name, (Object)invocationTargetException);
                Throwable toLog = invocationTargetException;
                if (invocationTargetException.getCause() != null) {
                    toLog = invocationTargetException.getCause();
                }
                this.trackError(errors, entry, toLog);
            }
            catch (Exception oops) {
                this.trackError(errors, entry, oops);
            }
        }
        this.updateApplyStatus(propsId, errors);
    }

    @Override
    public void exportAsProperties(File file) throws Exception {
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            this.writeProperties(writer);
        }
    }

    private void writeProperties(FileWriter writer) throws Exception {
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
        beanUtilsBean.getPropertyUtils().addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospectorWithIgnores());
        try (BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            this.export(beanUtilsBean, new Stack<String>(), bufferedWriter, this);
        }
    }

    private void export(BeanUtilsBean beanUtils, Stack<String> nested, BufferedWriter bufferedWriter, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (!collection.isEmpty()) {
                if (collection.stream().findFirst().orElseThrow() instanceof String) {
                    this.exportKeyValue(nested, bufferedWriter, collection.stream().collect(Collectors.joining(",")));
                } else if (collection instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)collection;
                    this.exportKeyValue(nested, bufferedWriter, enumSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                } else {
                    Stream<Object> stream = collection.stream();
                    Object e = collection.stream().findFirst().orElseThrow();
                    if (e instanceof AMQPBrokerConnectionElement) {
                        AMQPBrokerConnectionElement amqpBrokerConnectionElement = (AMQPBrokerConnectionElement)e;
                        String collectionName = nested.peek();
                        AMQPBrokerConnectionAddressType subsetType = AMQPBrokerConnectionAddressType.valueOf(collectionName.substring(0, collectionName.length() - 1).toUpperCase(Locale.ENGLISH));
                        stream = stream.filter(connectionElement -> subsetType == ((AMQPBrokerConnectionElement)connectionElement).getType());
                    }
                    stream.forEach(o -> {
                        nested.push(this.extractName(o));
                        this.export(beanUtils, nested, bufferedWriter, o);
                        nested.pop();
                    });
                }
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            if (!map.isEmpty()) {
                Stream<Object> stream = map.entrySet().stream();
                if (map.values().stream().findFirst().orElseThrow() instanceof FederationPolicy) {
                    Class filterOn = "addressPolicies".equals(nested.peek()) ? FederationAddressPolicyConfiguration.class : FederationQueuePolicyConfiguration.class;
                    stream = stream.filter(entry -> filterOn.isAssignableFrom(entry.getClass()));
                }
                stream.forEach(entry -> {
                    nested.push(entry.getKey().toString());
                    this.export(beanUtils, nested, bufferedWriter, entry.getValue());
                    nested.pop();
                });
            }
        } else if (this.isComplexConfigObject(value)) {
            if (value instanceof BrokerConnectConfiguration) {
                BrokerConnectConfiguration brokerConnectConfiguration = (BrokerConnectConfiguration)value;
                nested.push("uri");
                this.exportKeyValue(nested, bufferedWriter, brokerConnectConfiguration.getUri());
                nested.pop();
            } else if (value instanceof AMQPBrokerConnectionElement) {
                AMQPBrokerConnectionElement connectionElement2 = (AMQPBrokerConnectionElement)value;
                nested.push("type");
                this.exportKeyValue(nested, bufferedWriter, connectionElement2.getType().toString());
                nested.pop();
            } else if (value instanceof HAPolicyConfiguration) {
                HAPolicyConfiguration haPolicyConfiguration = (HAPolicyConfiguration)value;
                this.exportKeyValue(nested, bufferedWriter, haPolicyConfiguration.getType().toString());
            } else if (value instanceof StoreConfiguration) {
                StoreConfiguration storeConfiguration = (StoreConfiguration)value;
                this.exportKeyValue(nested, bufferedWriter, storeConfiguration.getStoreType().toString());
            } else if (value instanceof NamedPropertyConfiguration) {
                NamedPropertyConfiguration namedPropertyConfiguration = (NamedPropertyConfiguration)value;
                this.exportKeyValue(nested, bufferedWriter, namedPropertyConfiguration.getName());
            } else if (value instanceof BroadcastEndpointFactory) {
                BroadcastEndpointFactory broadcastEndpointFactory = (BroadcastEndpointFactory)value;
                this.exportKeyValue(nested, bufferedWriter, broadcastEndpointFactory.getClass().getCanonicalName() + PROPERTY_CLASS_SUFFIX);
            } else if (value instanceof ActiveMQMetricsPlugin) {
                ActiveMQMetricsPlugin plugin = (ActiveMQMetricsPlugin)value;
                this.exportKeyValue(nested, bufferedWriter, plugin.getClass().getCanonicalName() + PROPERTY_CLASS_SUFFIX);
                nested.push("init");
                this.exportKeyValue(nested, bufferedWriter, "");
                nested.pop();
            }
            Arrays.stream(beanUtils.getPropertyUtils().getPropertyDescriptors(value)).filter(propertyDescriptor -> {
                if (this.ignored.contains(propertyDescriptor.getName())) {
                    return false;
                }
                Method descriptorReadMethod = propertyDescriptor.getReadMethod();
                if (descriptorReadMethod == null) {
                    return false;
                }
                Method descriptorWriteMethod = propertyDescriptor.getWriteMethod();
                if (descriptorWriteMethod == null) {
                    Class<?> type = propertyDescriptor.getPropertyType();
                    return Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
                }
                return true;
            }).sorted((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getName(), b.getName())).forEach(propertyDescriptor -> {
                Object attributeValue = null;
                try {
                    attributeValue = propertyDescriptor.getReadMethod().invoke(value, null);
                }
                catch (Exception e) {
                    throw new RuntimeException("accessing: " + propertyDescriptor.getName() + "@" + String.valueOf(nested), e);
                }
                if (attributeValue != null) {
                    nested.push(propertyDescriptor.getName());
                    this.export(beanUtils, nested, bufferedWriter, attributeValue);
                    nested.pop();
                }
            });
        } else {
            this.exportKeyValue(nested, bufferedWriter, value.toString());
        }
    }

    private void exportKeyValue(Stack<String> nested, BufferedWriter bufferedWriter, String value) {
        String key = this.writeKeyEquals(nested, bufferedWriter);
        try {
            if (this.shouldRedact(key)) {
                bufferedWriter.write(REDACTED);
            } else {
                bufferedWriter.write(value);
            }
            bufferedWriter.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException("error accessing: " + String.valueOf(nested), e);
        }
    }

    private boolean isComplexConfigObject(Object value) {
        return !(value instanceof SimpleString) && !(value instanceof Enum) && value.getClass().getPackage().getName().contains("artemis");
    }

    private boolean shouldRedact(String name) {
        return name.toUpperCase(Locale.ENGLISH).contains("PASSWORD") || this.keysToRedact.contains(name);
    }

    private String writeKeyEquals(Stack<String> nested, BufferedWriter bufferedWriter) {
        String key = ((Stream)nested.stream().sequential()).map(ConfigurationImpl::quote).collect(Collectors.joining("."));
        try {
            bufferedWriter.write(key);
            bufferedWriter.write("=");
        }
        catch (IOException e) {
            throw new RuntimeException("error accessing: " + String.valueOf(nested), e);
        }
        return key;
    }

    public static String quote(String s) {
        Object escaped = s.replace("=", "\\\\=").replace(":", "\\\\:");
        if (s.contains(".")) {
            escaped = "\"" + (String)escaped + "\"";
        }
        return escaped;
    }

    String extractName(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        try {
            Method m = o.getClass().getMethod("getName", null);
            if (m != null) {
                Object nameVal = m.invoke(o, null);
                if (nameVal == null) {
                    return "name-attribute-must-be-set-for-properties-key-export";
                }
                return nameVal.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(o);
    }

    protected static boolean isClassProperty(String property) {
        return property.endsWith(PROPERTY_CLASS_SUFFIX);
    }

    protected static String extractPropertyClassName(String property) {
        return property.substring(0, property.length() - PROPERTY_CLASS_SUFFIX.length());
    }

    private void trackError(Map<String, String> errors, Map.Entry<String, ?> entry, Throwable oops) {
        logger.debug("failed to populate property entry({}), reason: {}", entry, (Object)oops);
        errors.put(entry.toString(), oops.toString());
    }

    private synchronized void updateApplyStatus(String propsId, Map<String, String> errors) {
        JsonArrayBuilder errorsObjectArrayBuilder = JsonLoader.createArrayBuilder();
        for (Map.Entry<String, String> entry : errors.entrySet()) {
            errorsObjectArrayBuilder.add(JsonLoader.createObjectBuilder().add("value", entry.getKey()).add("reason", entry.getValue()));
        }
        JsonObject status = this.getJsonStatus();
        JsonObjectBuilder jsonObjectBuilder = JsonUtil.objectBuilderWithValueAtPath((String)("properties/" + propsId + "/errors"), (JsonValue)errorsObjectArrayBuilder.build());
        this.jsonStatus = JsonUtil.mergeAndUpdate((JsonObject)status, (JsonObject)jsonObjectBuilder.build());
    }

    private synchronized void updateReadPropertiesStatus(String propsId, long alder32Hash, long fileAlder32) {
        JsonObjectBuilder propertiesReadStatusBuilder = JsonLoader.createObjectBuilder();
        propertiesReadStatusBuilder.add("alder32", String.valueOf(alder32Hash));
        propertiesReadStatusBuilder.add("fileAlder32", String.valueOf(fileAlder32));
        JsonObjectBuilder jsonObjectBuilder = JsonUtil.objectBuilderWithValueAtPath((String)("properties/" + propsId), (JsonValue)propertiesReadStatusBuilder.build());
        JsonObject jsonStatus = this.getJsonStatus();
        this.jsonStatus = JsonUtil.mergeAndUpdate((JsonObject)jsonStatus, (JsonObject)jsonObjectBuilder.build());
    }

    private String getBrokerPropertiesKeySurround(Map<String, Object> propertiesToApply) {
        if (propertiesToApply.containsKey("key.surround")) {
            return String.valueOf(propertiesToApply.remove("key.surround"));
        }
        return System.getProperty(this.getSystemPropertyPrefix() + "key.surround", this.getBrokerPropertiesKeySurround());
    }

    private String getBrokerPropertiesRemoveValue(Map<String, Object> propertiesToApply) {
        if (propertiesToApply.containsKey("remove.value")) {
            return String.valueOf(propertiesToApply.remove("remove.value"));
        }
        return System.getProperty(this.getSystemPropertyPrefix() + "remove.value", this.getBrokerPropertiesRemoveValue());
    }

    @Override
    public boolean isClustered() {
        return !this.getClusterConfigurations().isEmpty();
    }

    @Override
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @Override
    public int getMaxDiskUsage() {
        return this.maxDiskUsage;
    }

    @Override
    public ConfigurationImpl setMaxDiskUsage(int maxDiskUsage) {
        this.maxDiskUsage = maxDiskUsage;
        return this;
    }

    @Override
    public long getMinDiskFree() {
        return this.minDiskFree;
    }

    @Override
    public ConfigurationImpl setMinDiskFree(long minDiskFree) {
        this.minDiskFree = minDiskFree;
        return this;
    }

    @Override
    public ConfigurationImpl setGlobalMaxSize(long maxSize) {
        this.globalMaxSize = maxSize;
        return this;
    }

    @Override
    public long getGlobalMaxSize() {
        if (this.globalMaxSize == null) {
            this.globalMaxSize = ActiveMQDefaultConfiguration.getDefaultMaxGlobalSizeAsPercentOfJvmMaxMemory((int)this.getGlobalMaxSizePercentOfJvmMaxMemory());
            if (!Env.isTestEnv()) {
                ActiveMQServerLogger.LOGGER.usingDefaultPaging(this.globalMaxSize);
            }
        }
        return this.globalMaxSize;
    }

    @Override
    public int getGlobalMaxSizePercentOfJvmMaxMemory() {
        return this.globalMaxSizePercentOfJvmMaxMemory;
    }

    @Override
    public ConfigurationImpl setGlobalMaxSizePercentOfJvmMaxMemory(int percentOfJvmMaxMemory) {
        this.globalMaxSizePercentOfJvmMaxMemory = percentOfJvmMaxMemory;
        return this;
    }

    @Override
    public ConfigurationImpl setGlobalMaxMessages(long maxMessages) {
        this.globalMaxMessages = maxMessages;
        return this;
    }

    @Override
    public long getGlobalMaxMessages() {
        if (this.globalMaxMessages == null) {
            this.globalMaxMessages = ActiveMQDefaultConfiguration.getDefaultMaxGlobalMessages();
        }
        return this.globalMaxMessages;
    }

    @Override
    public ConfigurationImpl setPersistenceEnabled(boolean enable) {
        this.persistenceEnabled = enable;
        return this;
    }

    @Override
    public Configuration setMaxRedeliveryRecords(int max) {
        this.maxRedeliveryRecords = max;
        return this;
    }

    @Override
    public int getMaxRedeliveryRecords() {
        return this.maxRedeliveryRecords;
    }

    @Override
    public boolean isJournalDatasync() {
        return this.journalDatasync;
    }

    @Override
    public ConfigurationImpl setJournalDatasync(boolean enable) {
        this.journalDatasync = enable;
        return this;
    }

    @Override
    public long getFileDeployerScanPeriod() {
        return this.fileDeploymentScanPeriod;
    }

    @Override
    public ConfigurationImpl setFileDeployerScanPeriod(long period) {
        this.fileDeploymentScanPeriod = period;
        return this;
    }

    @Override
    public boolean isPersistDeliveryCountBeforeDelivery() {
        return this.persistDeliveryCountBeforeDelivery;
    }

    @Override
    public ConfigurationImpl setPersistDeliveryCountBeforeDelivery(boolean persistDeliveryCountBeforeDelivery) {
        this.persistDeliveryCountBeforeDelivery = persistDeliveryCountBeforeDelivery;
        return this;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public ConfigurationImpl setScheduledThreadPoolMaxSize(int maxSize) {
        this.scheduledThreadPoolMaxSize = maxSize;
        return this;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public ConfigurationImpl setThreadPoolMaxSize(int maxSize) {
        this.threadPoolMaxSize = maxSize;
        return this;
    }

    @Override
    public long getSecurityInvalidationInterval() {
        return this.securityInvalidationInterval;
    }

    @Override
    public ConfigurationImpl setSecurityInvalidationInterval(long interval) {
        this.securityInvalidationInterval = interval;
        return this;
    }

    @Override
    public long getAuthenticationCacheSize() {
        return this.authenticationCacheSize;
    }

    @Override
    public ConfigurationImpl setAuthenticationCacheSize(long size) {
        this.authenticationCacheSize = size;
        return this;
    }

    @Override
    public long getAuthorizationCacheSize() {
        return this.authorizationCacheSize;
    }

    @Override
    public ConfigurationImpl setAuthorizationCacheSize(long size) {
        this.authorizationCacheSize = size;
        return this;
    }

    @Override
    public long getConnectionTTLOverride() {
        return this.connectionTTLOverride;
    }

    @Override
    public ConfigurationImpl setConnectionTTLOverride(long ttl) {
        this.connectionTTLOverride = ttl;
        return this;
    }

    @Override
    public boolean isAmqpUseCoreSubscriptionNaming() {
        return this.amqpUseCoreSubscriptionNaming;
    }

    @Override
    public Configuration setAmqpUseCoreSubscriptionNaming(boolean amqpUseCoreSubscriptionNaming) {
        this.amqpUseCoreSubscriptionNaming = amqpUseCoreSubscriptionNaming;
        return this;
    }

    @Override
    public boolean isAsyncConnectionExecutionEnabled() {
        return this.asyncConnectionExecutionEnabled;
    }

    @Override
    public ConfigurationImpl setEnabledAsyncConnectionExecution(boolean enabled) {
        this.asyncConnectionExecutionEnabled = enabled;
        return this;
    }

    @Override
    public List<String> getIncomingInterceptorClassNames() {
        return this.incomingInterceptorClassNames;
    }

    @Override
    public ConfigurationImpl setIncomingInterceptorClassNames(List<String> interceptors) {
        this.incomingInterceptorClassNames = interceptors;
        return this;
    }

    @Override
    public List<String> getOutgoingInterceptorClassNames() {
        return this.outgoingInterceptorClassNames;
    }

    @Override
    public ConfigurationImpl setOutgoingInterceptorClassNames(List<String> interceptors) {
        this.outgoingInterceptorClassNames = interceptors;
        return this;
    }

    @Override
    public Set<TransportConfiguration> getAcceptorConfigurations() {
        return this.acceptorConfigs;
    }

    @Override
    public ConfigurationImpl setAcceptorConfigurations(Set<TransportConfiguration> infos) {
        this.acceptorConfigs = infos;
        return this;
    }

    @Override
    public ConfigurationImpl addAcceptorConfiguration(TransportConfiguration infos) {
        this.acceptorConfigs.add(infos);
        return this;
    }

    @Override
    public ConfigurationImpl addAcceptorConfiguration(String name, String uri) throws Exception {
        List<TransportConfiguration> configurations = ConfigurationUtils.parseAcceptorURI(name, uri);
        for (TransportConfiguration config : configurations) {
            this.addAcceptorConfiguration(config);
        }
        return this;
    }

    @Override
    public ConfigurationImpl clearAcceptorConfigurations() {
        this.acceptorConfigs.clear();
        return this;
    }

    @Override
    public Map<String, TransportConfiguration> getConnectorConfigurations() {
        return this.connectorConfigs;
    }

    @Override
    public ConfigurationImpl setConnectorConfigurations(Map<String, TransportConfiguration> infos) {
        this.connectorConfigs = infos;
        return this;
    }

    @Override
    public ConfigurationImpl addConnectorConfiguration(String key, TransportConfiguration info) {
        this.connectorConfigs.put(key, info);
        return this;
    }

    public ConfigurationImpl addConnectorConfiguration(TransportConfiguration info) {
        this.connectorConfigs.put(info.getName(), info);
        return this;
    }

    @Override
    public ConfigurationImpl addConnectorConfiguration(String name, String uri) throws Exception {
        List<TransportConfiguration> configurations = ConfigurationUtils.parseConnectorURI(name, uri);
        for (TransportConfiguration config : configurations) {
            this.addConnectorConfiguration(name, config);
        }
        return this;
    }

    @Override
    public ConfigurationImpl clearConnectorConfigurations() {
        this.connectorConfigs.clear();
        return this;
    }

    @Override
    public GroupingHandlerConfiguration getGroupingHandlerConfiguration() {
        return this.groupingHandlerConfiguration;
    }

    @Override
    public ConfigurationImpl setGroupingHandlerConfiguration(GroupingHandlerConfiguration groupingHandlerConfiguration) {
        this.groupingHandlerConfiguration = groupingHandlerConfiguration;
        return this;
    }

    @Override
    public List<BridgeConfiguration> getBridgeConfigurations() {
        return this.bridgeConfigurations;
    }

    @Override
    public ConfigurationImpl setBridgeConfigurations(List<BridgeConfiguration> configs) {
        this.bridgeConfigurations = configs;
        return this;
    }

    public ConfigurationImpl addBridgeConfiguration(BridgeConfiguration config) {
        this.bridgeConfigurations.add(config);
        return this;
    }

    @Override
    public List<BroadcastGroupConfiguration> getBroadcastGroupConfigurations() {
        return this.broadcastGroupConfigurations;
    }

    @Override
    public ConfigurationImpl setBroadcastGroupConfigurations(List<BroadcastGroupConfiguration> configs) {
        this.broadcastGroupConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addBroadcastGroupConfiguration(BroadcastGroupConfiguration config) {
        this.broadcastGroupConfigurations.add(config);
        return this;
    }

    @Override
    public List<ClusterConnectionConfiguration> getClusterConfigurations() {
        return this.clusterConfigurations;
    }

    @Override
    public ConfigurationImpl setClusterConfigurations(List<ClusterConnectionConfiguration> configs) {
        this.clusterConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addClusterConfiguration(ClusterConnectionConfiguration config) {
        this.clusterConfigurations.add(config);
        return this;
    }

    @Override
    public ClusterConnectionConfiguration addClusterConfiguration(String name, String uri) throws Exception {
        ClusterConnectionConfiguration newConfig = new ClusterConnectionConfiguration(new URI(uri)).setName(name);
        this.clusterConfigurations.add(newConfig);
        return newConfig;
    }

    @Override
    public ConfigurationImpl addAMQPConnection(AMQPBrokerConnectConfiguration amqpBrokerConnectConfiguration) {
        this.amqpBrokerConnectConfigurations.add(amqpBrokerConnectConfiguration);
        return this;
    }

    @Override
    public List<AMQPBrokerConnectConfiguration> getAMQPConnection() {
        return this.amqpBrokerConnectConfigurations;
    }

    public List<AMQPBrokerConnectConfiguration> getAMQPConnections() {
        return this.amqpBrokerConnectConfigurations;
    }

    @Override
    public Configuration setAMQPConnectionConfigurations(List<AMQPBrokerConnectConfiguration> amqpConnectionConfiugrations) {
        this.amqpBrokerConnectConfigurations.clear();
        this.amqpBrokerConnectConfigurations.addAll(amqpConnectionConfiugrations);
        return this;
    }

    @Override
    public Configuration clearAMQPConnectionConfigurations() {
        this.amqpBrokerConnectConfigurations.clear();
        return this;
    }

    @Override
    public ConfigurationImpl clearClusterConfigurations() {
        this.clusterConfigurations.clear();
        return this;
    }

    @Override
    public List<DivertConfiguration> getDivertConfigurations() {
        return this.divertConfigurations;
    }

    @Override
    public ConfigurationImpl setDivertConfigurations(List<DivertConfiguration> configs) {
        this.divertConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addDivertConfiguration(DivertConfiguration config) {
        this.divertConfigurations.add(config);
        return this;
    }

    @Override
    public List<ConnectionRouterConfiguration> getConnectionRouters() {
        return this.connectionRouters;
    }

    @Override
    public ConfigurationImpl setConnectionRouters(List<ConnectionRouterConfiguration> configs) {
        this.connectionRouters = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addConnectionRouter(ConnectionRouterConfiguration config) {
        this.connectionRouters.add(config);
        return this;
    }

    @Override
    @Deprecated
    public List<CoreQueueConfiguration> getQueueConfigurations() {
        return this.coreQueueConfigurations;
    }

    @Override
    public List<QueueConfiguration> getQueueConfigs() {
        ArrayList<QueueConfiguration> result = new ArrayList<QueueConfiguration>();
        for (CoreQueueConfiguration coreQueueConfiguration : this.coreQueueConfigurations) {
            result.add(coreQueueConfiguration.toQueueConfiguration());
        }
        return result;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setQueueConfigurations(List<CoreQueueConfiguration> coreQueueConfigurations) {
        this.coreQueueConfigurations = coreQueueConfigurations;
        return this;
    }

    @Override
    public ConfigurationImpl setQueueConfigs(List<QueueConfiguration> configs) {
        for (QueueConfiguration queueConfiguration : configs) {
            this.coreQueueConfigurations.add(CoreQueueConfiguration.fromQueueConfiguration(queueConfiguration));
        }
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationImpl addQueueConfiguration(CoreQueueConfiguration config) {
        this.coreQueueConfigurations.add(config);
        return this;
    }

    @Override
    public ConfigurationImpl addQueueConfiguration(QueueConfiguration config) {
        this.coreQueueConfigurations.add(CoreQueueConfiguration.fromQueueConfiguration(config));
        return this;
    }

    @Override
    public List<CoreAddressConfiguration> getAddressConfigurations() {
        return this.addressConfigurations;
    }

    @Override
    public Configuration setAddressConfigurations(List<CoreAddressConfiguration> configs) {
        this.addressConfigurations = configs;
        return this;
    }

    @Override
    public Configuration addAddressConfiguration(CoreAddressConfiguration config) {
        this.addressConfigurations.add(config);
        return this;
    }

    @Override
    public Map<String, DiscoveryGroupConfiguration> getDiscoveryGroupConfigurations() {
        return this.discoveryGroupConfigurations;
    }

    @Override
    public ConfigurationImpl setDiscoveryGroupConfigurations(Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations) {
        this.discoveryGroupConfigurations = discoveryGroupConfigurations;
        return this;
    }

    @Override
    public ConfigurationImpl addDiscoveryGroupConfiguration(String key, DiscoveryGroupConfiguration discoveryGroupConfiguration) {
        this.discoveryGroupConfigurations.put(key, discoveryGroupConfiguration);
        return this;
    }

    @Override
    public int getIDCacheSize() {
        return this.idCacheSize;
    }

    @Override
    public ConfigurationImpl setIDCacheSize(int idCacheSize) {
        this.idCacheSize = idCacheSize;
        return this;
    }

    @Override
    public boolean isPersistIDCache() {
        return this.persistIDCache;
    }

    @Override
    public ConfigurationImpl setPersistIDCache(boolean persist) {
        this.persistIDCache = persist;
        return this;
    }

    @Override
    public File getBindingsLocation() {
        return this.subFolder(this.getBindingsDirectory());
    }

    @Override
    public String getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    @Override
    public ConfigurationImpl setBindingsDirectory(String dir) {
        this.bindingsDirectory = dir;
        return this;
    }

    @Override
    public int getPageMaxConcurrentIO() {
        return this.maxConcurrentPageIO;
    }

    @Override
    public ConfigurationImpl setPageMaxConcurrentIO(int maxIO) {
        this.maxConcurrentPageIO = maxIO;
        return this;
    }

    @Override
    public boolean isReadWholePage() {
        return this.readWholePage;
    }

    @Override
    public ConfigurationImpl setReadWholePage(boolean read) {
        this.readWholePage = read;
        return this;
    }

    @Override
    public File getJournalLocation() {
        return this.subFolder(this.getJournalDirectory());
    }

    @Override
    public String getJournalDirectory() {
        return this.journalDirectory;
    }

    @Override
    public ConfigurationImpl setJournalDirectory(String dir) {
        this.journalDirectory = dir;
        return this;
    }

    @Override
    public File getNodeManagerLockLocation() {
        if (this.nodeManagerLockDirectory == null) {
            return this.getJournalLocation();
        }
        return this.subFolder(this.nodeManagerLockDirectory);
    }

    @Override
    public Configuration setNodeManagerLockDirectory(String dir) {
        this.nodeManagerLockDirectory = dir;
        return this;
    }

    @Override
    public String getNodeManagerLockDirectory() {
        return this.nodeManagerLockDirectory;
    }

    @Override
    public JournalType getJournalType() {
        return this.journalType;
    }

    @Override
    public ConfigurationImpl setPagingDirectory(String dir) {
        this.pagingDirectory = dir;
        return this;
    }

    @Override
    public File getPagingLocation() {
        return this.subFolder(this.getPagingDirectory());
    }

    @Override
    public String getPagingDirectory() {
        return this.pagingDirectory;
    }

    @Override
    public ConfigurationImpl setJournalType(JournalType type) {
        this.journalType = type;
        return this;
    }

    @Override
    public boolean isJournalSyncTransactional() {
        return this.journalSyncTransactional;
    }

    @Override
    public ConfigurationImpl setJournalSyncTransactional(boolean sync) {
        this.journalSyncTransactional = sync;
        return this;
    }

    @Override
    public boolean isJournalSyncNonTransactional() {
        return this.journalSyncNonTransactional;
    }

    @Override
    public ConfigurationImpl setJournalSyncNonTransactional(boolean sync) {
        this.journalSyncNonTransactional = sync;
        return this;
    }

    @Override
    public int getJournalFileSize() {
        return this.journalFileSize;
    }

    @Override
    public ConfigurationImpl setJournalFileSize(int size) {
        this.journalFileSize = size;
        return this;
    }

    @Override
    public int getJournalPoolFiles() {
        return this.journalPoolFiles;
    }

    @Override
    public Configuration setJournalPoolFiles(int poolSize) {
        this.journalPoolFiles = poolSize;
        if (!Env.isTestEnv() && poolSize < 0) {
            ActiveMQServerLogger.LOGGER.useFixedValueOnJournalPoolFiles();
        }
        return this;
    }

    @Override
    public int getJournalMinFiles() {
        return this.journalMinFiles;
    }

    @Override
    public ConfigurationImpl setJournalMinFiles(int files) {
        this.journalMinFiles = files;
        return this;
    }

    @Override
    public boolean isLogJournalWriteRate() {
        return this.logJournalWriteRate;
    }

    @Override
    public ConfigurationImpl setLogJournalWriteRate(boolean logJournalWriteRate) {
        this.logJournalWriteRate = logJournalWriteRate;
        return this;
    }

    @Override
    public boolean isCreateBindingsDir() {
        return this.createBindingsDir;
    }

    @Override
    public ConfigurationImpl setCreateBindingsDir(boolean create) {
        this.createBindingsDir = create;
        return this;
    }

    @Override
    public boolean isCreateJournalDir() {
        return this.createJournalDir;
    }

    @Override
    public ConfigurationImpl setCreateJournalDir(boolean create) {
        this.createJournalDir = create;
        return this;
    }

    @Override
    @Deprecated
    public boolean isWildcardRoutingEnabled() {
        return this.wildcardConfiguration.isRoutingEnabled();
    }

    @Override
    @Deprecated
    public ConfigurationImpl setWildcardRoutingEnabled(boolean enabled) {
        ActiveMQServerLogger.LOGGER.deprecatedWildcardRoutingEnabled();
        this.wildcardConfiguration.setRoutingEnabled(enabled);
        return this;
    }

    @Override
    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    @Override
    public Configuration setWildCardConfiguration(WildcardConfiguration wildcardConfiguration) {
        this.wildcardConfiguration = wildcardConfiguration;
        return this;
    }

    @Override
    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public ConfigurationImpl setTransactionTimeout(long timeout) {
        this.transactionTimeout = timeout;
        return this;
    }

    @Override
    public long getTransactionTimeoutScanPeriod() {
        return this.transactionTimeoutScanPeriod;
    }

    @Override
    public ConfigurationImpl setTransactionTimeoutScanPeriod(long period) {
        this.transactionTimeoutScanPeriod = period;
        return this;
    }

    @Override
    public long getMessageExpiryScanPeriod() {
        return this.messageExpiryScanPeriod;
    }

    @Override
    public ConfigurationImpl setMessageExpiryScanPeriod(long messageExpiryScanPeriod) {
        this.messageExpiryScanPeriod = messageExpiryScanPeriod;
        return this;
    }

    @Override
    public int getMessageExpiryThreadPriority() {
        return this.messageExpiryThreadPriority;
    }

    @Override
    public ConfigurationImpl setMessageExpiryThreadPriority(int messageExpiryThreadPriority) {
        this.messageExpiryThreadPriority = messageExpiryThreadPriority;
        return this;
    }

    @Override
    public long getAddressQueueScanPeriod() {
        return this.addressQueueScanPeriod;
    }

    @Override
    public ConfigurationImpl setAddressQueueScanPeriod(long addressQueueScanPeriod) {
        this.addressQueueScanPeriod = addressQueueScanPeriod;
        return this;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public ConfigurationImpl setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
        return this;
    }

    @Override
    public boolean isGracefulShutdownEnabled() {
        return this.gracefulShutdownEnabled;
    }

    @Override
    public ConfigurationImpl setGracefulShutdownEnabled(boolean enabled) {
        this.gracefulShutdownEnabled = enabled;
        return this;
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    @Override
    public ConfigurationImpl setGracefulShutdownTimeout(long timeout) {
        this.gracefulShutdownTimeout = timeout;
        return this;
    }

    @Override
    public boolean isJMXManagementEnabled() {
        return this.jmxManagementEnabled;
    }

    @Override
    public ConfigurationImpl setJMXManagementEnabled(boolean enabled) {
        this.jmxManagementEnabled = enabled;
        return this;
    }

    @Override
    public String getJMXDomain() {
        return this.jmxDomain;
    }

    @Override
    public ConfigurationImpl setJMXDomain(String domain) {
        this.jmxDomain = domain;
        return this;
    }

    @Override
    public boolean isJMXUseBrokerName() {
        return this.jmxUseBrokerName;
    }

    @Override
    public ConfigurationImpl setJMXUseBrokerName(boolean jmxUseBrokerName) {
        this.jmxUseBrokerName = jmxUseBrokerName;
        return this;
    }

    @Override
    public String getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    @Override
    public File getLargeMessagesLocation() {
        return this.subFolder(this.getLargeMessagesDirectory());
    }

    @Override
    public ConfigurationImpl setLargeMessagesDirectory(String directory) {
        this.largeMessagesDirectory = directory;
        return this;
    }

    @Override
    public boolean isMessageCounterEnabled() {
        return this.messageCounterEnabled;
    }

    @Override
    public ConfigurationImpl setMessageCounterEnabled(boolean enabled) {
        this.messageCounterEnabled = enabled;
        return this;
    }

    @Override
    public long getMessageCounterSamplePeriod() {
        return this.messageCounterSamplePeriod;
    }

    @Override
    public ConfigurationImpl setMessageCounterSamplePeriod(long period) {
        this.messageCounterSamplePeriod = period;
        return this;
    }

    @Override
    public int getMessageCounterMaxDayHistory() {
        return this.messageCounterMaxDayHistory;
    }

    @Override
    public ConfigurationImpl setMessageCounterMaxDayHistory(int maxDayHistory) {
        this.messageCounterMaxDayHistory = maxDayHistory;
        return this;
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public ConfigurationImpl setManagementAddress(SimpleString address) {
        this.managementAddress = address;
        return this;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    @Override
    public ConfigurationImpl setManagementNotificationAddress(SimpleString address) {
        this.managementNotificationAddress = address;
        return this;
    }

    @Override
    public String getClusterUser() {
        return this.clusterUser;
    }

    @Override
    public ConfigurationImpl setClusterUser(String user) {
        this.clusterUser = user;
        return this;
    }

    @Override
    public String getClusterPassword() {
        return this.clusterPassword;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public ConfigurationImpl setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        return this;
    }

    @Override
    public ConfigurationImpl setClusterPassword(String theclusterPassword) {
        this.clusterPassword = theclusterPassword;
        return this;
    }

    @Override
    public int getJournalCompactMinFiles() {
        return this.journalCompactMinFiles;
    }

    @Override
    public int getJournalCompactPercentage() {
        return this.journalCompactPercentage;
    }

    @Override
    public ConfigurationImpl setJournalCompactMinFiles(int minFiles) {
        this.journalCompactMinFiles = minFiles;
        return this;
    }

    @Override
    public int getJournalFileOpenTimeout() {
        return this.journalFileOpenTimeout;
    }

    @Override
    public Configuration setJournalFileOpenTimeout(int journalFileOpenTimeout) {
        this.journalFileOpenTimeout = journalFileOpenTimeout;
        return this;
    }

    @Override
    public ConfigurationImpl setJournalCompactPercentage(int percentage) {
        this.journalCompactPercentage = percentage;
        return this;
    }

    @Override
    public long getServerDumpInterval() {
        return this.serverDumpInterval;
    }

    @Override
    public ConfigurationImpl setServerDumpInterval(long intervalInMilliseconds) {
        this.serverDumpInterval = intervalInMilliseconds;
        return this;
    }

    @Override
    public int getMemoryWarningThreshold() {
        return this.memoryWarningThreshold;
    }

    @Override
    public ConfigurationImpl setMemoryWarningThreshold(int memoryWarningThreshold) {
        this.memoryWarningThreshold = memoryWarningThreshold;
        return this;
    }

    @Override
    public long getMemoryMeasureInterval() {
        return this.memoryMeasureInterval;
    }

    @Override
    public ConfigurationImpl setMemoryMeasureInterval(long memoryMeasureInterval) {
        this.memoryMeasureInterval = memoryMeasureInterval;
        return this;
    }

    @Override
    public int getJournalMaxIO_AIO() {
        return this.journalMaxIO_AIO;
    }

    @Override
    public ConfigurationImpl setJournalMaxIO_AIO(int journalMaxIO) {
        this.journalMaxIO_AIO = journalMaxIO;
        return this;
    }

    @Override
    public int getJournalBufferTimeout_AIO() {
        return this.journalBufferTimeout_AIO;
    }

    @Override
    public Integer getJournalDeviceBlockSize() {
        return this.deviceBlockSize;
    }

    @Override
    public ConfigurationImpl setJournalDeviceBlockSize(Integer deviceBlockSize) {
        this.deviceBlockSize = deviceBlockSize;
        return this;
    }

    @Override
    public ConfigurationImpl setJournalBufferTimeout_AIO(int journalBufferTimeout) {
        this.journalBufferTimeout_AIO = journalBufferTimeout;
        return this;
    }

    @Override
    public int getJournalBufferSize_AIO() {
        return this.journalBufferSize_AIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferSize_AIO(int journalBufferSize) {
        this.journalBufferSize_AIO = journalBufferSize;
        return this;
    }

    @Override
    public int getJournalMaxIO_NIO() {
        return this.journalMaxIO_NIO;
    }

    @Override
    public ConfigurationImpl setJournalMaxIO_NIO(int journalMaxIO) {
        this.journalMaxIO_NIO = journalMaxIO;
        return this;
    }

    @Override
    public int getJournalBufferTimeout_NIO() {
        return this.journalBufferTimeout_NIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferTimeout_NIO(int journalBufferTimeout) {
        this.journalBufferTimeout_NIO = journalBufferTimeout;
        return this;
    }

    @Override
    public int getJournalBufferSize_NIO() {
        return this.journalBufferSize_NIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferSize_NIO(int journalBufferSize) {
        this.journalBufferSize_NIO = journalBufferSize;
        return this;
    }

    @Override
    public Map<String, AddressSettings> getAddressSettings() {
        return this.addressSettings;
    }

    @Override
    public ConfigurationImpl setAddressSettings(Map<String, AddressSettings> addressesSettings) {
        this.addressSettings = addressesSettings;
        return this;
    }

    @Override
    public ConfigurationImpl addAddressSetting(String key, AddressSettings addressesSetting) {
        this.addressSettings.put(key, addressesSetting);
        return this;
    }

    @Override
    public ConfigurationImpl clearAddressSettings() {
        this.addressSettings.clear();
        return this;
    }

    @Override
    @Deprecated
    public Map<String, AddressSettings> getAddressesSettings() {
        return this.getAddressSettings();
    }

    @Override
    @Deprecated
    public ConfigurationImpl setAddressesSettings(Map<String, AddressSettings> addressesSettings) {
        return this.setAddressSettings((Map)addressesSettings);
    }

    @Override
    @Deprecated
    public ConfigurationImpl addAddressesSetting(String key, AddressSettings addressesSetting) {
        return this.addAddressSetting(key, addressesSetting);
    }

    @Override
    @Deprecated
    public ConfigurationImpl clearAddressesSettings() {
        return this.clearAddressSettings();
    }

    @Override
    public Map<String, ResourceLimitSettings> getResourceLimitSettings() {
        return this.resourceLimitSettings;
    }

    @Override
    public ConfigurationImpl setResourceLimitSettings(Map<String, ResourceLimitSettings> resourceLimitSettings) {
        this.resourceLimitSettings = resourceLimitSettings;
        return this;
    }

    @Override
    public ConfigurationImpl addResourceLimitSettings(ResourceLimitSettings resourceLimitSettings) {
        this.resourceLimitSettings.put(resourceLimitSettings.getMatch().toString(), resourceLimitSettings);
        return this;
    }

    public ConfigurationImpl addResourceLimitSetting(ResourceLimitSettings resourceLimitSettings) {
        return this.addResourceLimitSettings(resourceLimitSettings);
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        for (SecuritySettingPlugin securitySettingPlugin : this.securitySettingPlugins) {
            Map<String, Set<Role>> settings = securitySettingPlugin.getSecurityRoles();
            if (settings == null) continue;
            this.securitySettings.putAll(settings);
        }
        return this.securitySettings;
    }

    @Override
    public ConfigurationImpl putSecurityRoles(String match, Set<Role> roles) {
        this.securitySettings.put(match, new RoleSet(match, roles));
        return this;
    }

    public ConfigurationImpl addSecurityRole(String match, RoleSet roles) {
        this.securitySettings.put(match, roles);
        return this;
    }

    @Override
    public ConfigurationImpl setSecurityRoles(Map<String, Set<Role>> securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    @Override
    public Configuration addSecurityRoleNameMapping(String internalRole, Set<String> externalRoles) {
        if (this.securityRoleNameMappings.containsKey(internalRole)) {
            this.securityRoleNameMappings.get(internalRole).addAll(externalRoles);
        } else {
            this.securityRoleNameMappings.put(internalRole, externalRoles);
        }
        return this;
    }

    @Override
    public Map<String, Set<String>> getSecurityRoleNameMappings() {
        return this.securityRoleNameMappings;
    }

    @Override
    public List<ConnectorServiceConfiguration> getConnectorServiceConfigurations() {
        return this.connectorServiceConfigurations;
    }

    @Override
    public List<SecuritySettingPlugin> getSecuritySettingPlugins() {
        return this.securitySettingPlugins;
    }

    @Override
    @Deprecated
    public ActiveMQMetricsPlugin getMetricsPlugin() {
        if (this.metricsConfiguration != null) {
            return this.metricsConfiguration.getPlugin();
        }
        return null;
    }

    @Override
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    @Override
    public void registerBrokerPlugins(List<ActiveMQServerBasePlugin> plugins) {
        plugins.forEach(plugin -> this.registerBrokerPlugin((ActiveMQServerBasePlugin)plugin));
    }

    @Override
    public void registerBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        if (!this.brokerPlugins.contains(plugin)) {
            this.brokerPlugins.add(plugin);
        }
        if (plugin instanceof ActiveMQServerConnectionPlugin) {
            ActiveMQServerConnectionPlugin connectionPlugin = (ActiveMQServerConnectionPlugin)plugin;
            if (!this.brokerConnectionPlugins.contains(plugin)) {
                this.brokerConnectionPlugins.add(connectionPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerSessionPlugin) {
            ActiveMQServerSessionPlugin sessionPlugin = (ActiveMQServerSessionPlugin)plugin;
            if (!this.brokerSessionPlugins.contains(plugin)) {
                this.brokerSessionPlugins.add(sessionPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerConsumerPlugin) {
            ActiveMQServerConsumerPlugin consumerPlugin = (ActiveMQServerConsumerPlugin)plugin;
            if (!this.brokerConsumerPlugins.contains(plugin)) {
                this.brokerConsumerPlugins.add(consumerPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerAddressPlugin) {
            ActiveMQServerAddressPlugin addressPlugin = (ActiveMQServerAddressPlugin)plugin;
            if (!this.brokerAddressPlugins.contains(plugin)) {
                this.brokerAddressPlugins.add(addressPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerQueuePlugin) {
            ActiveMQServerQueuePlugin queuePlugin = (ActiveMQServerQueuePlugin)plugin;
            if (!this.brokerQueuePlugins.contains(plugin)) {
                this.brokerQueuePlugins.add(queuePlugin);
            }
        }
        if (plugin instanceof ActiveMQServerBindingPlugin) {
            ActiveMQServerBindingPlugin bindingPlugin = (ActiveMQServerBindingPlugin)plugin;
            if (!this.brokerBindingPlugins.contains(plugin)) {
                this.brokerBindingPlugins.add(bindingPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerMessagePlugin) {
            ActiveMQServerMessagePlugin messagePlugin = (ActiveMQServerMessagePlugin)plugin;
            if (!this.brokerMessagePlugins.contains(plugin)) {
                this.brokerMessagePlugins.add(messagePlugin);
            }
        }
        if (plugin instanceof ActiveMQServerBridgePlugin) {
            ActiveMQServerBridgePlugin bridgePlugin = (ActiveMQServerBridgePlugin)plugin;
            if (!this.brokerBridgePlugins.contains(plugin)) {
                this.brokerBridgePlugins.add(bridgePlugin);
            }
        }
        if (plugin instanceof ActiveMQServerCriticalPlugin) {
            ActiveMQServerCriticalPlugin criticalPlugin = (ActiveMQServerCriticalPlugin)plugin;
            if (!this.brokerCriticalPlugins.contains(plugin)) {
                this.brokerCriticalPlugins.add(criticalPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerFederationPlugin) {
            ActiveMQServerFederationPlugin federationPlugin = (ActiveMQServerFederationPlugin)plugin;
            if (!this.brokerFederationPlugins.contains(plugin)) {
                this.brokerFederationPlugins.add(federationPlugin);
            }
        }
        if (plugin instanceof AMQPFederationBrokerPlugin) {
            AMQPFederationBrokerPlugin brokerPlugin = (AMQPFederationBrokerPlugin)plugin;
            if (!this.brokerAMQPFederationPlugins.contains(plugin)) {
                this.brokerAMQPFederationPlugins.add(brokerPlugin);
            }
        }
        if (plugin instanceof ActiveMQServerResourcePlugin) {
            ActiveMQServerResourcePlugin resourcePlugin = (ActiveMQServerResourcePlugin)plugin;
            if (!this.brokerResourcePlugins.contains(plugin)) {
                this.brokerResourcePlugins.add(resourcePlugin);
            }
        }
    }

    @Override
    public void unRegisterBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        this.brokerPlugins.remove(plugin);
        if (plugin instanceof ActiveMQServerConnectionPlugin) {
            this.brokerConnectionPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerSessionPlugin) {
            this.brokerSessionPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerConsumerPlugin) {
            this.brokerConsumerPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerAddressPlugin) {
            this.brokerAddressPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerQueuePlugin) {
            this.brokerQueuePlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerBindingPlugin) {
            this.brokerBindingPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerMessagePlugin) {
            this.brokerMessagePlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerBridgePlugin) {
            this.brokerBridgePlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerCriticalPlugin) {
            this.brokerCriticalPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerFederationPlugin) {
            this.brokerFederationPlugins.remove(plugin);
        }
        if (plugin instanceof AMQPFederationBrokerPlugin) {
            this.brokerAMQPFederationPlugins.remove(plugin);
        }
        if (plugin instanceof ActiveMQServerResourcePlugin) {
            this.brokerResourcePlugins.remove(plugin);
        }
    }

    @Override
    public List<ActiveMQServerBasePlugin> getBrokerPlugins() {
        return this.brokerPlugins;
    }

    public void addBrokerPlugin(ActiveMQServerBasePlugin type) {
        this.registerBrokerPlugin(type);
    }

    @Override
    public List<ActiveMQServerConnectionPlugin> getBrokerConnectionPlugins() {
        return this.brokerConnectionPlugins;
    }

    @Override
    public List<ActiveMQServerSessionPlugin> getBrokerSessionPlugins() {
        return this.brokerSessionPlugins;
    }

    @Override
    public List<ActiveMQServerConsumerPlugin> getBrokerConsumerPlugins() {
        return this.brokerConsumerPlugins;
    }

    @Override
    public List<ActiveMQServerAddressPlugin> getBrokerAddressPlugins() {
        return this.brokerAddressPlugins;
    }

    @Override
    public List<ActiveMQServerQueuePlugin> getBrokerQueuePlugins() {
        return this.brokerQueuePlugins;
    }

    @Override
    public List<ActiveMQServerBindingPlugin> getBrokerBindingPlugins() {
        return this.brokerBindingPlugins;
    }

    @Override
    public List<ActiveMQServerMessagePlugin> getBrokerMessagePlugins() {
        return this.brokerMessagePlugins;
    }

    @Override
    public List<ActiveMQServerBridgePlugin> getBrokerBridgePlugins() {
        return this.brokerBridgePlugins;
    }

    @Override
    public List<ActiveMQServerCriticalPlugin> getBrokerCriticalPlugins() {
        return this.brokerCriticalPlugins;
    }

    @Override
    public List<ActiveMQServerFederationPlugin> getBrokerFederationPlugins() {
        return this.brokerFederationPlugins;
    }

    @Override
    public List<AMQPFederationBrokerPlugin> getBrokerAMQPFederationPlugins() {
        return this.brokerAMQPFederationPlugins;
    }

    @Override
    public List<FederationConfiguration> getFederationConfigurations() {
        return this.federationConfigurations;
    }

    public void addFederationConfiguration(FederationConfiguration federationConfiguration) {
        this.federationConfigurations.add(federationConfiguration);
    }

    @Override
    public List<ActiveMQServerResourcePlugin> getBrokerResourcePlugins() {
        return this.brokerResourcePlugins;
    }

    @Override
    public File getBrokerInstance() {
        if (this.artemisInstance != null) {
            return this.artemisInstance;
        }
        String strartemisInstance = System.getProperty("artemis.instance");
        if (strartemisInstance == null) {
            strartemisInstance = System.getProperty("user.dir");
        }
        this.artemisInstance = new File(strartemisInstance);
        return this.artemisInstance;
    }

    @Override
    public void setBrokerInstance(File directory) {
        this.artemisInstance = directory;
    }

    public boolean isCheckForPrimaryServer() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            return ((ReplicatedPolicyConfiguration)this.haPolicyConfiguration).isCheckForActiveServer();
        }
        return false;
    }

    public ConfigurationImpl setCheckForPrimaryServer(boolean checkForPrimaryServer) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ((ReplicatedPolicyConfiguration)this.haPolicyConfiguration).setCheckForActiveServer(checkForPrimaryServer);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Broker Configuration (");
        sb.append("clustered=").append(this.isClustered()).append(",");
        if (this.isJDBC()) {
            DatabaseStorageConfiguration dsc = (DatabaseStorageConfiguration)this.getStoreConfiguration();
            sb.append("jdbcDriverClassName=").append(dsc.getDataSourceProperty("driverClassName")).append(",");
            sb.append("jdbcConnectionUrl=").append(dsc.getDataSourceProperty("url")).append(",");
            sb.append("messageTableName=").append(dsc.getMessageTableName()).append(",");
            sb.append("bindingsTableName=").append(dsc.getBindingsTableName()).append(",");
            sb.append("largeMessageTableName=").append(dsc.getLargeMessageTableName()).append(",");
            sb.append("pageStoreTableName=").append(dsc.getPageStoreTableName()).append(",");
        } else {
            sb.append("journalDirectory=").append(this.journalDirectory).append(",");
            sb.append("bindingsDirectory=").append(this.bindingsDirectory).append(",");
            sb.append("largeMessagesDirectory=").append(this.largeMessagesDirectory).append(",");
            sb.append("pagingDirectory=").append(this.pagingDirectory);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ConfigurationImpl setConnectorServiceConfigurations(List<ConnectorServiceConfiguration> configs) {
        this.connectorServiceConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addConnectorServiceConfiguration(ConnectorServiceConfiguration config) {
        this.connectorServiceConfigurations.add(config);
        return this;
    }

    @Override
    public ConfigurationImpl setSecuritySettingPlugins(List<SecuritySettingPlugin> plugins) {
        this.securitySettingPlugins = plugins;
        return this;
    }

    @Override
    public ConfigurationImpl addSecuritySettingPlugin(SecuritySettingPlugin plugin) {
        this.securitySettingPlugins.add(plugin);
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setMetricsPlugin(ActiveMQMetricsPlugin plugin) {
        if (this.metricsConfiguration == null) {
            this.metricsConfiguration = new MetricsConfiguration();
        }
        this.metricsConfiguration.setPlugin(plugin);
        return this;
    }

    @Override
    public ConfigurationImpl setMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
        return this;
    }

    @Override
    public Boolean isMaskPassword() {
        return this.maskPassword;
    }

    @Override
    public ConfigurationImpl setMaskPassword(Boolean maskPassword) {
        this.maskPassword = maskPassword;
        return this;
    }

    @Override
    public ConfigurationImpl setPasswordCodec(String codec) {
        this.passwordCodec = codec;
        return this;
    }

    @Override
    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ConfigurationImpl setResolveProtocols(boolean resolveProtocols) {
        this.resolveProtocols = resolveProtocols;
        return this;
    }

    @Override
    public TransportConfiguration[] getTransportConfigurations(String ... connectorNames) {
        return this.getTransportConfigurations(Arrays.asList(connectorNames));
    }

    @Override
    public TransportConfiguration[] getTransportConfigurations(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                ActiveMQServerLogger.LOGGER.connectionConfigurationIsNull(Objects.requireNonNullElse(connectorName, "null"));
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    @Override
    public String debugConnectors() {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            for (Map.Entry<String, TransportConfiguration> connector : this.getConnectorConfigurations().entrySet()) {
                writer.println("Connector::" + connector.getKey() + " value = " + String.valueOf(connector.getValue()));
            }
        }
        return stringWriter.toString();
    }

    @Override
    public boolean isResolveProtocols() {
        return this.resolveProtocols;
    }

    @Override
    public StoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    @Override
    public ConfigurationImpl setStoreConfiguration(StoreConfiguration storeConfiguration) {
        this.storeConfiguration = storeConfiguration;
        return this;
    }

    @Override
    public boolean isPopulateValidatedUser() {
        return this.populateValidatedUser;
    }

    @Override
    public ConfigurationImpl setPopulateValidatedUser(boolean populateValidatedUser) {
        this.populateValidatedUser = populateValidatedUser;
        return this;
    }

    @Override
    public boolean isRejectEmptyValidatedUser() {
        return this.rejectEmptyValidatedUser;
    }

    @Override
    public Configuration setRejectEmptyValidatedUser(boolean rejectEmptyValidatedUser) {
        this.rejectEmptyValidatedUser = rejectEmptyValidatedUser;
        return this;
    }

    @Override
    public long getConnectionTtlCheckInterval() {
        return this.connectionTtlCheckInterval;
    }

    @Override
    public ConfigurationImpl setConnectionTtlCheckInterval(long connectionTtlCheckInterval) {
        this.connectionTtlCheckInterval = connectionTtlCheckInterval;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptorConfigs, this.addressSettings, this.asyncConnectionExecutionEnabled, this.bindingsDirectory, this.bridgeConfigurations, this.broadcastGroupConfigurations, this.clusterConfigurations, this.clusterPassword, this.clusterUser, this.connectionTTLOverride, this.connectorConfigs, this.connectorServiceConfigurations, this.createBindingsDir, this.createJournalDir, this.discoveryGroupConfigurations, this.divertConfigurations, this.failoverOnServerShutdown, this.fileDeploymentScanPeriod, this.groupingHandlerConfiguration, this.idCacheSize, this.incomingInterceptorClassNames, this.jmxDomain, this.jmxManagementEnabled, this.journalBufferSize_AIO, this.journalBufferSize_NIO, this.journalBufferTimeout_AIO, this.journalBufferTimeout_NIO, this.journalCompactMinFiles, this.journalCompactPercentage, this.journalDirectory, this.journalFileSize, this.journalMaxIO_AIO, this.journalMaxIO_NIO, this.journalMinFiles, this.journalSyncNonTransactional, this.journalSyncTransactional, this.journalType, this.largeMessagesDirectory, this.logJournalWriteRate, this.managementAddress, this.managementNotificationAddress, this.maskPassword, this.maxConcurrentPageIO, this.memoryMeasureInterval, this.memoryWarningThreshold, this.messageCounterEnabled, this.messageCounterMaxDayHistory, this.messageCounterSamplePeriod, this.messageExpiryScanPeriod, this.messageExpiryThreadPriority, this.name, this.outgoingInterceptorClassNames, this.pagingDirectory, this.persistDeliveryCountBeforeDelivery, this.persistIDCache, this.persistenceEnabled, this.scheduledThreadPoolMaxSize, this.securityEnabled, this.populateValidatedUser, this.securityInvalidationInterval, this.securitySettings, this.serverDumpInterval, this.threadPoolMaxSize, this.transactionTimeout, this.transactionTimeoutScanPeriod, this.wildcardConfiguration, this.resolveProtocols, this.journalLockAcquisitionTimeout, this.connectionTtlCheckInterval});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfigurationImpl)) {
            return false;
        }
        ConfigurationImpl other = (ConfigurationImpl)obj;
        return Objects.equals(this.acceptorConfigs, other.acceptorConfigs) && Objects.equals(this.addressSettings, other.addressSettings) && this.asyncConnectionExecutionEnabled == other.asyncConnectionExecutionEnabled && Objects.equals(this.bindingsDirectory, other.bindingsDirectory) && Objects.equals(this.bridgeConfigurations, other.bridgeConfigurations) && Objects.equals(this.broadcastGroupConfigurations, other.broadcastGroupConfigurations) && Objects.equals(this.clusterConfigurations, other.clusterConfigurations) && Objects.equals(this.clusterPassword, other.clusterPassword) && Objects.equals(this.clusterUser, other.clusterUser) && this.connectionTTLOverride == other.connectionTTLOverride && Objects.equals(this.connectorConfigs, other.connectorConfigs) && Objects.equals(this.connectorServiceConfigurations, other.connectorServiceConfigurations) && this.createBindingsDir == other.createBindingsDir && this.createJournalDir == other.createJournalDir && Objects.equals(this.discoveryGroupConfigurations, other.discoveryGroupConfigurations) && Objects.equals(this.divertConfigurations, other.divertConfigurations) && this.failoverOnServerShutdown == other.failoverOnServerShutdown && this.fileDeploymentScanPeriod == other.fileDeploymentScanPeriod && Objects.equals(this.groupingHandlerConfiguration, other.groupingHandlerConfiguration) && this.idCacheSize == other.idCacheSize && Objects.equals(this.incomingInterceptorClassNames, other.incomingInterceptorClassNames) && Objects.equals(this.jmxDomain, other.jmxDomain) && this.jmxManagementEnabled == other.jmxManagementEnabled && this.journalBufferSize_AIO == other.journalBufferSize_AIO && this.journalBufferSize_NIO == other.journalBufferSize_NIO && this.journalBufferTimeout_AIO == other.journalBufferTimeout_AIO && this.journalBufferTimeout_NIO == other.journalBufferTimeout_NIO && this.journalCompactMinFiles == other.journalCompactMinFiles && this.journalCompactPercentage == other.journalCompactPercentage && Objects.equals(this.journalDirectory, other.journalDirectory) && this.journalFileSize == other.journalFileSize && this.journalMaxIO_AIO == other.journalMaxIO_AIO && this.journalMaxIO_NIO == other.journalMaxIO_NIO && this.journalMinFiles == other.journalMinFiles && this.journalSyncNonTransactional == other.journalSyncNonTransactional && this.journalSyncTransactional == other.journalSyncTransactional && this.journalType == other.journalType && Objects.equals(this.largeMessagesDirectory, other.largeMessagesDirectory) && this.logJournalWriteRate == other.logJournalWriteRate && Objects.equals(this.managementAddress, other.managementAddress) && Objects.equals(this.managementNotificationAddress, other.managementNotificationAddress) && Objects.equals(this.maskPassword, other.maskPassword) && this.maxConcurrentPageIO == other.maxConcurrentPageIO && this.memoryMeasureInterval == other.memoryMeasureInterval && this.memoryWarningThreshold == other.memoryWarningThreshold && this.messageCounterEnabled == other.messageCounterEnabled && this.messageCounterMaxDayHistory == other.messageCounterMaxDayHistory && this.messageCounterSamplePeriod == other.messageCounterSamplePeriod && this.messageExpiryScanPeriod == other.messageExpiryScanPeriod && this.messageExpiryThreadPriority == other.messageExpiryThreadPriority && Objects.equals(this.name, other.name) && Objects.equals(this.outgoingInterceptorClassNames, other.outgoingInterceptorClassNames) && Objects.equals(this.pagingDirectory, other.pagingDirectory) && this.persistDeliveryCountBeforeDelivery == other.persistDeliveryCountBeforeDelivery && this.persistIDCache == other.persistIDCache && this.persistenceEnabled == other.persistenceEnabled && this.scheduledThreadPoolMaxSize == other.scheduledThreadPoolMaxSize && this.securityEnabled == other.securityEnabled && this.populateValidatedUser == other.populateValidatedUser && this.securityInvalidationInterval == other.securityInvalidationInterval && Objects.equals(this.securitySettings, other.securitySettings) && this.serverDumpInterval == other.serverDumpInterval && this.threadPoolMaxSize == other.threadPoolMaxSize && this.transactionTimeout == other.transactionTimeout && this.transactionTimeoutScanPeriod == other.transactionTimeoutScanPeriod && Objects.equals(this.wildcardConfiguration, other.wildcardConfiguration) && this.resolveProtocols == other.resolveProtocols && this.journalLockAcquisitionTimeout == other.journalLockAcquisitionTimeout && this.connectionTtlCheckInterval == other.connectionTtlCheckInterval && this.journalDatasync == other.journalDatasync && Objects.equals(this.globalMaxSize, other.globalMaxSize) && this.maxDiskUsage == other.maxDiskUsage && this.minDiskFree == other.minDiskFree && this.diskScanPeriod == other.diskScanPeriod;
    }

    @Override
    public Configuration copy() throws Exception {
        return AccessController.doPrivileged(() -> {
            Configuration config;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(this);
            try (ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
                config = (Configuration)ois.readObject();
            }
            config.setBroadcastGroupConfigurations(this.getBroadcastGroupConfigurations());
            config.setDiscoveryGroupConfigurations(this.getDiscoveryGroupConfigurations());
            return config;
        });
    }

    @Override
    public ConfigurationImpl setJournalLockAcquisitionTimeout(long journalLockAcquisitionTimeout) {
        this.journalLockAcquisitionTimeout = journalLockAcquisitionTimeout;
        return this;
    }

    @Override
    public long getJournalLockAcquisitionTimeout() {
        return this.journalLockAcquisitionTimeout;
    }

    @Override
    public HAPolicyConfiguration getHAPolicyConfiguration() {
        return this.haPolicyConfiguration;
    }

    @Override
    public ConfigurationImpl setHAPolicyConfiguration(HAPolicyConfiguration haPolicyConfiguration) {
        this.haPolicyConfiguration = haPolicyConfiguration;
        return this;
    }

    @Override
    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    @Override
    public ConfigurationImpl setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    @Override
    public long getConfigurationFileRefreshPeriod() {
        return this.configurationFileRefreshPeriod;
    }

    @Override
    public ConfigurationImpl setConfigurationFileRefreshPeriod(long configurationFileRefreshPeriod) {
        this.configurationFileRefreshPeriod = configurationFileRefreshPeriod;
        return this;
    }

    @Override
    public int getDiskScanPeriod() {
        return this.diskScanPeriod;
    }

    @Override
    public String getInternalNamingPrefix() {
        return this.internalNamingPrefix;
    }

    @Override
    public ConfigurationImpl setInternalNamingPrefix(String internalNamingPrefix) {
        this.internalNamingPrefix = internalNamingPrefix;
        return this;
    }

    @Override
    public ConfigurationImpl setDiskScanPeriod(int diskScanPeriod) {
        this.diskScanPeriod = diskScanPeriod;
        return this;
    }

    @Override
    public ConfigurationImpl setNetworkCheckList(String list) {
        this.networkCheckList = list;
        return this;
    }

    @Override
    public String getNetworkCheckList() {
        return this.networkCheckList;
    }

    @Override
    public ConfigurationImpl setNetworkCheckURLList(String urls) {
        this.networkURLList = urls;
        return this;
    }

    @Override
    public String getNetworkCheckURLList() {
        return this.networkURLList;
    }

    @Override
    public ConfigurationImpl setNetworkCheckPeriod(long period) {
        this.networkCheckPeriod = period;
        return this;
    }

    @Override
    public long getNetworkCheckPeriod() {
        return this.networkCheckPeriod;
    }

    @Override
    public ConfigurationImpl setNetworkCheckTimeout(int timeout) {
        this.networkCheckTimeout = timeout;
        return this;
    }

    @Override
    public int getNetworkCheckTimeout() {
        return this.networkCheckTimeout;
    }

    @Override
    public Configuration setNetworCheckNIC(String nic) {
        this.networkCheckNIC = nic;
        return this;
    }

    @Override
    public Configuration setNetworkCheckNIC(String nic) {
        this.networkCheckNIC = nic;
        return this;
    }

    @Override
    public String getNetworkCheckNIC() {
        return this.networkCheckNIC;
    }

    @Override
    public String getNetworkCheckPingCommand() {
        return this.networkCheckPingCommand;
    }

    @Override
    public ConfigurationImpl setNetworkCheckPingCommand(String command) {
        this.networkCheckPingCommand = command;
        return this;
    }

    @Override
    public String getNetworkCheckPing6Command() {
        return this.networkCheckPing6Command;
    }

    @Override
    public Configuration setNetworkCheckPing6Command(String command) {
        this.networkCheckPing6Command = command;
        return this;
    }

    @Override
    public boolean isCriticalAnalyzer() {
        return this.criticalAnalyzer;
    }

    @Override
    public Configuration setCriticalAnalyzer(boolean CriticalAnalyzer2) {
        this.criticalAnalyzer = CriticalAnalyzer2;
        return this;
    }

    @Override
    public long getCriticalAnalyzerTimeout() {
        return this.criticalAnalyzerTimeout;
    }

    @Override
    public Configuration setCriticalAnalyzerTimeout(long timeout) {
        this.criticalAnalyzerTimeout = timeout;
        return this;
    }

    @Override
    public long getCriticalAnalyzerCheckPeriod() {
        if (this.criticalAnalyzerCheckPeriod <= 0L) {
            this.criticalAnalyzerCheckPeriod = ActiveMQDefaultConfiguration.getCriticalAnalyzerCheckPeriod((long)this.criticalAnalyzerTimeout);
        }
        return this.criticalAnalyzerCheckPeriod;
    }

    @Override
    public Configuration setCriticalAnalyzerCheckPeriod(long checkPeriod) {
        this.criticalAnalyzerCheckPeriod = checkPeriod;
        return this;
    }

    @Override
    public CriticalAnalyzerPolicy getCriticalAnalyzerPolicy() {
        return this.criticalAnalyzerPolicy;
    }

    @Override
    public Configuration setCriticalAnalyzerPolicy(CriticalAnalyzerPolicy policy) {
        this.criticalAnalyzerPolicy = policy;
        return this;
    }

    @Override
    public int getPageSyncTimeout() {
        return this.pageSyncTimeout;
    }

    @Override
    public ConfigurationImpl setPageSyncTimeout(int pageSyncTimeout) {
        this.pageSyncTimeout = pageSyncTimeout;
        return this;
    }

    public File subFolder(String subFolder) {
        try {
            return this.getBrokerInstance().toPath().resolve(subFolder).toFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTemporaryQueueNamespace() {
        return this.getUuidNamespace();
    }

    @Override
    public ConfigurationImpl setTemporaryQueueNamespace(String temporaryQueueNamespace) {
        return this.setUuidNamespace(temporaryQueueNamespace);
    }

    @Override
    public String getUuidNamespace() {
        return this.uuidNamespace;
    }

    @Override
    public ConfigurationImpl setUuidNamespace(String uuidNamespace) {
        this.uuidNamespace = uuidNamespace;
        return this;
    }

    @Override
    public int getJournalMaxAtticFiles() {
        return this.journalMaxAtticFilesFiles;
    }

    @Override
    public Configuration setJournalMaxAtticFiles(int maxAtticFiles) {
        this.journalMaxAtticFilesFiles = maxAtticFiles;
        return this;
    }

    @Override
    public long getMqttSessionScanInterval() {
        return this.mqttSessionScanInterval;
    }

    @Override
    public Configuration setMqttSessionScanInterval(long mqttSessionScanInterval) {
        this.mqttSessionScanInterval = mqttSessionScanInterval;
        return this;
    }

    @Override
    public long getMqttSessionStatePersistenceTimeout() {
        return this.mqttSessionStatePersistenceTimeout;
    }

    @Override
    public Configuration setMqttSessionStatePersistenceTimeout(long mqttSessionStatePersistenceTimeout) {
        this.mqttSessionStatePersistenceTimeout = mqttSessionStatePersistenceTimeout;
        return this;
    }

    @Override
    public boolean isMqttSubscriptionPersistenceEnabled() {
        return this.mqttSessionStatePersistenceEnabled;
    }

    @Override
    public Configuration setMqttSubscriptionPersistenceEnabled(boolean mqttSubscriptionPersistenceEnabled) {
        this.mqttSessionStatePersistenceEnabled = mqttSubscriptionPersistenceEnabled;
        return this;
    }

    @Override
    public boolean isSuppressSessionNotifications() {
        return this.suppressSessionNotifications;
    }

    @Override
    public Configuration setSuppressSessionNotifications(boolean suppressSessionNotifications) {
        this.suppressSessionNotifications = suppressSessionNotifications;
        return this;
    }

    @Override
    public synchronized String getStatus() {
        return this.getJsonStatus().toString();
    }

    @Override
    public synchronized void setStatus(String status) {
        JsonObject update = JsonUtil.readJsonObject((String)status);
        this.jsonStatus = JsonUtil.mergeAndUpdate((JsonObject)this.getJsonStatus(), (JsonObject)update);
    }

    @Override
    public String getLiteralMatchMarkers() {
        return this.literalMatchMarkers;
    }

    @Override
    public Configuration setLiteralMatchMarkers(String literalMatchMarkers) {
        this.literalMatchMarkers = literalMatchMarkers;
        return this;
    }

    @Override
    public Configuration setLargeMessageSync(boolean largeMessageSync) {
        this.largeMessageSync = largeMessageSync;
        return this;
    }

    @Override
    public boolean isLargeMessageSync() {
        return this.largeMessageSync;
    }

    @Override
    public String getViewPermissionMethodMatchPattern() {
        return this.viewPermissionMethodMatchPattern;
    }

    @Override
    public void setViewPermissionMethodMatchPattern(String permissionMatchPattern) {
        this.viewPermissionMethodMatchPattern = permissionMatchPattern;
    }

    @Override
    public boolean isManagementMessageRbac() {
        return this.managementMessagesRbac;
    }

    @Override
    public void setManagementMessageRbac(boolean val) {
        this.managementMessagesRbac = val;
    }

    @Override
    public String getManagementRbacPrefix() {
        return this.managementRbacPrefix;
    }

    @Override
    public void setManagementRbacPrefix(String prefix) {
        this.managementRbacPrefix = prefix;
    }

    @Override
    public int getMirrorAckManagerQueueAttempts() {
        return this.mirrorAckManagerQueueAttempts;
    }

    @Override
    public boolean isMirrorAckManagerWarnUnacked() {
        return this.mirrorAckManagerWarnUnacked;
    }

    @Override
    public ConfigurationImpl setMirrorAckManagerWarnUnacked(boolean warnUnacked) {
        this.mirrorAckManagerWarnUnacked = warnUnacked;
        return this;
    }

    @Override
    public ConfigurationImpl setMirrorAckManagerQueueAttempts(int minQueueAttempts) {
        logger.debug("Setting mirrorAckManagerMinQueueAttempts = {}", (Object)minQueueAttempts);
        this.mirrorAckManagerQueueAttempts = minQueueAttempts;
        return this;
    }

    @Override
    public ConfigurationImpl setPurgePageFolders(boolean purgePageFolders) {
        this.purgePageFolders = purgePageFolders;
        return this;
    }

    @Override
    public boolean isPurgePageFolders() {
        return this.purgePageFolders;
    }

    @Override
    public int getMirrorAckManagerPageAttempts() {
        return this.mirrorAckManagerPageAttempts;
    }

    @Override
    public ConfigurationImpl setMirrorAckManagerPageAttempts(int maxPageAttempts) {
        logger.debug("Setting mirrorAckManagerMaxPageAttempts = {}", (Object)maxPageAttempts);
        this.mirrorAckManagerPageAttempts = maxPageAttempts;
        return this;
    }

    @Override
    public int getMirrorAckManagerRetryDelay() {
        return this.mirrorAckManagerRetryDelay;
    }

    @Override
    public ConfigurationImpl setMirrorAckManagerRetryDelay(int delay) {
        logger.debug("Setting mirrorAckManagerRetryDelay = {}", (Object)delay);
        this.mirrorAckManagerRetryDelay = delay;
        return this;
    }

    @Override
    public boolean isMirrorPageTransaction() {
        return this.mirrorPageTransaction;
    }

    @Override
    public Configuration setMirrorPageTransaction(boolean ignorePageTransactions) {
        logger.debug("Setting mirrorIgnorePageTransactions={}", (Object)ignorePageTransactions);
        this.mirrorPageTransaction = ignorePageTransactions;
        return this;
    }

    public static class InsertionOrderedProperties
    extends Properties {
        final LinkedHashMap<Object, Object> orderedMap = new LinkedHashMap();
        long fileChecksum = 0L;

        @Override
        public Object put(Object key, Object value) {
            return this.orderedMap.put(key.toString(), value.toString());
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.orderedMap.entrySet();
        }

        @Override
        public void clear() {
            this.orderedMap.clear();
        }

        public synchronized boolean loadJson(ConfigurationImpl configuration, InputStream inputStream) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                boolean bl = this.loadJson(configuration, reader);
                return bl;
            }
        }

        public synchronized boolean loadJson(ConfigurationImpl configuration, Reader reader) throws IOException {
            JsonObject jsonObject = JsonLoader.readObject((Reader)reader);
            String surroundString = this.determineSurroundString(configuration, jsonObject);
            this.loadJsonObject(surroundString, "", jsonObject);
            return true;
        }

        private void loadJsonObject(String keySurroundString, String parentKey, JsonObject jsonObject) {
            jsonObject.entrySet().stream().forEach((? super T jsonEntry) -> {
                JsonValue jsonValue = (JsonValue)jsonEntry.getValue();
                JsonValue.ValueType jsonValueType = jsonValue.getValueType();
                String jsonKey = (String)jsonEntry.getKey();
                jsonKey = this.autoSurroundIfNecessary(jsonKey, keySurroundString);
                String propertyKey = parentKey + jsonKey;
                switch (jsonValueType) {
                    case OBJECT: {
                        this.loadJsonObject(keySurroundString, propertyKey + ".", jsonValue.asJsonObject());
                        break;
                    }
                    case STRING: {
                        this.put(propertyKey, ((JsonString)jsonValue).getString());
                        break;
                    }
                    case NUMBER: 
                    case TRUE: 
                    case FALSE: {
                        this.put(propertyKey, jsonValue.toString());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("JSON value type not supported: " + String.valueOf(jsonValueType));
                    }
                }
            });
        }

        private String autoSurroundIfNecessary(String jsonKey, String keySurroundString) {
            Object result = jsonKey;
            if (this.keyNeedsAutoSurround(jsonKey, keySurroundString)) {
                result = keySurroundString + jsonKey + keySurroundString;
            }
            return result;
        }

        private boolean keyNeedsAutoSurround(String jsonKey, String keySurroundString) {
            return jsonKey.contains(".") && !jsonKey.startsWith("key.") && (!jsonKey.startsWith(keySurroundString) || !jsonKey.endsWith(keySurroundString));
        }

        private String determineSurroundString(ConfigurationImpl configuration, JsonObject jsonObject) {
            String surroundString = jsonObject.getString("key.surround", null);
            if (surroundString == null) {
                surroundString = jsonObject.getString("brokerPropertiesKeySurround", configuration.getBrokerPropertiesKeySurround());
            }
            return surroundString;
        }

        public void setFileChecksum(long value) {
            this.fileChecksum = value;
        }

        public long getFileChecksum() {
            return this.fileChecksum;
        }
    }

    private static class CollectionAutoFillPropertiesUtil
    extends PropertyUtilsBean {
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
        final Stack<Pair<String, Object>> collections = new Stack();
        final String removeValue;
        private BeanUtilsBean beanUtilsBean;

        CollectionAutoFillPropertiesUtil(String brokerPropertiesRemoveValue) {
            this.removeValue = brokerPropertiesRemoveValue;
        }

        public void setProperty(Object bean, String name, Object value) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            if (!this.collections.isEmpty()) {
                Pair<String, Object> pair = this.collections.pop();
            }
            if (bean instanceof Map) {
                String property = this.getResolver().getProperty(name);
                this.setPropertyOfMapBean((Map)bean, property, value);
            } else {
                super.setProperty(bean, name, value);
            }
        }

        public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.collections.isEmpty()) {
                String key = this.getResolver().getProperty(name);
                Pair<String, Object> collectionInfo = this.collections.pop();
                if (bean instanceof Map) {
                    Map map = (Map)bean;
                    if (!map.containsKey(key)) {
                        map.put(key, this.newNamedInstanceForCollection((String)collectionInfo.getA(), collectionInfo.getB(), key));
                    }
                    Object value = map.get(key);
                    return this.trackCollectionOrMap(null, value, value);
                }
                Object value = this.findByNameProperty(key, (Collection)bean);
                if (value == null) {
                    value = this.newNamedInstanceForCollection((String)collectionInfo.getA(), collectionInfo.getB(), key);
                    ((Collection)bean).add(value);
                }
                return this.trackCollectionOrMap(null, value, value);
            }
            Object resolved = null;
            try {
                resolved = this.getNestedProperty(bean, name);
            }
            catch (NoSuchMethodException e) {
                throw new InvocationTargetException(e, "Cannot access property with key: " + name);
            }
            return this.trackCollectionOrMap(name, resolved, bean);
        }

        private Object trackCollectionOrMap(String name, Object resolved, Object bean) {
            if (resolved instanceof Collection || resolved instanceof Map) {
                this.collections.push((Pair<String, Object>)new Pair((Object)name, bean));
            }
            return resolved;
        }

        private Object findByNameProperty(String key, Collection collection) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            if (ConfigurationImpl.isClassProperty(key)) {
                String propertyClassName = ConfigurationImpl.extractPropertyClassName(key);
                for (Object candidate : collection) {
                    if (!candidate.getClass().getName().equals(propertyClassName)) continue;
                    return candidate;
                }
            } else {
                for (Object candidate : collection) {
                    Object candidateName = this.getProperty(candidate, "name");
                    if (candidateName == null || !key.equals(candidateName.toString())) continue;
                    return candidate;
                }
            }
            return null;
        }

        private Object removeByNameProperty(String key, Collection collection) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            for (Object candidate : collection) {
                Object candidateName = this.getProperty(candidate, "name");
                if (candidateName == null || !key.equals(candidateName.toString())) continue;
                collection.remove(candidate);
                break;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (bean == null) {
                throw new IllegalArgumentException("No bean specified");
            }
            if (name == null) {
                throw new IllegalArgumentException("No name specified for bean class '" + String.valueOf(bean.getClass()) + "'");
            }
            if (key == null) {
                throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + String.valueOf(bean.getClass()) + "'");
            }
            Object result = null;
            PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + String.valueOf(bean.getClass()) + "'");
            }
            if (descriptor instanceof MappedPropertyDescriptor) {
                MappedPropertyDescriptor mappedPropertyDescriptor = (MappedPropertyDescriptor)descriptor;
                Method readMethod = mappedPropertyDescriptor.getMappedReadMethod();
                readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), (Method)readMethod);
                if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + String.valueOf(bean.getClass()) + "'");
                Object[] keyArray = new Object[]{key};
                return readMethod.invoke(bean, keyArray);
            }
            Method readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), (Method)descriptor.getReadMethod());
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + String.valueOf(bean.getClass()) + "'");
            Object invokeResult = readMethod.invoke(bean, EMPTY_OBJECT_ARRAY);
            if (invokeResult instanceof Map) {
                Map map = (Map)invokeResult;
                return map.get(key);
            }
            if (!(invokeResult instanceof Collection)) return result;
            Collection collection = (Collection)invokeResult;
            return this.findByNameProperty(key, collection);
        }

        private Object newNamedInstanceForCollection(String collectionPropertyName, Object hostingBean, String name) {
            StringBuilder addPropertyNameBuilder = new StringBuilder("add");
            if (collectionPropertyName != null && !collectionPropertyName.isEmpty()) {
                addPropertyNameBuilder.append(Character.toUpperCase(collectionPropertyName.charAt(0)));
                if (collectionPropertyName.endsWith("ies")) {
                    addPropertyNameBuilder.append(collectionPropertyName, 1, collectionPropertyName.length() - 3);
                    addPropertyNameBuilder.append('y');
                } else if (collectionPropertyName.endsWith("Map")) {
                    addPropertyNameBuilder.append(collectionPropertyName, 1, collectionPropertyName.length() - 3);
                } else {
                    addPropertyNameBuilder.append(collectionPropertyName, 1, collectionPropertyName.length() - 1);
                }
            }
            Object instance = null;
            try {
                String addPropertyName = addPropertyNameBuilder.toString();
                Method[] methods = hostingBean.getClass().getMethods();
                Method candidate = Arrays.stream(methods).filter(method -> method.getName().equals(addPropertyName) && (method.getParameterCount() == 1 || method.getParameterCount() == 2 && String.class.equals(method.getParameterTypes()[0]) && !String.class.equals(method.getParameterTypes()[1]))).sorted((method1, method2) -> {
                    int result = method2.getParameterCount() - method1.getParameterCount();
                    if (result == 0) {
                        result = method1.getDeclaredAnnotation(Deprecated.class) == null ? 1 : -1;
                    }
                    return result;
                }).findFirst().orElse(null);
                if (candidate == null) {
                    throw new IllegalArgumentException("failed to locate add method for collection property " + addPropertyName);
                }
                Class<?> type = candidate.getParameterTypes()[candidate.getParameterCount() - 1];
                if (ConfigurationImpl.isClassProperty(name)) {
                    String clazzName = ConfigurationImpl.extractPropertyClassName(name);
                    instance = ClassloadingUtil.getInstanceWithTypeCheck((String)clazzName, type, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                } else {
                    instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                try {
                    this.beanUtilsBean.setProperty(instance, "name", (Object)name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return instance;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to add entry for {} to collection: {}", new Object[]{name, hostingBean, e});
                }
                throw new IllegalArgumentException("failed to add entry for collection key " + name + ", cause " + e.getMessage(), e);
            }
        }

        public void setBeanUtilsBean(BeanUtilsBean beanUtilsBean) {
            this.beanUtilsBean = beanUtilsBean;
        }

        public boolean isRemoveValue(Object value) {
            return this.removeValue != null && this.removeValue.equals(value);
        }
    }

    private static class SurroundResolver
    extends DefaultResolver {
        final String surroundString;

        SurroundResolver(String surroundString) {
            this.surroundString = surroundString;
        }

        public String next(String expression) {
            String result = super.next(expression);
            if (result != null && result.startsWith(this.surroundString)) {
                result = expression.substring(expression.indexOf(this.surroundString));
                return result.substring(0, result.indexOf(this.surroundString, this.surroundString.length()) + this.surroundString.length());
            }
            return result;
        }

        public String getProperty(String expression) {
            if (expression.startsWith(this.surroundString) && expression.endsWith(this.surroundString)) {
                return expression.substring(this.surroundString.length(), expression.length() - this.surroundString.length());
            }
            return super.getProperty(expression);
        }
    }
}

