/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.auth.AuthToken;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class FixedMembershipToken
extends AuthToken {
    private final List<InetSocketAddress> memberList = new ArrayList<InetSocketAddress>();
    private String token = "emptyToken";
    @Property
    private String fixed_members_seperator = ",";

    public FixedMembershipToken() {
    }

    public FixedMembershipToken(String token) {
        this.token = token;
    }

    @Override
    public String getName() {
        return "org.apache.activemq.artemis.shaded.org.jgroups.auth.FixedMembershipToken";
    }

    @Property
    public void setFixedMembersSeparator(String value) {
        this.fixed_members_seperator = value;
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (token instanceof FixedMembershipToken && this.memberList != null) {
            PhysicalAddress src = (PhysicalAddress)this.auth.down(new Event(87, msg.getSrc()));
            if (src == null) {
                this.log.error(Util.getMessage("DidnTFindPhysicalAddressFor") + msg.getSrc());
                return false;
            }
            return this.isInMembersList((IpAddress)src);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    public boolean isInMembersList(IpAddress sender) {
        if (this.memberList == null || sender == null) {
            return false;
        }
        for (InetSocketAddress addr : this.memberList) {
            if (!FixedMembershipToken.match(sender, addr)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(IpAddress sender, InetSocketAddress addr) {
        return sender != null && addr != null && addr.getAddress().equals(sender.getIpAddress()) && (addr.getPort() == 0 || addr.getPort() == sender.getPort());
    }

    @Property(name="fixed_members_value")
    public void setMemberList(String list) throws UnknownHostException {
        this.memberList.clear();
        StringTokenizer memberListTokenizer = new StringTokenizer(list, this.fixed_members_seperator);
        while (memberListTokenizer.hasMoreTokens()) {
            String tmp = memberListTokenizer.nextToken().trim();
            int index = tmp.lastIndexOf(47);
            int port = index != -1 ? Integer.parseInt(tmp.substring(index + 1)) : 0;
            String addr_str = index != -1 ? tmp.substring(0, index) : tmp;
            InetAddress addr = InetAddress.getByName(addr_str);
            this.memberList.add(new InetSocketAddress(addr, port));
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Bits.writeString(this.token, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.token = Bits.readString(in);
    }

    @Override
    public int size() {
        return Util.size(this.token);
    }
}

