/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.Server;
import alluxio.underfs.UfsManager;
import alluxio.worker.WorkerFactory;
import alluxio.worker.WorkerRegistry;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.keyvalue.KeyValueWorker;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueWorkerFactory
implements WorkerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueWorkerFactory.class);

    public boolean isEnabled() {
        return Configuration.getBoolean((PropertyKey)PropertyKey.KEY_VALUE_ENABLED);
    }

    public KeyValueWorker create(WorkerRegistry registry, UfsManager ufsManager) {
        LOG.info("Creating {} ", (Object)KeyValueWorker.class.getName());
        BlockWorker blockWorker = (BlockWorker)registry.get(BlockWorker.class);
        KeyValueWorker keyValueWorker = new KeyValueWorker(blockWorker);
        registry.add(KeyValueWorker.class, (Server)keyValueWorker);
        return keyValueWorker;
    }
}

