/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.RpcUtils;
import alluxio.client.keyvalue.ByteBufferKeyValuePartitionReader;
import alluxio.client.keyvalue.Index;
import alluxio.client.keyvalue.PayloadReader;
import alluxio.exception.AlluxioException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.GetNextKeysTOptions;
import alluxio.thrift.GetNextKeysTResponse;
import alluxio.thrift.GetServiceVersionTOptions;
import alluxio.thrift.GetServiceVersionTResponse;
import alluxio.thrift.GetSizeTOptions;
import alluxio.thrift.GetSizeTResponse;
import alluxio.thrift.GetTOptions;
import alluxio.thrift.GetTResponse;
import alluxio.thrift.KeyValueWorkerClientService;
import alluxio.util.io.BufferUtils;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueWorkerClientServiceHandler
implements KeyValueWorkerClientService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueWorkerClientServiceHandler.class);
    private final BlockWorker mBlockWorker;

    KeyValueWorkerClientServiceHandler(BlockWorker blockWorker) {
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
    }

    public GetServiceVersionTResponse getServiceVersion(GetServiceVersionTOptions options) {
        return new GetServiceVersionTResponse(2L);
    }

    public GetTResponse get(final long blockId, final ByteBuffer key, GetTOptions options) throws AlluxioTException {
        return (GetTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<GetTResponse>(){

            public GetTResponse call() throws AlluxioException, IOException {
                ByteBuffer value = KeyValueWorkerClientServiceHandler.this.getInternal(blockId, key);
                if (value == null) {
                    return new GetTResponse(ByteBuffer.allocate(0));
                }
                return new GetTResponse(KeyValueWorkerClientServiceHandler.this.copyAsNonDirectBuffer(value));
            }
        });
    }

    private ByteBuffer copyAsNonDirectBuffer(ByteBuffer directBuffer) {
        return BufferUtils.cloneByteBuffer((ByteBuffer)directBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getInternal(long blockId, ByteBuffer keyBuffer) throws BlockDoesNotExistException, IOException {
        long sessionId = -6L;
        long lockId = this.mBlockWorker.lockBlock(-6L, blockId);
        try {
            ByteBuffer byteBuffer = this.getReader(-6L, lockId, blockId).get(keyBuffer);
            return byteBuffer;
        }
        catch (InvalidWorkerStateException e) {
            LOG.error("Reaching invalid state to get a key", (Throwable)e);
        }
        finally {
            this.mBlockWorker.unlockBlock(lockId);
        }
        return null;
    }

    private ByteBufferKeyValuePartitionReader getReader(long sessionId, long lockId, long blockId) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        BlockReader blockReader = this.mBlockWorker.readBlockRemote(sessionId, blockId, lockId);
        ByteBuffer fileBuffer = blockReader.read(0L, blockReader.getLength());
        ByteBufferKeyValuePartitionReader reader = new ByteBufferKeyValuePartitionReader(fileBuffer);
        blockReader.close();
        return reader;
    }

    public GetNextKeysTResponse getNextKeys(final long blockId, final ByteBuffer key, final int numKeys, GetNextKeysTOptions options) throws AlluxioTException {
        return (GetNextKeysTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<GetNextKeysTResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public GetNextKeysTResponse call() throws AlluxioException, IOException {
                long sessionId = -6L;
                long lockId = KeyValueWorkerClientServiceHandler.this.mBlockWorker.lockBlock(-6L, blockId);
                try {
                    ByteBuffer nextKey;
                    ByteBufferKeyValuePartitionReader reader = KeyValueWorkerClientServiceHandler.this.getReader(-6L, lockId, blockId);
                    Index index = reader.getIndex();
                    PayloadReader payloadReader = reader.getPayloadReader();
                    ArrayList ret = Lists.newArrayListWithExpectedSize((int)numKeys);
                    ByteBuffer currentKey = key;
                    for (int i = 0; i < numKeys && (nextKey = index.nextKey(currentKey, payloadReader)) != null; ++i) {
                        ret.add(KeyValueWorkerClientServiceHandler.this.copyAsNonDirectBuffer(nextKey));
                        currentKey = nextKey;
                    }
                    GetNextKeysTResponse getNextKeysTResponse = new GetNextKeysTResponse((List)ret);
                    return getNextKeysTResponse;
                }
                catch (InvalidWorkerStateException e) {
                    LOG.error("Reaching invalid state to get all keys", (Throwable)e);
                }
                finally {
                    KeyValueWorkerClientServiceHandler.this.mBlockWorker.unlockBlock(lockId);
                }
                return new GetNextKeysTResponse();
            }
        });
    }

    public GetSizeTResponse getSize(final long blockId, GetSizeTOptions options) throws AlluxioTException {
        return (GetSizeTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<GetSizeTResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public GetSizeTResponse call() throws AlluxioException, IOException {
                long sessionId = -6L;
                long lockId = KeyValueWorkerClientServiceHandler.this.mBlockWorker.lockBlock(-6L, blockId);
                try {
                    GetSizeTResponse getSizeTResponse = new GetSizeTResponse(KeyValueWorkerClientServiceHandler.this.getReader(-6L, lockId, blockId).size());
                    return getSizeTResponse;
                }
                catch (InvalidWorkerStateException e) {
                    LOG.error("Reaching invalid state to get size", (Throwable)e);
                }
                finally {
                    KeyValueWorkerClientServiceHandler.this.mBlockWorker.unlockBlock(lockId);
                }
                return new GetSizeTResponse(0);
            }
        });
    }
}

