/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.Server;
import alluxio.thrift.KeyValueWorkerClientService;
import alluxio.util.ThreadFactoryUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AbstractWorker;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.keyvalue.KeyValueWorkerClientServiceHandler;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TProcessor;

@ThreadSafe
public final class KeyValueWorker
extends AbstractWorker {
    private static final Set<Class<? extends Server>> DEPS = ImmutableSet.of(BlockWorker.class);
    private final KeyValueWorkerClientServiceHandler mKeyValueServiceHandler;

    KeyValueWorker(BlockWorker blockWorker) {
        super(Executors.newFixedThreadPool(1, ThreadFactoryUtils.build((String)"keyvalue-worker-heartbeat-%d", (boolean)true)));
        this.mKeyValueServiceHandler = new KeyValueWorkerClientServiceHandler(blockWorker);
    }

    public Set<Class<? extends Server>> getDependencies() {
        return DEPS;
    }

    public String getName() {
        return "KeyValueWorker";
    }

    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("KeyValueWorkerClient", (TProcessor)new KeyValueWorkerClientService.Processor((KeyValueWorkerClientService.Iface)this.mKeyValueServiceHandler));
        return services;
    }

    public void start(WorkerNetAddress address) {
    }

    public void stop() throws IOException {
    }
}

