/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.Server;
import alluxio.master.MasterFactory;
import alluxio.master.MasterRegistry;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.journal.JournalSystem;
import alluxio.master.keyvalue.DefaultKeyValueMaster;
import alluxio.master.keyvalue.KeyValueMaster;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueMasterFactory
implements MasterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueMasterFactory.class);

    public boolean isEnabled() {
        return Configuration.getBoolean((PropertyKey)PropertyKey.KEY_VALUE_ENABLED);
    }

    public String getName() {
        return "KeyValueMaster";
    }

    public KeyValueMaster create(MasterRegistry registry, JournalSystem journalSystem) {
        Preconditions.checkNotNull((Object)journalSystem, (Object)"journalSystem");
        LOG.info("Creating {} ", (Object)KeyValueMaster.class.getName());
        FileSystemMaster fileSystemMaster = (FileSystemMaster)registry.get(FileSystemMaster.class);
        DefaultKeyValueMaster keyValueMaster = new DefaultKeyValueMaster(fileSystemMaster, journalSystem);
        registry.add(KeyValueMaster.class, (Server)keyValueMaster);
        return keyValueMaster;
    }
}

