/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.AlluxioURI;
import alluxio.RpcUtils;
import alluxio.exception.AlluxioException;
import alluxio.master.keyvalue.KeyValueMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.CompletePartitionTOptions;
import alluxio.thrift.CompletePartitionTResponse;
import alluxio.thrift.CompleteStoreTOptions;
import alluxio.thrift.CompleteStoreTResponse;
import alluxio.thrift.CreateStoreTOptions;
import alluxio.thrift.CreateStoreTResponse;
import alluxio.thrift.DeleteStoreTOptions;
import alluxio.thrift.DeleteStoreTResponse;
import alluxio.thrift.GetPartitionInfoTOptions;
import alluxio.thrift.GetPartitionInfoTResponse;
import alluxio.thrift.GetServiceVersionTOptions;
import alluxio.thrift.GetServiceVersionTResponse;
import alluxio.thrift.KeyValueMasterClientService;
import alluxio.thrift.MergeStoreTOptions;
import alluxio.thrift.MergeStoreTResponse;
import alluxio.thrift.PartitionInfo;
import alluxio.thrift.RenameStoreTOptions;
import alluxio.thrift.RenameStoreTResponse;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueMasterClientServiceHandler
implements KeyValueMasterClientService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueMasterClientServiceHandler.class);
    private final KeyValueMaster mKeyValueMaster;

    KeyValueMasterClientServiceHandler(KeyValueMaster keyValueMaster) {
        this.mKeyValueMaster = keyValueMaster;
    }

    public GetServiceVersionTResponse getServiceVersion(GetServiceVersionTOptions options) {
        return new GetServiceVersionTResponse(2L);
    }

    public CompletePartitionTResponse completePartition(final String path, final PartitionInfo info, CompletePartitionTOptions options) throws AlluxioTException {
        return (CompletePartitionTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallable)new RpcUtils.RpcCallable<CompletePartitionTResponse>(){

            public CompletePartitionTResponse call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.completePartition(new AlluxioURI(path), info);
                return new CompletePartitionTResponse();
            }
        });
    }

    public CreateStoreTResponse createStore(final String path, CreateStoreTOptions options) throws AlluxioTException {
        return (CreateStoreTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallable)new RpcUtils.RpcCallable<CreateStoreTResponse>(){

            public CreateStoreTResponse call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.createStore(new AlluxioURI(path));
                return new CreateStoreTResponse();
            }
        });
    }

    public CompleteStoreTResponse completeStore(final String path, CompleteStoreTOptions options) throws AlluxioTException {
        return (CompleteStoreTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallable)new RpcUtils.RpcCallable<CompleteStoreTResponse>(){

            public CompleteStoreTResponse call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.completeStore(new AlluxioURI(path));
                return new CompleteStoreTResponse();
            }
        });
    }

    public DeleteStoreTResponse deleteStore(final String path, DeleteStoreTOptions options) throws AlluxioTException {
        return (DeleteStoreTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<DeleteStoreTResponse>(){

            public DeleteStoreTResponse call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.deleteStore(new AlluxioURI(path));
                return new DeleteStoreTResponse();
            }
        });
    }

    public GetPartitionInfoTResponse getPartitionInfo(final String path, GetPartitionInfoTOptions options) throws AlluxioTException {
        return (GetPartitionInfoTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallable)new RpcUtils.RpcCallable<GetPartitionInfoTResponse>(){

            public GetPartitionInfoTResponse call() throws AlluxioException {
                return new GetPartitionInfoTResponse(KeyValueMasterClientServiceHandler.this.mKeyValueMaster.getPartitionInfo(new AlluxioURI(path)));
            }
        });
    }

    public MergeStoreTResponse mergeStore(final String fromPath, final String toPath, MergeStoreTOptions options) throws AlluxioTException {
        return (MergeStoreTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<MergeStoreTResponse>(){

            public MergeStoreTResponse call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.mergeStore(new AlluxioURI(fromPath), new AlluxioURI(toPath));
                return new MergeStoreTResponse();
            }
        });
    }

    public RenameStoreTResponse renameStore(final String oldPath, final String newPath, RenameStoreTOptions options) throws AlluxioTException {
        return (RenameStoreTResponse)RpcUtils.call((Logger)LOG, (RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<RenameStoreTResponse>(){

            public RenameStoreTResponse call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.renameStore(new AlluxioURI(oldPath), new AlluxioURI(newPath));
                return new RenameStoreTResponse();
            }
        });
    }
}

